/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.net.tcp;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import zmq.ZError;
import zmq.io.net.Address;

public class TcpUtils {
    private TcpUtils() {
    }

    public static void tuneTcpSocket(SocketChannel channel) throws IOException {
        TcpUtils.setOption(channel, StandardSocketOptions.TCP_NODELAY, true);
        try {
            channel.socket().setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public static void tuneTcpKeepalives(SocketChannel channel, int tcpKeepAlive, int tcpKeepAliveCnt, int tcpKeepAliveIdle, int tcpKeepAliveIntvl) throws IOException {
        boolean keepAlive = tcpKeepAlive == 1;
        TcpUtils.setOption(channel, StandardSocketOptions.SO_KEEPALIVE, keepAlive);
        try {
            channel.socket().setKeepAlive(keepAlive);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public static boolean setTcpReceiveBuffer(NetworkChannel channel, int rcvbuf) {
        return TcpUtils.setOption(channel, StandardSocketOptions.SO_RCVBUF, rcvbuf);
    }

    public static boolean setTcpSendBuffer(NetworkChannel channel, int sndbuf) {
        return TcpUtils.setOption(channel, StandardSocketOptions.SO_SNDBUF, sndbuf);
    }

    public static boolean setIpTypeOfService(NetworkChannel channel, int tos) {
        return TcpUtils.setOption(channel, StandardSocketOptions.IP_TOS, tos);
    }

    public static boolean setReuseAddress(NetworkChannel channel, boolean reuse) {
        return TcpUtils.setOption(channel, StandardSocketOptions.SO_REUSEADDR, reuse);
    }

    private static <T> boolean setOption(NetworkChannel channel, SocketOption<T> option, T value) {
        try {
            if (channel.supportedOptions().contains(option)) {
                channel.setOption(option, value);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
    }

    public static void unblockSocket(SelectableChannel ... channels) throws IOException {
        for (SelectableChannel ch : channels) {
            ch.configureBlocking(false);
        }
    }

    public static void enableIpv4Mapping(SelectableChannel channel) {
    }

    public static Address getPeerIpAddress(SocketChannel channel) {
        SocketAddress address = channel.socket().getRemoteSocketAddress();
        return new Address(address);
    }
}

