/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.mechanism.curve;

import com.neilalexander.jnacl.crypto.curve25519xsalsa20poly1305;
import com.neilalexander.jnacl.crypto.xsalsa20poly1305;
import java.nio.ByteBuffer;
import zmq.util.Utils;
import zmq.util.Z85;

public class Curve {
    public static String z85EncodePublic(byte[] publicKey) {
        return Z85.encode(publicKey, Size.PUBLICKEY.bytes());
    }

    public String[] keypairZ85() {
        String[] pair = new String[2];
        byte[] publicKey = new byte[Size.PUBLICKEY.bytes()];
        byte[] secretKey = new byte[Size.SECRETKEY.bytes()];
        int rc = curve25519xsalsa20poly1305.crypto_box_keypair((byte[])publicKey, (byte[])secretKey);
        assert (rc == 0);
        pair[0] = Z85.encode(publicKey, Size.PUBLICKEY.bytes());
        pair[1] = Z85.encode(secretKey, Size.SECRETKEY.bytes());
        return pair;
    }

    public byte[][] keypair() {
        byte[][] pair = new byte[2][];
        byte[] publicKey = new byte[Size.PUBLICKEY.bytes()];
        byte[] secretKey = new byte[Size.SECRETKEY.bytes()];
        int rc = curve25519xsalsa20poly1305.crypto_box_keypair((byte[])publicKey, (byte[])secretKey);
        assert (rc == 0);
        pair[0] = publicKey;
        pair[1] = secretKey;
        return pair;
    }

    int beforenm(byte[] outSharedKey, byte[] publicKey, byte[] secretKey) {
        return curve25519xsalsa20poly1305.crypto_box_beforenm((byte[])outSharedKey, (byte[])publicKey, (byte[])secretKey);
    }

    int afternm(ByteBuffer ciphered, ByteBuffer plaintext, int length, ByteBuffer nonce, byte[] precom) {
        return this.afternm(ciphered.array(), plaintext.array(), length, nonce.array(), precom);
    }

    int afternm(byte[] ciphered, byte[] plaintext, int length, byte[] nonce, byte[] precomp) {
        return curve25519xsalsa20poly1305.crypto_box_afternm((byte[])ciphered, (byte[])plaintext, (long)length, (byte[])nonce, (byte[])precomp);
    }

    int openAfternm(ByteBuffer plaintext, ByteBuffer messagebox, int length, ByteBuffer nonce, byte[] precom) {
        return this.openAfternm(plaintext.array(), messagebox.array(), length, nonce.array(), precom);
    }

    int openAfternm(byte[] plaintext, byte[] cipher, int length, byte[] nonce, byte[] precom) {
        return curve25519xsalsa20poly1305.crypto_box_open_afternm((byte[])plaintext, (byte[])cipher, (long)length, (byte[])nonce, (byte[])precom);
    }

    int open(ByteBuffer plaintext, ByteBuffer messagebox, int length, ByteBuffer nonce, byte[] precom, byte[] secretKey) {
        return this.open(plaintext.array(), messagebox.array(), length, nonce.array(), precom, secretKey);
    }

    int open(byte[] plaintext, byte[] messagebox, int length, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        return curve25519xsalsa20poly1305.crypto_box_open((byte[])plaintext, (byte[])messagebox, (long)length, (byte[])nonce, (byte[])publicKey, (byte[])secretKey);
    }

    int secretbox(ByteBuffer ciphertext, ByteBuffer plaintext, int length, ByteBuffer nonce, byte[] key) {
        return this.secretbox(ciphertext.array(), plaintext.array(), length, nonce.array(), key);
    }

    int secretbox(byte[] ciphertext, byte[] plaintext, int length, byte[] nonce, byte[] key) {
        return xsalsa20poly1305.crypto_secretbox((byte[])ciphertext, (byte[])plaintext, (long)length, (byte[])nonce, (byte[])key);
    }

    int secretboxOpen(ByteBuffer plaintext, ByteBuffer box, int length, ByteBuffer nonce, byte[] key) {
        return this.secretboxOpen(plaintext.array(), box.array(), length, nonce.array(), key);
    }

    int secretboxOpen(byte[] plaintext, byte[] box, int length, byte[] nonce, byte[] key) {
        return xsalsa20poly1305.crypto_secretbox_open((byte[])plaintext, (byte[])box, (long)length, (byte[])nonce, (byte[])key);
    }

    byte[] random(int length) {
        return Utils.randomBytes(length);
    }

    public int box(ByteBuffer ciphertext, ByteBuffer plaintext, int length, ByteBuffer nonce, byte[] publicKey, byte[] secretKey) {
        return this.box(ciphertext.array(), plaintext.array(), length, nonce.array(), publicKey, secretKey);
    }

    public int box(byte[] ciphertext, byte[] plaintext, int length, byte[] nonce, byte[] publicKey, byte[] secretKey) {
        return curve25519xsalsa20poly1305.crypto_box((byte[])ciphertext, (byte[])plaintext, (long)length, (byte[])nonce, (byte[])publicKey, (byte[])secretKey);
    }

    static enum Size {
        NONCE{

            @Override
            public int bytes() {
                return 24;
            }
        }
        ,
        ZERO{

            @Override
            public int bytes() {
                return 32;
            }
        }
        ,
        BOXZERO{

            @Override
            public int bytes() {
                return 16;
            }
        }
        ,
        PUBLICKEY{

            @Override
            public int bytes() {
                return 32;
            }
        }
        ,
        SECRETKEY{

            @Override
            public int bytes() {
                return 32;
            }
        }
        ,
        KEY{

            @Override
            public int bytes() {
                return 32;
            }
        }
        ,
        BEFORENM{

            @Override
            public int bytes() {
                return 32;
            }
        };


        public abstract int bytes();
    }
}

