/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.zeromq.SocketType;
import org.zeromq.Utils;
import org.zeromq.ZContext;
import org.zeromq.ZMQException;
import org.zeromq.ZMonitor;
import org.zeromq.proto.ZPicture;
import zmq.Ctx;
import zmq.Msg;
import zmq.SocketBase;
import zmq.ZError;
import zmq.ZMQ;
import zmq.io.coder.IDecoder;
import zmq.io.coder.IEncoder;
import zmq.io.mechanism.Mechanisms;
import zmq.io.net.SelectorProviderChooser;
import zmq.msg.MsgAllocator;
import zmq.util.Z85;

public class ZMQ {
    public static final int SNDMORE = 2;
    public static final int DONTWAIT = 1;
    public static final int NOBLOCK = 1;
    @Deprecated
    public static final int PAIR = 0;
    @Deprecated
    public static final int PUB = 1;
    @Deprecated
    public static final int SUB = 2;
    @Deprecated
    public static final int REQ = 3;
    @Deprecated
    public static final int REP = 4;
    @Deprecated
    public static final int DEALER = 5;
    @Deprecated
    public static final int XREQ = 5;
    @Deprecated
    public static final int ROUTER = 6;
    @Deprecated
    public static final int XREP = 6;
    @Deprecated
    public static final int PULL = 7;
    @Deprecated
    public static final int PUSH = 8;
    @Deprecated
    public static final int XPUB = 9;
    @Deprecated
    public static final int XSUB = 10;
    @Deprecated
    public static final int STREAM = 11;
    @Deprecated
    public static final int STREAMER = 1;
    @Deprecated
    public static final int FORWARDER = 2;
    @Deprecated
    public static final int QUEUE = 3;
    @Deprecated
    public static final int UPSTREAM = 7;
    @Deprecated
    public static final int DOWNSTREAM = 8;
    public static final int EVENT_CONNECTED = 1;
    public static final int EVENT_CONNECT_DELAYED = 2;
    @Deprecated
    public static final int EVENT_DELAYED = 2;
    public static final int EVENT_CONNECT_RETRIED = 4;
    @Deprecated
    public static final int EVENT_RETRIED = 4;
    public static final int EVENT_LISTENING = 8;
    public static final int EVENT_BIND_FAILED = 16;
    public static final int EVENT_ACCEPTED = 32;
    public static final int EVENT_ACCEPT_FAILED = 64;
    public static final int EVENT_CLOSED = 128;
    public static final int EVENT_CLOSE_FAILED = 256;
    public static final int EVENT_DISCONNECTED = 512;
    public static final int EVENT_MONITOR_STOPPED = 1024;
    public static final int EVENT_HANDSHAKE_PROTOCOL = 32768;
    public static final int EVENT_ALL = 65535;
    public static final int HANDSHAKE_FAILED_NO_DETAIL = 2048;
    public static final int HANDSHAKE_SUCCEEDED = 4096;
    public static final int HANDSHAKE_FAILED_PROTOCOL = 8192;
    public static final int HANDSHAKE_FAILED_AUTH = 16384;
    public static final byte[] MESSAGE_SEPARATOR = zmq.ZMQ.MESSAGE_SEPARATOR;
    public static final byte[] SUBSCRIPTION_ALL = zmq.ZMQ.SUBSCRIPTION_ALL;
    public static final byte[] PROXY_PAUSE = zmq.ZMQ.PROXY_PAUSE;
    public static final byte[] PROXY_RESUME = zmq.ZMQ.PROXY_RESUME;
    public static final byte[] PROXY_TERMINATE = zmq.ZMQ.PROXY_TERMINATE;
    public static final Charset CHARSET = zmq.ZMQ.CHARSET;

    private ZMQ() {
    }

    public static Context context(int ioThreads) {
        return new Context(ioThreads);
    }

    @Deprecated
    public static boolean device(int type, Socket frontend, Socket backend) {
        return zmq.ZMQ.proxy(frontend.base, backend.base, null);
    }

    public static boolean proxy(Socket frontend, Socket backend, Socket capture) {
        return zmq.ZMQ.proxy(frontend.base, backend.base, capture != null ? capture.base : null);
    }

    public static boolean proxy(Socket frontend, Socket backend, Socket capture, Socket control) {
        return zmq.ZMQ.proxy(frontend.base, backend.base, capture == null ? null : capture.base, control == null ? null : control.base);
    }

    public static int poll(Selector selector, PollItem[] items, long timeout) {
        return ZMQ.poll(selector, items, items.length, timeout);
    }

    public static int poll(Selector selector, PollItem[] items, int count, long timeout) {
        zmq.poll.PollItem[] pollItems = new zmq.poll.PollItem[count];
        for (int i = 0; i < count; ++i) {
            pollItems[i] = items[i].base;
        }
        return zmq.ZMQ.poll(selector, pollItems, count, timeout);
    }

    public static int getMajorVersion() {
        return 4;
    }

    public static int getMinorVersion() {
        return 1;
    }

    public static int getPatchVersion() {
        return 7;
    }

    public static int getFullVersion() {
        return zmq.ZMQ.makeVersion(4, 1, 7);
    }

    public static int makeVersion(int major, int minor, int patch) {
        return zmq.ZMQ.makeVersion(major, minor, patch);
    }

    public static String getVersionString() {
        return "4.1.7";
    }

    public static void msleep(long millis) {
        zmq.ZMQ.msleep(millis);
    }

    public static void sleep(long seconds) {
        zmq.ZMQ.sleep(seconds);
    }

    public static void sleep(long amount, TimeUnit unit) {
        zmq.ZMQ.sleep(amount, unit);
    }

    public static class CancellationToken {
        protected AtomicBoolean canceled;
        SocketBase socket;

        protected CancellationToken(SocketBase socket) {
            this.socket = socket;
            this.canceled = new AtomicBoolean(false);
        }

        public boolean isCancellationRequested() {
            return this.canceled.get();
        }

        public void reset() {
            this.canceled.set(false);
        }

        public void cancel() {
            this.socket.cancel(this.canceled);
        }
    }

    public static class Curve {
        public static final int KEY_SIZE = 32;
        public static final int KEY_SIZE_Z85 = 40;

        public static KeyPair generateKeyPair() {
            String[] keys = new zmq.io.mechanism.curve.Curve().keypairZ85();
            return new KeyPair(keys[0], keys[1]);
        }

        public static byte[] z85Decode(String key) {
            return Z85.decode(key);
        }

        public static String z85Encode(byte[] key) {
            return zmq.io.mechanism.curve.Curve.z85EncodePublic(key);
        }

        public static class KeyPair {
            public final String publicKey;
            public final String secretKey;

            public KeyPair(String publicKey, String secretKey) {
                Utils.checkArgument(publicKey != null, "Public key cannot be null");
                Utils.checkArgument(publicKey.length() == 40, "Public key has to be Z85 format");
                Utils.checkArgument(secretKey == null || secretKey.length() == 40, "Secret key has to be null or in Z85 format");
                this.publicKey = publicKey;
                this.secretKey = secretKey;
            }
        }
    }

    public static class Event {
        private final int event;
        private final Object value;
        private final Object resolvedValue;
        private final String address;

        public Event(int event, Object value, String address) {
            this.event = event;
            this.value = value;
            this.address = address;
            this.resolvedValue = value;
        }

        private Event(int event, Object value, Object resolvedValue, String address) {
            this.event = event;
            this.value = value;
            this.address = address;
            this.resolvedValue = resolvedValue;
        }

        public static Event recv(Socket socket, int flags) {
            Object resolvedValue;
            ZMQ.Event e = ZMQ.Event.read(socket.base, flags);
            switch (e.event) {
                case 8192: {
                    resolvedValue = ZMonitor.ProtocolCode.findByCode((Integer)e.arg);
                    break;
                }
                case 16: 
                case 64: 
                case 256: 
                case 2048: {
                    resolvedValue = Error.findByCode((Integer)e.arg);
                    break;
                }
                case 1: 
                case 8: 
                case 32: 
                case 128: 
                case 512: {
                    resolvedValue = e.getChannel(socket.base);
                    break;
                }
                case 2: 
                case 4096: {
                    resolvedValue = null;
                    break;
                }
                default: {
                    resolvedValue = e.arg;
                }
            }
            return new Event(e.event, e.arg, resolvedValue, e.addr);
        }

        public static Event recv(Socket socket) {
            return Event.recv(socket, 0);
        }

        public int getEvent() {
            return this.event;
        }

        public Object getValue() {
            return this.value;
        }

        public String getAddress() {
            return this.address;
        }

        public boolean isError() {
            switch (this.event) {
                case 16: 
                case 64: 
                case 256: 
                case 2048: 
                case 8192: {
                    return true;
                }
            }
            return false;
        }

        public boolean isWarn() {
            switch (this.event) {
                case 16384: {
                    return true;
                }
            }
            return false;
        }

        public <M> M resolveValue() {
            return (M)this.resolvedValue;
        }
    }

    public static class PollItem {
        private final zmq.poll.PollItem base;
        private final Socket socket;

        public PollItem(Socket socket, int ops) {
            this.socket = socket;
            this.base = new zmq.poll.PollItem(socket.base, ops);
        }

        public PollItem(SelectableChannel channel, int ops) {
            this.base = new zmq.poll.PollItem(channel, ops);
            this.socket = null;
        }

        final zmq.poll.PollItem base() {
            return this.base;
        }

        public final SelectableChannel getRawSocket() {
            return this.base.getRawSocket();
        }

        public final Socket getSocket() {
            return this.socket;
        }

        public final boolean isReadable() {
            return this.base.isReadable();
        }

        public final boolean isWritable() {
            return this.base.isWritable();
        }

        public final boolean isError() {
            return this.base.isError();
        }

        public final int readyOps() {
            return this.base.readyOps();
        }

        public int hashCode() {
            return this.base.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PollItem)) {
                return false;
            }
            PollItem target = (PollItem)obj;
            if (this.socket != null && this.socket == target.socket) {
                return true;
            }
            return this.getRawSocket() != null && this.getRawSocket() == target.getRawSocket();
        }
    }

    public static class Poller
    implements Closeable {
        public static final int POLLIN = 1;
        public static final int POLLOUT = 2;
        public static final int POLLERR = 4;
        private static final int SIZE_DEFAULT = 32;
        private static final int SIZE_INCREMENT = 16;
        private final Selector selector;
        private final Context context;
        private List<PollItem> items;
        private long timeout;

        protected Poller(Context context, int size) {
            assert (context != null);
            this.context = context;
            this.selector = context.selector();
            assert (this.selector != null);
            this.items = new ArrayList<PollItem>(size);
            this.timeout = -1L;
        }

        protected Poller(Context context) {
            this(context, 32);
        }

        @Override
        public void close() {
            this.context.close(this.selector);
        }

        public int register(Socket socket) {
            return this.register(socket, 7);
        }

        public int register(SelectableChannel channel) {
            return this.register(channel, 7);
        }

        public int register(Socket socket, int events) {
            return this.registerInternal(new PollItem(socket, events));
        }

        public int register(SelectableChannel channel, int events) {
            return this.registerInternal(new PollItem(channel, events));
        }

        public int register(PollItem item) {
            return this.registerInternal(item);
        }

        private int registerInternal(PollItem item) {
            this.items.add(item);
            return this.items.size() - 1;
        }

        public void unregister(Socket socket) {
            this.unregisterInternal(socket);
        }

        public void unregister(SelectableChannel channel) {
            this.unregisterInternal(channel);
        }

        private void unregisterInternal(Object socket) {
            Iterator<PollItem> it = this.items.iterator();
            while (it.hasNext()) {
                PollItem item = it.next();
                if (item.socket != socket && item.getRawSocket() != socket) continue;
                it.remove();
            }
        }

        public PollItem getItem(int index) {
            if (index < 0 || index >= this.items.size()) {
                return null;
            }
            return this.items.get(index);
        }

        public Socket getSocket(int index) {
            if (index < 0 || index >= this.items.size()) {
                return null;
            }
            return this.items.get(index).socket;
        }

        @Deprecated
        public long getTimeout() {
            return this.timeout;
        }

        @Deprecated
        public void setTimeout(long timeout) {
            if (timeout >= -1L) {
                this.timeout = timeout;
            }
        }

        public int getSize() {
            return this.items.size();
        }

        @Deprecated
        public int getNext() {
            return this.items.size();
        }

        public int poll() {
            long tout = -1L;
            if (this.timeout > -1L) {
                tout = this.timeout;
            }
            return this.poll(tout);
        }

        public int poll(long tout) {
            if (tout < -1L) {
                return 0;
            }
            if (this.items.isEmpty()) {
                return 0;
            }
            zmq.poll.PollItem[] pollItems = new zmq.poll.PollItem[this.items.size()];
            int j = 0;
            for (int i = 0; i < this.items.size(); ++i) {
                if (this.items.get(i) == null) continue;
                pollItems[j++] = this.items.get(i).base;
            }
            try {
                return zmq.ZMQ.poll(this.selector, pollItems, this.items.size(), tout);
            }
            catch (ZError.IOException e) {
                if (this.context.isTerminated()) {
                    return 0;
                }
                throw e;
            }
        }

        public boolean pollin(int index) {
            if (index < 0 || index >= this.items.size()) {
                return false;
            }
            return this.items.get(index).isReadable();
        }

        public boolean pollout(int index) {
            if (index < 0 || index >= this.items.size()) {
                return false;
            }
            return this.items.get(index).isWritable();
        }

        public boolean pollerr(int index) {
            if (index < 0 || index >= this.items.size()) {
                return false;
            }
            return this.items.get(index).isError();
        }
    }

    public static class Socket
    implements Closeable {
        private static final int DYNFROM = 49152;
        private static final int DYNTO = 65535;
        private final ZContext zctx;
        private final SocketBase base;
        private final AtomicBoolean isClosed = new AtomicBoolean(false);

        protected Socket(Context context, SocketType type) {
            this(context, null, type.type);
        }

        protected Socket(ZContext context, SocketType type) {
            this(context.getContext(), context, type.type);
        }

        @Deprecated
        protected Socket(Context context, int type) {
            this(context, null, type);
        }

        private Socket(Context context, ZContext zctx, int type) {
            this.zctx = zctx;
            this.base = context.ctx.createSocket(type);
        }

        protected Socket(SocketBase base) {
            this.zctx = null;
            this.base = base;
        }

        public SocketBase base() {
            return this.base;
        }

        @Override
        public void close() {
            if (this.zctx != null) {
                this.zctx.closeSocket(this);
            } else {
                this.internalClose();
            }
        }

        void internalClose() {
            if (this.isClosed.compareAndSet(false, true)) {
                this.base.close();
            }
        }

        public int getType() {
            return this.base.getSocketOpt(16);
        }

        public SocketType getSocketType() {
            return SocketType.type(this.getType());
        }

        public int getLinger() {
            return this.base.getSocketOpt(17);
        }

        private boolean setSocketOpt(int option, Object value) {
            try {
                boolean set = this.base.setSocketOpt(option, value);
                return set &= this.base.errno() != 22;
            }
            catch (ZError.CtxTerminatedException e) {
                return false;
            }
        }

        @Deprecated
        public boolean setLinger(long value) {
            return this.setLinger(Long.valueOf(value).intValue());
        }

        public boolean setLinger(int value) {
            return this.base.setSocketOpt(17, value);
        }

        public int getReconnectIVL() {
            return this.base.getSocketOpt(18);
        }

        @Deprecated
        public boolean setReconnectIVL(long value) {
            return this.setReconnectIVL(Long.valueOf(value).intValue());
        }

        public boolean setReconnectIVL(int value) {
            return this.base.setSocketOpt(18, value);
        }

        public int getBacklog() {
            return this.base.getSocketOpt(19);
        }

        @Deprecated
        public boolean setBacklog(long value) {
            return this.setBacklog(Long.valueOf(value).intValue());
        }

        public boolean setBacklog(int value) {
            return this.setSocketOpt(19, value);
        }

        public int getHandshakeIvl() {
            return this.base.getSocketOpt(66);
        }

        public int getHeartbeatIvl() {
            return this.base.getSocketOpt(75);
        }

        public int getHeartbeatTimeout() {
            return this.base.getSocketOpt(77);
        }

        public int getHeartbeatTtl() {
            return this.base.getSocketOpt(76);
        }

        public byte[] getHeartbeatContext() {
            return (byte[])this.base.getSocketOptx(1005);
        }

        public boolean setHandshakeIvl(int maxHandshakeIvl) {
            return this.setSocketOpt(66, maxHandshakeIvl);
        }

        public boolean setHeartbeatIvl(int heartbeatIvl) {
            return this.setSocketOpt(75, heartbeatIvl);
        }

        public boolean setHeartbeatTimeout(int heartbeatTimeout) {
            return this.setSocketOpt(77, heartbeatTimeout);
        }

        public boolean setHeartbeatTtl(int heartbeatTtl) {
            return this.setSocketOpt(76, heartbeatTtl);
        }

        public boolean setHeartbeatContext(byte[] pingContext) {
            return this.setSocketOpt(1005, pingContext);
        }

        public int getTos() {
            return this.base.getSocketOpt(57);
        }

        public boolean setTos(int value) {
            return this.setSocketOpt(57, value);
        }

        public int getReconnectIVLMax() {
            return this.base.getSocketOpt(21);
        }

        @Deprecated
        public boolean setReconnectIVLMax(long value) {
            return this.setReconnectIVLMax(Long.valueOf(value).intValue());
        }

        public boolean setReconnectIVLMax(int value) {
            return this.setSocketOpt(21, value);
        }

        public long getMaxMsgSize() {
            return (Long)this.base.getSocketOptx(22);
        }

        public boolean setMaxMsgSize(long value) {
            return this.setSocketOpt(22, value);
        }

        public int getSndHWM() {
            return this.base.getSocketOpt(23);
        }

        @Deprecated
        public boolean setSndHWM(long value) {
            return this.setSndHWM(Long.valueOf(value).intValue());
        }

        public boolean setSndHWM(int value) {
            return this.setSocketOpt(23, value);
        }

        public int getRcvHWM() {
            return this.base.getSocketOpt(24);
        }

        @Deprecated
        public boolean setRcvHWM(long value) {
            return this.setRcvHWM(Long.valueOf(value).intValue());
        }

        public boolean setRcvHWM(int value) {
            return this.setSocketOpt(24, value);
        }

        @Deprecated
        public int getHWM() {
            return -1;
        }

        @Deprecated
        public boolean setHWM(long hwm) {
            boolean set = true;
            set |= this.setSndHWM(hwm);
            return set |= this.setRcvHWM(hwm);
        }

        public boolean setHWM(int hwm) {
            boolean set = false;
            set |= this.setSndHWM(hwm);
            return set |= this.setRcvHWM(hwm);
        }

        @Deprecated
        public long getSwap() {
            return -1L;
        }

        public boolean setConflate(boolean conflate) {
            return this.setSocketOpt(54, conflate);
        }

        public boolean isConflate() {
            return this.base.getSocketOpt(54) != 0;
        }

        public boolean getConflate() {
            return this.isConflate();
        }

        @Deprecated
        public boolean setSwap(long value) {
            throw new UnsupportedOperationException();
        }

        public long getAffinity() {
            return (Long)this.base.getSocketOptx(4);
        }

        public boolean setAffinity(long value) {
            return this.setSocketOpt(4, value);
        }

        public byte[] getIdentity() {
            return (byte[])this.base.getSocketOptx(5);
        }

        public boolean setIdentity(byte[] identity) {
            return this.setSocketOpt(5, identity);
        }

        public long getRate() {
            return this.base.getSocketOpt(8);
        }

        public boolean setRate(long value) {
            throw new UnsupportedOperationException();
        }

        public long getRecoveryInterval() {
            return this.base.getSocketOpt(9);
        }

        public boolean setRecoveryInterval(long value) {
            throw new UnsupportedOperationException();
        }

        public boolean setReqCorrelate(boolean correlate) {
            return this.setSocketOpt(52, correlate);
        }

        @Deprecated
        public boolean getReqCorrelate() {
            throw new UnsupportedOperationException();
        }

        public boolean setReqRelaxed(boolean relaxed) {
            return this.setSocketOpt(53, relaxed);
        }

        @Deprecated
        public boolean getReqRelaxed() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public boolean hasMulticastLoop() {
            return false;
        }

        @Deprecated
        public boolean setMulticastLoop(boolean multicastLoop) {
            throw new UnsupportedOperationException();
        }

        public long getMulticastHops() {
            return this.base.getSocketOpt(25);
        }

        public boolean setMulticastHops(long value) {
            throw new UnsupportedOperationException();
        }

        public int getReceiveTimeOut() {
            return this.base.getSocketOpt(27);
        }

        public boolean setReceiveTimeOut(int value) {
            return this.setSocketOpt(27, value);
        }

        public int getSendTimeOut() {
            return this.base.getSocketOpt(28);
        }

        public boolean setSendTimeOut(int value) {
            return this.setSocketOpt(28, value);
        }

        @Deprecated
        public boolean setTCPKeepAlive(long value) {
            return this.setTCPKeepAlive(Long.valueOf(value).intValue());
        }

        @Deprecated
        public long getTCPKeepAliveSetting() {
            return this.getTCPKeepAlive();
        }

        public boolean setTCPKeepAliveCount(long value) {
            return this.setSocketOpt(35, Long.valueOf(value).intValue());
        }

        public long getTCPKeepAliveCount() {
            return this.base.getSocketOpt(35);
        }

        public boolean setTCPKeepAliveInterval(long value) {
            return this.setSocketOpt(37, Long.valueOf(value).intValue());
        }

        public long getTCPKeepAliveInterval() {
            return this.base.getSocketOpt(37);
        }

        public boolean setTCPKeepAliveIdle(long value) {
            return this.setSocketOpt(36, Long.valueOf(value).intValue());
        }

        public long getTCPKeepAliveIdle() {
            return this.base.getSocketOpt(36);
        }

        public int getSendBufferSize() {
            return this.base.getSocketOpt(11);
        }

        @Deprecated
        public boolean setSendBufferSize(long value) {
            return this.setSendBufferSize(Long.valueOf(value).intValue());
        }

        public boolean setSendBufferSize(int value) {
            return this.setSocketOpt(11, value);
        }

        public int getReceiveBufferSize() {
            return this.base.getSocketOpt(12);
        }

        @Deprecated
        public boolean setReceiveBufferSize(long value) {
            return this.setReceiveBufferSize(Long.valueOf(value).intValue());
        }

        public boolean setReceiveBufferSize(int value) {
            return this.setSocketOpt(12, value);
        }

        public boolean hasReceiveMore() {
            return this.base.getSocketOpt(13) == 1;
        }

        public SelectableChannel getFD() {
            return (SelectableChannel)this.base.getSocketOptx(14);
        }

        public int getEvents() {
            return this.base.getSocketOpt(15);
        }

        public boolean subscribe(byte[] topic) {
            return this.setSocketOpt(6, topic);
        }

        public boolean subscribe(String topic) {
            return this.setSocketOpt(6, topic);
        }

        public boolean unsubscribe(byte[] topic) {
            return this.setSocketOpt(7, topic);
        }

        public boolean unsubscribe(String topic) {
            return this.setSocketOpt(7, topic);
        }

        public boolean join(String group) {
            assert ("DISH".equals(this.base.typeString())) : "Only DISH sockets can join a group";
            return this.base.join(group);
        }

        public boolean leave(String group) {
            assert ("DISH".equals(this.base.typeString())) : "Only DISH sockets can leave a group";
            return this.base.leave(group);
        }

        @Deprecated
        public boolean setEncoder(Class<? extends IEncoder> cls) {
            return this.setSocketOpt(1001, cls);
        }

        @Deprecated
        public boolean setDecoder(Class<? extends IDecoder> cls) {
            return this.setSocketOpt(1002, cls);
        }

        public boolean setMsgAllocationHeapThreshold(int threshold) {
            return this.setSocketOpt(1004, threshold);
        }

        public int getMsgAllocationHeapThreshold() {
            return this.base.getSocketOpt(1004);
        }

        public boolean setMsgAllocator(MsgAllocator allocator) {
            return this.setSocketOpt(1003, allocator);
        }

        public boolean setSelectorChooser(SelectorProviderChooser chooser) {
            return this.base.setSocketOpt(1006, chooser);
        }

        public SelectorProviderChooser getSelectorProviderChooser() {
            return (SelectorProviderChooser)this.base.getSocketOptx(1006);
        }

        public boolean setConnectRid(String rid) {
            return this.setSocketOpt(61, rid);
        }

        public boolean setConnectRid(byte[] rid) {
            return this.setSocketOpt(61, rid);
        }

        public boolean setRouterRaw(boolean raw) {
            return this.setSocketOpt(41, raw);
        }

        public boolean setProbeRouter(boolean probe) {
            return this.setSocketOpt(51, probe);
        }

        public boolean setRouterMandatory(boolean mandatory) {
            return this.setSocketOpt(33, mandatory);
        }

        public boolean setRouterHandover(boolean handover) {
            return this.setSocketOpt(56, handover);
        }

        public boolean setXpubVerbose(boolean verbose) {
            return this.setSocketOpt(40, verbose);
        }

        public boolean setXpubNoDrop(boolean noDrop) {
            return this.setSocketOpt(69, noDrop);
        }

        public boolean setXpubManual(boolean manual) {
            return this.setSocketOpt(71, manual);
        }

        public boolean setXpubVerboser(boolean verboser) {
            return this.setSocketOpt(78, verboser);
        }

        @Deprecated
        public boolean getIPv4Only() {
            return !this.isIPv6();
        }

        public boolean isIPv6() {
            return (Boolean)this.base.getSocketOptx(42);
        }

        public boolean getIPv6() {
            return this.isIPv6();
        }

        @Deprecated
        public boolean setIPv4Only(boolean v4only) {
            return this.setIPv6(!v4only);
        }

        public boolean setIPv6(boolean v6) {
            return this.setSocketOpt(42, v6);
        }

        public int getTCPKeepAlive() {
            return this.base.getSocketOpt(34);
        }

        public boolean setTCPKeepAlive(int optVal) {
            return this.setSocketOpt(34, optVal);
        }

        @Deprecated
        public boolean getDelayAttachOnConnect() {
            return !this.isImmediate();
        }

        @Deprecated
        public boolean setDelayAttachOnConnect(boolean value) {
            return this.setImmediate(!value);
        }

        public boolean isImmediate() {
            return (Boolean)this.base.getSocketOptx(1039);
        }

        public boolean getImmediate() {
            return this.isImmediate();
        }

        public boolean setImmediate(boolean value) {
            return this.setSocketOpt(1039, value);
        }

        public boolean setSocksProxy(String proxy) {
            return this.setSocketOpt(67, proxy);
        }

        public boolean setSocksProxy(byte[] proxy) {
            return this.setSocketOpt(67, proxy);
        }

        public String getSocksProxy() {
            return (String)this.base.getSocketOptx(67);
        }

        public String getLastEndpoint() {
            return (String)this.base.getSocketOptx(32);
        }

        public boolean setZapDomain(String domain) {
            return this.setSocketOpt(55, domain);
        }

        public boolean setZapDomain(byte[] domain) {
            return this.setSocketOpt(55, domain);
        }

        public String getZapDomain() {
            return (String)this.base.getSocketOptx(55);
        }

        public boolean setZAPDomain(String domain) {
            return this.setZapDomain(domain);
        }

        public boolean setZAPDomain(byte[] domain) {
            return this.setZapDomain(domain);
        }

        public String getZAPDomain() {
            return this.getZapDomain();
        }

        @Deprecated
        public boolean setAsServerPlain(boolean server) {
            return this.setPlainServer(server);
        }

        public boolean setPlainServer(boolean server) {
            return this.setSocketOpt(44, server);
        }

        @Deprecated
        public boolean isAsServerPlain() {
            return this.getPlainServer();
        }

        @Deprecated
        public boolean getAsServerPlain() {
            return this.getPlainServer();
        }

        public boolean getPlainServer() {
            return (Boolean)this.base.getSocketOptx(44);
        }

        public boolean setPlainUsername(String username) {
            return this.base.setSocketOpt(45, username);
        }

        public boolean setPlainPassword(String password) {
            return this.base.setSocketOpt(46, password);
        }

        public boolean setPlainUsername(byte[] username) {
            return this.base.setSocketOpt(45, username);
        }

        public boolean setPlainPassword(byte[] password) {
            return this.base.setSocketOpt(46, password);
        }

        public String getPlainUsername() {
            return (String)this.base.getSocketOptx(45);
        }

        public String getPlainPassword() {
            return (String)this.base.getSocketOptx(46);
        }

        @Deprecated
        public boolean setAsServerCurve(boolean server) {
            return this.setCurveServer(server);
        }

        public boolean setCurveServer(boolean server) {
            return this.setSocketOpt(47, server);
        }

        @Deprecated
        public boolean isAsServerCurve() {
            return this.getCurveServer();
        }

        public boolean getCurveServer() {
            return (Boolean)this.base.getSocketOptx(47);
        }

        @Deprecated
        public boolean getAsServerCurve() {
            return this.getCurveServer();
        }

        public boolean setCurvePublicKey(byte[] key) {
            return this.setSocketOpt(48, key);
        }

        public boolean setCurveServerKey(byte[] key) {
            return this.setSocketOpt(50, key);
        }

        public boolean setCurveSecretKey(byte[] key) {
            return this.setSocketOpt(49, key);
        }

        public byte[] getCurvePublicKey() {
            return (byte[])this.base.getSocketOptx(48);
        }

        public byte[] getCurveServerKey() {
            return (byte[])this.base.getSocketOptx(50);
        }

        public byte[] getCurveSecretKey() {
            return (byte[])this.base.getSocketOptx(49);
        }

        public Mechanism getMechanism() {
            return Mechanism.find((Mechanisms)((Object)this.base.getSocketOptx(43)));
        }

        public boolean setHelloMsg(byte[] helloMsg) {
            return this.setSocketOpt(79, helloMsg);
        }

        public boolean bind(String addr) {
            boolean rc = this.base.bind(addr);
            this.mayRaise();
            return rc;
        }

        public int bindToRandomPort(String addr) {
            return this.bindToRandomPort(addr, 49152, 65535);
        }

        public int bindToRandomPort(String addr, int min, int max) {
            for (int i = 0; i < 100; ++i) {
                int port = zmq.util.Utils.randomInt(max - min + 1) + min;
                if (!this.base.bind(String.format("%s:%s", addr, port))) continue;
                this.base.errno.set(0);
                return port;
            }
            throw new ZMQException("Could not bind socket to random port.", 48);
        }

        public boolean connect(String addr) {
            boolean rc = this.base.connect(addr);
            this.mayRaise();
            return rc;
        }

        public boolean disconnect(String addr) {
            return this.base.termEndpoint(addr);
        }

        public boolean unbind(String addr) {
            return this.base.termEndpoint(addr);
        }

        public int connectPeer(String addr) {
            return this.base.connectPeer(addr);
        }

        public boolean send(String data) {
            return this.send(data.getBytes(CHARSET), 0);
        }

        public boolean sendMore(String data) {
            return this.send(data.getBytes(CHARSET), 2);
        }

        public boolean send(String data, int flags) {
            return this.send(data.getBytes(CHARSET), flags);
        }

        public boolean send(byte[] data) {
            return this.send(data, 0);
        }

        public boolean sendMore(byte[] data) {
            return this.send(data, 2);
        }

        public boolean send(byte[] data, int flags) {
            Msg msg = new Msg(data);
            if (this.base.send(msg, flags)) {
                return true;
            }
            this.mayRaise();
            return false;
        }

        public boolean send(byte[] data, int flags, CancellationToken cancellationToken) {
            Msg msg = new Msg(data);
            if (this.base.send(msg, flags, cancellationToken.canceled)) {
                return true;
            }
            this.mayRaise();
            return false;
        }

        public boolean send(byte[] data, int off, int length, int flags) {
            byte[] copy = new byte[length];
            System.arraycopy(data, off, copy, 0, length);
            Msg msg = new Msg(copy);
            if (this.base.send(msg, flags)) {
                return true;
            }
            this.mayRaise();
            return false;
        }

        public int sendByteBuffer(ByteBuffer data, int flags) {
            Msg msg = new Msg(data);
            if (this.base.send(msg, flags)) {
                return msg.size();
            }
            this.mayRaise();
            return -1;
        }

        public boolean sendPicture(String picture, Object ... args) {
            return new ZPicture().sendPicture(this, picture, args);
        }

        public boolean sendBinaryPicture(String picture, Object ... args) {
            return new ZPicture().sendBinaryPicture(this, picture, args);
        }

        public byte[] recv() {
            return this.recv(0);
        }

        public byte[] recv(int flags) {
            Msg msg = this.base.recv(flags);
            if (msg != null) {
                return msg.data();
            }
            this.mayRaise();
            return null;
        }

        public byte[] recv(int flags, CancellationToken cancellationToken) {
            Msg msg = this.base.recv(flags, cancellationToken.canceled);
            if (msg != null) {
                return msg.data();
            }
            this.mayRaise();
            return null;
        }

        public int recv(byte[] buffer, int offset, int len, int flags) {
            Msg msg = this.base.recv(flags);
            if (msg != null) {
                return msg.getBytes(0, buffer, offset, len);
            }
            return -1;
        }

        public int recvByteBuffer(ByteBuffer buffer, int flags) {
            Msg msg = this.base.recv(flags);
            if (msg != null) {
                buffer.put(msg.buf());
                return msg.size();
            }
            this.mayRaise();
            return -1;
        }

        public String recvStr() {
            return this.recvStr(0);
        }

        public String recvStr(int flags) {
            byte[] msg = this.recv(flags);
            if (msg != null) {
                return new String(msg, CHARSET);
            }
            return null;
        }

        public Object[] recvPicture(String picture) {
            return new ZPicture().recvPicture(this, picture);
        }

        public Object[] recvBinaryPicture(String picture) {
            return new ZPicture().recvBinaryPicture(this, picture);
        }

        public boolean monitor(String addr, int events) {
            return this.base.monitor(addr, events);
        }

        protected void mayRaise() {
            int errno = this.base.errno();
            if (errno != 0 && errno != 35) {
                throw new ZMQException(errno);
            }
        }

        public int errno() {
            return this.base.errno();
        }

        public String toString() {
            return this.base.toString();
        }

        public CancellationToken createCancellationToken() {
            return new CancellationToken(this.base);
        }

        public static enum Mechanism {
            NULL(Mechanisms.NULL),
            PLAIN(Mechanisms.PLAIN),
            CURVE(Mechanisms.CURVE);

            private final Mechanisms mech;

            private Mechanism(Mechanisms zmq) {
                this.mech = zmq;
            }

            private static Mechanism find(Mechanisms mech) {
                for (Mechanism candidate : Mechanism.values()) {
                    if (candidate.mech != mech) continue;
                    return candidate;
                }
                return null;
            }
        }
    }

    public static class Context
    implements Closeable {
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final Ctx ctx;

        protected Context(int ioThreads) {
            this.ctx = zmq.ZMQ.init(ioThreads);
        }

        public boolean isTerminated() {
            return !this.ctx.isActive();
        }

        public int getIOThreads() {
            return this.ctx.get(1);
        }

        public boolean setIOThreads(int ioThreads) {
            return this.ctx.set(1, ioThreads);
        }

        public int getMaxSockets() {
            return this.ctx.get(2);
        }

        public boolean setMaxSockets(int maxSockets) {
            return this.ctx.set(2, maxSockets);
        }

        @Deprecated
        public boolean getBlocky() {
            return this.isBlocky();
        }

        public boolean isBlocky() {
            return this.ctx.get(70) != 0;
        }

        public boolean setBlocky(boolean block) {
            return this.ctx.set(70, block ? 1 : 0);
        }

        public boolean isIPv6() {
            return this.ctx.get(42) != 0;
        }

        public boolean getIPv6() {
            return this.isIPv6();
        }

        public boolean setIPv6(boolean ipv6) {
            return this.ctx.set(42, ipv6 ? 1 : 0);
        }

        public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler) {
            this.ctx.setUncaughtExceptionHandler(handler);
        }

        public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
            return this.ctx.getUncaughtExceptionHandler();
        }

        public void setNotificationExceptionHandler(Thread.UncaughtExceptionHandler handler) {
            this.ctx.setNotificationExceptionHandler(handler);
        }

        public Thread.UncaughtExceptionHandler getNotificationExceptionHandler() {
            return this.ctx.getNotificationExceptionHandler();
        }

        public void term() {
            if (this.closed.compareAndSet(false, true)) {
                this.ctx.terminate();
            }
        }

        public boolean isClosed() {
            return this.closed.get();
        }

        public Socket socket(SocketType type) {
            return new Socket(this, type);
        }

        @Deprecated
        public Socket socket(int type) {
            return this.socket(SocketType.type(type));
        }

        public Selector selector() {
            return this.ctx.createSelector();
        }

        public boolean close(Selector selector) {
            return this.ctx.closeSelector(selector);
        }

        public Poller poller() {
            return new Poller(this);
        }

        public Poller poller(int size) {
            return new Poller(this, size);
        }

        @Override
        public void close() {
            this.term();
        }
    }

    public static enum Error {
        ENOTSUP(45, "Not supported"),
        EPROTONOSUPPORT(43, "Protocol not supported"),
        ENOBUFS(55, "No buffer space available"),
        ENETDOWN(50, "Network is down"),
        EADDRINUSE(48, "Address already in use"),
        EADDRNOTAVAIL(49, "Address not available"),
        ECONNREFUSED(61, "Connection refused"),
        EINPROGRESS(36, "Operation in progress"),
        EHOSTUNREACH(65, "Host unreachable"),
        EMTHREAD(156384766, "No thread available"),
        EFSM(156384763, "Operation cannot be accomplished in current state"),
        ENOCOMPATPROTO(156384764, "The protocol is not compatible with the socket type"),
        ETERM(156384765, "Context was terminated"),
        ENOTSOCK(156384717, "Not a socket"),
        EAGAIN(35, "Resource unavailable, try again"),
        ENOENT(2, "No such file or directory"),
        EINTR(4, "Interrupted function"),
        EACCESS(13, "Permission denied"),
        EFAULT(14, "Bad address"),
        EINVAL(22, "Invalid argument"),
        EISCONN(56, "Socket is connected"),
        ENOTCONN(57, "The socket is not connected"),
        EMSGSIZE(156384722, "Message too large"),
        EAFNOSUPPORT(156384723, "Address family not supported"),
        ENETUNREACH(156384724, "Network unreachable"),
        ECONNABORTED(156384725, "Connection aborted"),
        ECONNRESET(156384726, "Connection reset"),
        ETIMEDOUT(156384728, "Connection timed out"),
        ENETRESET(156384730, "Connection aborted by network"),
        EIOEXC(156384817),
        ESOCKET(156384818),
        EMFILE(156384819, "File descriptor value too large"),
        EPROTO(156384820, "Protocol error");

        private static final Map<Integer, Error> map;
        private final int code;
        private final String message;

        private Error(int code) {
            this.code = code;
            this.message = "errno " + Integer.toString(code);
        }

        private Error(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public static Error findByCode(int code) {
            if (map.containsKey(code)) {
                return map.get(code);
            }
            throw new IllegalArgumentException("Unknown " + Error.class.getName() + " enum code: " + code);
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        static {
            map = new HashMap<Integer, Error>(Error.values().length);
            for (Error e : Error.values()) {
                map.put(e.code, e);
            }
        }
    }
}

