/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import zmq.Command;
import zmq.Config;
import zmq.Ctx;
import zmq.IMailbox;
import zmq.Signaler;
import zmq.pipe.YPipe;
import zmq.util.Errno;

public class MailboxSafe
implements IMailbox {
    private final YPipe<Command> cpipe;
    private final ReentrantLock sync;
    private final Condition condition;
    private final ArrayList<Signaler> signalers;
    private final String name;
    private final Errno errno;

    public MailboxSafe(Ctx ctx, ReentrantLock sync, String name) {
        this.errno = ctx.errno();
        this.cpipe = new YPipe(Config.COMMAND_PIPE_GRANULARITY.getValue());
        this.sync = sync;
        this.condition = this.sync.newCondition();
        this.signalers = new ArrayList(10);
        this.name = name;
        Command cmd = this.cpipe.read();
        assert (cmd == null);
    }

    public void addSignaler(Signaler signaler) {
        this.signalers.add(signaler);
    }

    public void removeSignaler(Signaler signaler) {
        this.signalers.remove(signaler);
    }

    public void clearSignalers() {
        this.signalers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Command cmd) {
        this.sync.lock();
        try {
            this.cpipe.write(cmd, false);
            boolean ok = this.cpipe.flush();
            if (!ok) {
                this.condition.signalAll();
                for (int i = 0; i < this.signalers.size(); ++i) {
                    this.signalers.get(i).send();
                }
            }
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public Command recv(long timeout) {
        Command cmd = this.cpipe.read();
        if (cmd != null) {
            return cmd;
        }
        if (timeout == 0L) {
            this.sync.unlock();
            this.sync.lock();
        } else {
            try {
                if (timeout == -1L) {
                    this.condition.await();
                } else {
                    this.condition.await(timeout, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.errno.set(4);
                return null;
            }
        }
        cmd = this.cpipe.read();
        if (cmd == null) {
            this.errno.set(35);
            return null;
        }
        return cmd;
    }

    @Override
    public void close() throws IOException {
        this.sync.lock();
        this.sync.unlock();
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }
}

