/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.luajava.jsr223;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.stream.Collectors;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import party.iroiro.luajava.ClassPathLoader;
import party.iroiro.luajava.ExternalLoader;
import party.iroiro.luajava.Lua;
import party.iroiro.luajava.LuaException;
import party.iroiro.luajava.jsr223.LuaScriptEngineFactory;
import party.iroiro.luajava.util.ClassUtils;
import party.iroiro.luajava.value.LuaValue;

public final class LuaScriptEngine
extends AbstractScriptEngine
implements ScriptEngine,
Compilable {
    private final String luaClass;
    private final LuaScriptEngineFactory factory;

    LuaScriptEngine(String luaClass, LuaScriptEngineFactory factory) {
        this.luaClass = luaClass;
        this.factory = factory;
    }

    private Lua getLua() throws ScriptException {
        try {
            Lua L = (Lua)ClassUtils.forName((String)this.luaClass).newInstance();
            L.setExternalLoader((ExternalLoader)new ClassPathLoader());
            L.openLibraries();
            return L;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new ScriptException(e);
        }
    }

    private void putContext(Lua L, ScriptContext scriptContext) {
        Bindings global = scriptContext.getBindings(200);
        if (global != null) {
            global.forEach((k, v) -> {
                L.push(v, Lua.Conversion.SEMI);
                L.setGlobal(k);
            });
        }
        scriptContext.getBindings(100).forEach((k, v) -> {
            L.push(v, Lua.Conversion.SEMI);
            L.setGlobal(k);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object eval(String script, ScriptContext scriptContext) throws ScriptException {
        LuaScriptEngine.assertNotNull(script, "script");
        LuaScriptEngine.assertNotNull(scriptContext, "context");
        try (Lua L = this.getLua();){
            this.putContext(L, scriptContext);
            LuaValue[] values = L.eval(script);
            LuaValue[] luaValueArray = values.length == 0 ? null : values;
            return luaValueArray;
        }
        catch (LuaException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        return this.eval(this.readAll(reader), scriptContext);
    }

    private String readAll(Reader reader) throws ScriptException {
        LuaScriptEngine.assertNotNull(reader, "reader");
        BufferedReader bufferedReader = new BufferedReader(reader);
        String code = bufferedReader.lines().collect(Collectors.joining("\n"));
        try {
            bufferedReader.close();
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        return code;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    private static <T> void assertNotNull(T t, String name) {
        if (t == null) {
            throw new NullPointerException(name + " must not be null");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CompiledScript compile(String s) throws ScriptException {
        try (Lua L = this.getLua();){
            L.load(s);
            final ByteBuffer dump = L.dump();
            CompiledScript compiledScript = new CompiledScript(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Object eval(ScriptContext scriptContext) throws ScriptException {
                    LuaScriptEngine.assertNotNull(scriptContext, "context");
                    try (Lua L = LuaScriptEngine.this.getLua();){
                        LuaScriptEngine.this.putContext(L, scriptContext);
                        int top = L.getTop();
                        L.load((Buffer)dump, "CompiledScript");
                        L.pCall(0, -1);
                        int returnCount = L.getTop() - top;
                        LuaValue[] returnValues = new LuaValue[returnCount];
                        for (int i = 0; i < returnCount; ++i) {
                            returnValues[returnCount - i - 1] = L.get();
                        }
                        LuaValue[] luaValueArray = returnValues.length == 0 ? null : returnValues;
                        return luaValueArray;
                    }
                    catch (LuaException e) {
                        throw new ScriptException((Exception)((Object)e));
                    }
                }

                @Override
                public ScriptEngine getEngine() {
                    return LuaScriptEngine.this;
                }
            };
            return compiledScript;
        }
        catch (LuaException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readAll(reader));
    }
}

