/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.luajava.lua51;

import java.util.concurrent.atomic.AtomicReference;
import party.iroiro.luajava.AbstractLua;
import party.iroiro.luajava.Lua;
import party.iroiro.luajava.LuaException;
import party.iroiro.luajava.LuaNatives;
import party.iroiro.luajava.lua51.Lua51Natives;

public class Lua51
extends AbstractLua {
    private static final AtomicReference<Lua51Natives> natives = new AtomicReference();

    public Lua51() throws LinkageError {
        super(Lua51.getNatives());
    }

    protected Lua51(long L, int id, AbstractLua main) {
        super(main.getLuaNatives(), L, id, main);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LuaNatives getNatives() throws LinkageError {
        AtomicReference<Lua51Natives> atomicReference = natives;
        synchronized (atomicReference) {
            if (natives.get() == null) {
                try {
                    natives.set(new Lua51Natives());
                }
                catch (IllegalStateException e) {
                    throw new LinkageError("Unable to find natives or init", e);
                }
            }
            return natives.get();
        }
    }

    protected AbstractLua newThread(long L, int id, AbstractLua mainThread) {
        return new Lua51(L, id, mainThread);
    }

    public LuaException.LuaError convertError(int code) {
        switch (code) {
            case 0: {
                return LuaException.LuaError.OK;
            }
            case 1: {
                return LuaException.LuaError.YIELD;
            }
            case 2: {
                return LuaException.LuaError.RUNTIME;
            }
            case 3: {
                return LuaException.LuaError.SYNTAX;
            }
            case 4: {
                return LuaException.LuaError.MEMORY;
            }
            case 5: {
                return LuaException.LuaError.HANDLER;
            }
        }
        throw new LuaException(LuaException.LuaError.RUNTIME, "Unrecognized error code");
    }

    public Lua.LuaType convertType(int code) {
        switch (code) {
            case 1: {
                return Lua.LuaType.BOOLEAN;
            }
            case 6: {
                return Lua.LuaType.FUNCTION;
            }
            case 2: {
                return Lua.LuaType.LIGHTUSERDATA;
            }
            case 0: {
                return Lua.LuaType.NIL;
            }
            case -1: {
                return Lua.LuaType.NONE;
            }
            case 3: {
                return Lua.LuaType.NUMBER;
            }
            case 4: {
                return Lua.LuaType.STRING;
            }
            case 5: {
                return Lua.LuaType.TABLE;
            }
            case 8: {
                return Lua.LuaType.THREAD;
            }
            case 7: {
                return Lua.LuaType.USERDATA;
            }
        }
        throw new LuaException(LuaException.LuaError.RUNTIME, "Unrecognized type code");
    }
}

