/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.lock;

import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import party.iroiro.lock.Lock;
import party.iroiro.lock.LockHandle;
import party.iroiro.lock.util.LockCancellationException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class AbstractLock
implements Lock {
    AbstractLock() {
    }

    @Override
    public Mono<Void> tryLock(Duration duration) {
        LockHandle lockHandle = this.tryLock();
        return lockHandle.mono().timeout(duration).onErrorResume(TimeoutException.class, e -> {
            if (lockHandle.cancel()) {
                return Mono.error((Throwable)e);
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<Void> lock() {
        return this.tryLock().mono();
    }

    @Override
    public <T> Flux<T> withLock(Supplier<Publisher<T>> scoped) {
        return Flux.using(this::tryLock, lockHandle -> lockHandle.mono().thenMany((Publisher)Flux.defer((Supplier)scoped)), lockHandle -> {
            if (!lockHandle.cancel()) {
                this.unlock();
            }
        }).onErrorResume(LockCancellationException.class, e -> Mono.empty());
    }

    @Override
    public <T> Mono<T> lockOnNext(Mono<T> mono) {
        return mono.flatMap(t -> this.lock().thenReturn(t));
    }

    @Override
    public <T> Mono<T> unlockOnTerminate(Mono<T> mono) {
        return mono.doOnTerminate(this::unlock);
    }

    @Override
    public <T> Mono<T> unlockOnNext(Mono<T> mono) {
        return mono.doOnNext(ignored -> this.unlock());
    }

    @Override
    public <T> Mono<T> unlockOnEmpty(Mono<T> mono) {
        return mono.switchIfEmpty(Mono.fromRunnable(this::unlock));
    }

    @Override
    public <T> Mono<T> unlockOnError(Mono<T> mono) {
        return mono.doOnError(ignored -> this.unlock());
    }
}

