/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.lock;

import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import party.iroiro.lock.AbstractLock;
import party.iroiro.lock.LockHandle;
import party.iroiro.lock.RWLock;
import party.iroiro.lock.util.LockCancellationException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class AbstractRWLock
extends AbstractLock
implements RWLock {
    AbstractRWLock() {
    }

    @Override
    public Mono<Void> tryRLock(Duration duration) {
        LockHandle lockHandle = this.tryRLock();
        return lockHandle.mono().timeout(duration).onErrorResume(TimeoutException.class, e -> {
            if (lockHandle.cancel()) {
                return Mono.error((Throwable)e);
            }
            return Mono.empty();
        });
    }

    @Override
    public <T> Flux<T> withRLock(Supplier<Publisher<T>> scoped) {
        return Flux.using(this::tryRLock, lockHandle -> lockHandle.mono().thenMany((Publisher)Flux.defer((Supplier)scoped)), lockHandle -> {
            if (!lockHandle.cancel()) {
                this.rUnlock();
            }
        }).onErrorResume(LockCancellationException.class, e -> Mono.empty());
    }

    @Override
    public Mono<Void> rLock() {
        return this.tryRLock().mono();
    }

    @Override
    public <T> Mono<T> rLockOnNext(Mono<T> mono) {
        return mono.flatMap(t -> this.rLock().thenReturn(t));
    }

    @Override
    public <T> Mono<T> rUnlockOnEmpty(Mono<T> mono) {
        return mono.switchIfEmpty(Mono.fromRunnable(this::rUnlock));
    }

    @Override
    public <T> Mono<T> rUnlockOnNext(Mono<T> mono) {
        return mono.doOnNext(ignored -> this.rUnlock());
    }

    @Override
    public <T> Mono<T> rUnlockOnTerminate(Mono<T> mono) {
        return mono.doOnTerminate(this::rUnlock);
    }

    @Override
    public <T> Mono<T> rUnlockOnError(Mono<T> mono) {
        return mono.doOnError(ignored -> this.rUnlock());
    }
}

