/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.lock;

import java.util.concurrent.atomic.AtomicBoolean;
import party.iroiro.lock.AbstractLock;
import party.iroiro.lock.LockHandle;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class BroadcastingLock
extends AbstractLock {
    private final AtomicBoolean unlocked = new AtomicBoolean(true);
    private final Sinks.Many<Boolean> broadcast = Sinks.many().multicast().onBackpressureBuffer(1, false);
    private final Flux<Boolean> queue = this.broadcast.asFlux();

    public BroadcastingLock() {
        this.broadcast.tryEmitNext((Object)true);
    }

    @Override
    public LockHandle tryLock() {
        AtomicBoolean lockedByMe = new AtomicBoolean(false);
        Mono request = this.queue.filter(ignored -> {
            if (this.unlocked.compareAndSet(true, false)) {
                if (lockedByMe.compareAndSet(false, true)) {
                    return true;
                }
                this.unlock();
                return false;
            }
            return false;
        }).next().then();
        return LockHandle.from((Mono<Void>)request, () -> lockedByMe.compareAndSet(false, true));
    }

    @Override
    public boolean isLocked() {
        return !this.unlocked.get();
    }

    @Override
    public void unlock() {
        this.unlocked.set(true);
        while (this.broadcast.tryEmitNext((Object)true) == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
        }
    }
}

