/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.lock;

import java.util.function.Supplier;
import party.iroiro.lock.EmptyLockHandle;
import reactor.core.publisher.Mono;

public interface LockHandle {
    public static LockHandle empty() {
        return EmptyLockHandle.instance();
    }

    public static LockHandle from(Mono<Void> mono, Supplier<Boolean> canceller) {
        return new CancellableHandle(mono, canceller);
    }

    public boolean cancel();

    public Mono<Void> mono();

    public static class CancellableHandle
    implements LockHandle {
        private final Mono<Void> mono;
        private final Supplier<Boolean> canceller;

        CancellableHandle(Mono<Void> mono, Supplier<Boolean> canceller) {
            this.mono = mono;
            this.canceller = canceller;
        }

        @Override
        public boolean cancel() {
            return this.canceller.get();
        }

        @Override
        public Mono<Void> mono() {
            return this.mono;
        }
    }
}

