/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.lock;

import java.util.function.Function;
import party.iroiro.lock.Lock;
import party.iroiro.lock.RWLock;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class LockedMono<R> {
    private final Mono<R> before;
    private final Sinks.One<R> start;

    LockedMono(Mono<R> mono) {
        this.before = mono;
        this.start = Sinks.one();
    }

    LockedMonoBuilder<R> begin() {
        return new LockedMonoBuilder(this.start.asMono());
    }

    public class LockedMonoBuilder<T> {
        private final Mono<T> mono;

        private LockedMonoBuilder(Mono<T> mono) {
            this.mono = mono;
        }

        public <S> LockedMonoBuilder<S> map(Function<T, S> mapper) {
            return new LockedMonoBuilder<T>(this.mono.map(mapper));
        }

        public <S> LockedMonoBuilder<S> flatMap(Function<T, Mono<S>> flatMapper) {
            return new LockedMonoBuilder<T>(this.mono.flatMap(flatMapper));
        }

        public Mono<T> with(Lock lock) {
            return LockedMono.this.before.flatMap(r -> lock.withLock(() -> {
                LockedMono.this.start.tryEmitValue(r);
                return this.mono;
            }).next());
        }

        public Mono<T> withR(RWLock lock) {
            return LockedMono.this.before.flatMap(r -> lock.withRLock(() -> {
                LockedMono.this.start.tryEmitValue(r);
                return this.mono;
            }).next());
        }
    }
}

