/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.lock;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import party.iroiro.lock.AbstractLock;
import party.iroiro.lock.LockHandle;
import party.iroiro.lock.util.EmptySink;
import party.iroiro.lock.util.SinkUtils;

public final class ReactiveLock
extends AbstractLock {
    private volatile int count = 0;
    private static final AtomicIntegerFieldUpdater<ReactiveLock> COUNT = AtomicIntegerFieldUpdater.newUpdater(ReactiveLock.class, "count");
    private final ConcurrentLinkedQueue<EmptySink> queue = new ConcurrentLinkedQueue();
    private final boolean fairness;

    public ReactiveLock() {
        this(false);
    }

    public ReactiveLock(boolean fairness) {
        this.fairness = fairness;
    }

    @Override
    public LockHandle tryLock() {
        if (COUNT.compareAndSet(this, 0, 1)) {
            return LockHandle.empty();
        }
        LockHandle handle = SinkUtils.queueSink(this.queue);
        this.fairDecrement(false);
        return handle;
    }

    private void fairDecrement(boolean unlocking) {
        if (unlocking || COUNT.incrementAndGet(this) == 1) {
            do {
                if (!SinkUtils.emitAnySink(this.queue)) continue;
                return;
            } while (COUNT.decrementAndGet(this) != 0);
        }
    }

    @Override
    public boolean isLocked() {
        return this.count != 0;
    }

    @Override
    public void unlock() {
        if (this.fairness) {
            this.fairDecrement(true);
        } else {
            COUNT.set(this, 0);
            this.fairDecrement(false);
        }
    }
}

