/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.lock;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import party.iroiro.lock.AbstractRWLock;
import party.iroiro.lock.LockHandle;
import party.iroiro.lock.util.SinkUtils;
import reactor.core.publisher.Sinks;

public final class ReactiveRWLock
extends AbstractRWLock {
    private volatile int r = 0;
    private static final AtomicIntegerFieldUpdater<ReactiveRWLock> R = AtomicIntegerFieldUpdater.newUpdater(ReactiveRWLock.class, "r");
    private volatile int wip = 0;
    private static final AtomicIntegerFieldUpdater<ReactiveRWLock> WIP = AtomicIntegerFieldUpdater.newUpdater(ReactiveRWLock.class, "wip");
    private final ConcurrentLinkedQueue<Sinks.Empty<Void>> readers = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Sinks.Empty<Void>> writers = new ConcurrentLinkedQueue();

    @Override
    public LockHandle tryLock() {
        if (R.compareAndSet(this, 0, -2147483647)) {
            return LockHandle.empty();
        }
        LockHandle handle = SinkUtils.queue(this.writers, SinkUtils::emitEmpty);
        R.updateAndGet(this, i -> i >= 0 ? i + Integer.MIN_VALUE + 1 : i + 1);
        this.decrement();
        return handle;
    }

    @Override
    public LockHandle tryRLock() {
        if (R.incrementAndGet(this) > 0) {
            return LockHandle.empty();
        }
        LockHandle handle = SinkUtils.queue(this.readers, SinkUtils::emitEmpty);
        this.decrement();
        return handle;
    }

    private void decrement() {
        if (WIP.incrementAndGet(this) == 1) {
            do {
                if (this.r != -2147483647) {
                    R.decrementAndGet(this);
                    continue;
                }
                if (SinkUtils.emitAny(this.writers)) continue;
                if (R.compareAndSet(this, -2147483647, 1)) {
                    do {
                        R.incrementAndGet(this);
                    } while (SinkUtils.emitAny(this.readers));
                    WIP.incrementAndGet(this);
                    R.decrementAndGet(this);
                    continue;
                }
                R.decrementAndGet(this);
            } while (WIP.decrementAndGet(this) != 0);
        }
    }

    @Override
    public void unlock() {
        this.decrement();
    }

    @Override
    public void rUnlock() {
        this.decrement();
    }

    @Override
    public boolean isLocked() {
        return this.r != 0;
    }

    @Override
    public boolean isRLocked() {
        return this.r > 0;
    }
}

