/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.lock;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import party.iroiro.lock.AbstractLock;
import party.iroiro.lock.LockHandle;
import party.iroiro.lock.util.SinkUtils;
import reactor.core.publisher.Sinks;

public final class ReactiveSemaphore
extends AbstractLock {
    private final int limit;
    private volatile int count = 0;
    private static final AtomicIntegerFieldUpdater<ReactiveSemaphore> COUNT = AtomicIntegerFieldUpdater.newUpdater(ReactiveSemaphore.class, "count");
    private volatile int wip = 0;
    private static final AtomicIntegerFieldUpdater<ReactiveSemaphore> WIP = AtomicIntegerFieldUpdater.newUpdater(ReactiveSemaphore.class, "wip");
    private final ConcurrentLinkedQueue<Sinks.Empty<Void>> queue = new ConcurrentLinkedQueue();

    public ReactiveSemaphore(int limit) throws IllegalArgumentException {
        if (limit < 1) {
            throw new IllegalArgumentException("Expecting a positive limit");
        }
        this.limit = limit;
    }

    @Override
    public LockHandle tryLock() {
        if (COUNT.incrementAndGet(this) <= this.limit) {
            return LockHandle.empty();
        }
        LockHandle handle = SinkUtils.queue(this.queue, SinkUtils::emitError);
        this.decrement();
        return handle;
    }

    private void decrement() {
        if (WIP.incrementAndGet(this) == 1) {
            do {
                if (this.count <= this.limit && SinkUtils.emitAny(this.queue)) continue;
                COUNT.decrementAndGet(this);
            } while (WIP.decrementAndGet(this) != 0);
        }
    }

    @Override
    public boolean isLocked() {
        return this.count >= this.limit;
    }

    @Override
    public void unlock() {
        this.decrement();
    }
}

