/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.lock.util;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import party.iroiro.lock.LockHandle;
import party.iroiro.lock.util.LockCancellationException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

public class EmptySink
implements Publisher<Void>,
LockHandle {
    private static final int ERROR = 1;
    private static final int EMPTY = 2;
    private static final int SUBSCRIBED = 4;
    private static final int REQUESTED = 8;
    private volatile Subscriber<? super Void> subscriber = null;
    private static final AtomicReferenceFieldUpdater<EmptySink, Subscriber> SUBSCRIBER = AtomicReferenceFieldUpdater.newUpdater(EmptySink.class, Subscriber.class, "subscriber");
    private volatile int state = 0;
    private static final AtomicIntegerFieldUpdater<EmptySink> STATE = AtomicIntegerFieldUpdater.newUpdater(EmptySink.class, "state");
    private final Mono<Void> mono = Mono.from((Publisher)this);

    public void subscribe(Subscriber<? super Void> s) {
        if (SUBSCRIBER.compareAndSet(this, null, s)) {
            STATE.getAndUpdate(this, state -> state | 4);
            s.onSubscribe(new Subscription(){

                public void request(long n) {
                    int s = STATE.getAndUpdate(EmptySink.this, state -> state | 8);
                    if ((s & 8) == 0) {
                        if ((s & 1) != 0) {
                            EmptySink.this.subscriber.onError((Throwable)LockCancellationException.instance());
                        } else if ((s & 2) != 0) {
                            EmptySink.this.subscriber.onComplete();
                        }
                    }
                }

                public void cancel() {
                    STATE.getAndUpdate(EmptySink.this, state -> state & 0xFFFFFFF7);
                }
            });
        } else {
            Operators.error(s, (Throwable)new IllegalAccessException("Multiple subscription disallowed"));
        }
    }

    public boolean emit() {
        int s = STATE.getAndUpdate(this, state -> state | 2);
        if ((s & 3) == 0) {
            if ((s & 8) != 0) {
                this.subscriber.onComplete();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean cancel() {
        int s = STATE.getAndUpdate(this, state -> state | 1);
        if ((s & 3) == 0) {
            if ((s & 8) != 0) {
                this.subscriber.onError((Throwable)LockCancellationException.instance());
            }
            return true;
        }
        return false;
    }

    @Override
    public Mono<Void> mono() {
        return this.mono;
    }
}

