/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.lock.util;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import party.iroiro.lock.LockHandle;
import party.iroiro.lock.util.EmptySink;
import party.iroiro.lock.util.LockCancellationException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public abstract class SinkUtils {
    private SinkUtils() {
    }

    public static LockHandle queue(ConcurrentLinkedQueue<Sinks.Empty<Void>> queue, Function<Sinks.Empty<Void>, Boolean> onCancel) {
        Sinks.Empty empty = Sinks.empty();
        queue.add((Sinks.Empty<Void>)empty);
        return LockHandle.from((Mono<Void>)empty.asMono(), () -> (Boolean)onCancel.apply(empty));
    }

    public static LockHandle queueSink(ConcurrentLinkedQueue<EmptySink> queue) {
        EmptySink empty = new EmptySink();
        queue.add(empty);
        return empty;
    }

    public static boolean emitEmpty(Sinks.Empty<Void> sink) {
        Sinks.EmitResult result;
        while ((result = sink.tryEmitEmpty()) == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
        }
        return result.isSuccess();
    }

    public static boolean emitError(Sinks.Empty<Void> sink) {
        Sinks.EmitResult result;
        while ((result = sink.tryEmitError((Throwable)LockCancellationException.instance())) == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
        }
        return result.isSuccess();
    }

    public static boolean emitAny(ConcurrentLinkedQueue<Sinks.Empty<Void>> queue) {
        Sinks.Empty<Void> sink = queue.poll();
        while (sink != null) {
            if (SinkUtils.emitEmpty(sink)) {
                return true;
            }
            sink = queue.poll();
        }
        return false;
    }

    public static boolean emitAnySink(ConcurrentLinkedQueue<EmptySink> queue) {
        EmptySink sink = queue.poll();
        while (sink != null) {
            if (sink.emit()) {
                return true;
            }
            sink = queue.poll();
        }
        return false;
    }
}

