/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto;

import com.google.common.base.Verify;
import pl.allegro.finance.tradukisto.internal.Container;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;

public enum ValueConverters {
    BRAZILIAN_PORTUGUESE_INTEGER(Container.brazilianPortugueseContainer().getNumbersConverter()),
    GERMAN_INTEGER(Container.germanContainer().getNumbersConverter()),
    POLISH_INTEGER(Container.polishContainer().getNumbersConverter()),
    RUSSIAN_INTEGER(Container.russianContainer().getNumbersConverter()),
    CZECH_INTEGER(Container.czechContainer().getNumbersConverter()),
    ENGLISH_INTEGER(Container.englishContainer().getNumbersConverter());

    private final IntegerToStringConverter converter;

    private ValueConverters(IntegerToStringConverter converter) {
        this.converter = converter;
    }

    public String asWords(Integer value) {
        Verify.verifyNotNull((Object)value);
        return this.converter.asWords(value);
    }
}

