/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto;

import com.google.common.base.Strings;
import com.google.common.base.Verify;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import pl.allegro.finance.tradukisto.internal.Container;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;

public enum ValueConverters {
    BRAZILIAN_PORTUGUESE_INTEGER(Container.brazilianPortugueseContainer().getNumbersConverter(), Arrays.asList("pt", "pt-br")),
    ENGLISH_INTEGER(Container.englishContainer().getNumbersConverter(), "en"),
    GERMAN_INTEGER(Container.germanContainer().getNumbersConverter(), "de"),
    RUSSIAN_INTEGER(Container.russianContainer().getNumbersConverter(), "ru"),
    ITALIAN_INTEGER(Container.italianContainer().getNumbersConverter(), "it"),
    POLISH_INTEGER(Container.polishContainer().getNumbersConverter(), "pl"),
    CZECH_INTEGER(Container.czechContainer().getNumbersConverter(), "cs"),
    SLOVAK_INTEGER(Container.slovakContainer().getNumbersConverter(), "sk"),
    LATVIAN_INTEGER(Container.latvianContainer().getNumbersConverter(), "lv"),
    KAZAKH_INTEGER(Container.kazakhContainer().getNumbersConverter(), "kk"),
    UKRAINIAN_INTEGER(Container.ukrainianContainer().getNumbersConverter(), "uk"),
    SERBIAN_INTEGER(Container.serbianContainer().getNumbersConverter(), Arrays.asList("sr", ValueConverters.getLanguageCodeFor("sr", "Latn"))),
    SERBIAN_CYRILLIC_INTEGER(Container.serbianCyrillicContainer().getNumbersConverter(), ValueConverters.getLanguageCodeFor("sr", "Cyrl")),
    FRENCH_INTEGER(Container.frenchContainer().getNumbersConverter(), "fr"),
    TURKISH_INTEGER(Container.turkishContainer().getNumbersConverter(), "tr");

    private final IntegerToStringConverter converter;
    private final List<String> languageCodes;

    private ValueConverters(IntegerToStringConverter converter, String languageCodes) {
        this(converter, Collections.singletonList(languageCodes));
    }

    private ValueConverters(IntegerToStringConverter converter, List<String> languageCodes) {
        this.converter = converter;
        this.languageCodes = languageCodes;
    }

    public String asWords(Integer value) {
        Verify.verifyNotNull((Object)value);
        return this.converter.asWords(value);
    }

    public static ValueConverters getByLocaleOrDefault(Locale locale, ValueConverters defaultConverter) {
        Verify.verifyNotNull((Object)locale);
        String languageCode = ValueConverters.hasSpecifiedScript(locale) ? ValueConverters.getLanguageCodeFor(locale.getLanguage(), locale.getScript()) : locale.getLanguage();
        return ValueConverters.getByLanguageCodeOrDefault(languageCode, defaultConverter);
    }

    private static boolean hasSpecifiedScript(Locale locale) {
        return !Strings.isNullOrEmpty((String)locale.getScript());
    }

    private static String getLanguageCodeFor(String language, String script) {
        return new Locale.Builder().setLanguage(language).setScript(script).build().toString();
    }

    public static ValueConverters getByLanguageCodeOrDefault(String languageCode, ValueConverters defaultConverter) {
        Verify.verifyNotNull((Object)languageCode);
        Verify.verify((!languageCode.isEmpty() ? 1 : 0) != 0);
        return Arrays.stream(ValueConverters.values()).filter(it -> it.languageCodes.contains(languageCode)).findFirst().orElse(defaultConverter);
    }
}

