/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.converters;

import com.google.common.collect.Range;
import java.util.Map;
import pl.allegro.finance.tradukisto.internal.GenderAwareIntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.languages.GenderForms;
import pl.allegro.finance.tradukisto.internal.languages.GenderType;

public class HundredsToWordsConverter
implements GenderAwareIntegerToStringConverter {
    private final Map<Integer, GenderForms> baseValues;
    private final char twoDigitsNumberSeparator;

    public HundredsToWordsConverter(Map<Integer, GenderForms> baseValues, char twoDigitsNumberSeparator) {
        this.baseValues = baseValues;
        this.twoDigitsNumberSeparator = twoDigitsNumberSeparator;
    }

    @Override
    public String asWords(Integer value, GenderType genderType) {
        if (this.baseValues.containsKey(value)) {
            return this.baseValues.get(value).formFor(genderType);
        }
        if (Range.closed((Comparable)Integer.valueOf(21), (Comparable)Integer.valueOf(99)).contains((Comparable)value)) {
            return this.twoDigitsNumberAsString(value, genderType);
        }
        if (Range.closed((Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(999)).contains((Comparable)value)) {
            return this.threeDigitsNumberAsString(value, genderType);
        }
        throw new IllegalArgumentException(String.format("Can't convert %d", value));
    }

    private String twoDigitsNumberAsString(Integer value, GenderType genderType) {
        Integer units = value % 10;
        Integer tens = value - units;
        return String.format("%s%c%s", this.asWords(tens, genderType), Character.valueOf(this.twoDigitsNumberSeparator), this.asWords(units, genderType));
    }

    private String threeDigitsNumberAsString(Integer value, GenderType genderType) {
        Integer tensWithUnits = value % 100;
        Integer hundreds = value - tensWithUnits;
        return String.format("%s %s", this.asWords(hundreds, genderType), this.asWords(tensWithUnits, genderType));
    }
}

