/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.util.SafeEncoder;

public class ClientSideCache {
    private final Map<ByteBuffer, Object> cache = new HashMap<ByteBuffer, Object>();

    protected ClientSideCache() {
    }

    protected void invalidateKeys(List list) {
        if (list == null) {
            this.cache.clear();
            return;
        }
        list.forEach(this::invalidateKey);
    }

    private void invalidateKey(Object key) {
        if (!(key instanceof byte[])) {
            throw new JedisException("" + key.getClass().getSimpleName() + " is not supported. Value: " + String.valueOf(key));
        }
        this.cache.remove(ClientSideCache.convertKey((byte[])key));
    }

    protected void setKey(Object key, Object value) {
        this.cache.put(this.getMapKey(key), value);
    }

    protected <T> T getValue(Object key) {
        return (T)this.getMapValue(key);
    }

    private Object getMapValue(Object key) {
        return this.cache.get(this.getMapKey(key));
    }

    private ByteBuffer getMapKey(Object key) {
        if (key instanceof byte[]) {
            return ClientSideCache.convertKey((byte[])key);
        }
        return ClientSideCache.convertKey(SafeEncoder.encode(String.valueOf(key)));
    }

    private static ByteBuffer convertKey(byte[] b) {
        return ByteBuffer.wrap(b);
    }
}

