/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.TransactionBase;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.graph.ResultSet;
import redis.clients.jedis.mcf.CircuitBreakerFailoverConnectionProvider;
import redis.clients.jedis.providers.MultiClusterPooledConnectionProvider;
import redis.clients.jedis.util.KeyValue;

public class MultiClusterTransaction
extends TransactionBase {
    private static final Builder<?> NO_OP_BUILDER = BuilderFactory.RAW_OBJECT;
    private final CircuitBreakerFailoverConnectionProvider provider;
    private final AtomicInteger extraCommandCount = new AtomicInteger();
    private final Queue<KeyValue<CommandArguments, Response<?>>> commands = new LinkedList();
    private boolean inWatch = false;
    private boolean inMulti = false;

    public MultiClusterTransaction(MultiClusterPooledConnectionProvider provider) {
        this(provider, true);
    }

    public MultiClusterTransaction(MultiClusterPooledConnectionProvider provider, boolean doMulti) {
        try (Connection connection = provider.getConnection();){
            RedisProtocol proto = connection.getRedisProtocol();
            if (proto != null) {
                this.commandObjects.setProtocol(proto);
            }
        }
        this.provider = new CircuitBreakerFailoverConnectionProvider(provider);
        if (doMulti) {
            this.multi();
        }
    }

    @Override
    public final void multi() {
        this.appendCommand(new CommandObject(new CommandArguments(Protocol.Command.MULTI), NO_OP_BUILDER));
        this.extraCommandCount.incrementAndGet();
        this.inMulti = true;
    }

    @Override
    public final String watch(String ... keys) {
        this.appendCommand(new CommandObject(new CommandArguments(Protocol.Command.WATCH).addObjects(keys), NO_OP_BUILDER));
        this.extraCommandCount.incrementAndGet();
        this.inWatch = true;
        return null;
    }

    @Override
    public final String watch(byte[] ... keys) {
        this.appendCommand(new CommandObject(new CommandArguments(Protocol.Command.WATCH).addObjects((Object[])keys), NO_OP_BUILDER));
        this.extraCommandCount.incrementAndGet();
        this.inWatch = true;
        return null;
    }

    @Override
    public final String unwatch() {
        this.appendCommand(new CommandObject(new CommandArguments(Protocol.Command.UNWATCH), NO_OP_BUILDER));
        this.extraCommandCount.incrementAndGet();
        this.inWatch = false;
        return null;
    }

    @Override
    protected final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        CommandArguments args = commandObject.getArguments();
        Response<T> response = new Response<T>(commandObject.getBuilder());
        this.commands.add(KeyValue.of(args, response));
        return response;
    }

    @Override
    public void close() {
        this.clear();
    }

    private void clear() {
        if (this.inMulti) {
            this.discard();
        } else if (this.inWatch) {
            this.unwatch();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public final List<Object> exec() {
        if (!this.inMulti) {
            throw new IllegalStateException("EXEC without MULTI");
        }
        try {
            ArrayList<Object> arrayList;
            try (Connection connection = this.provider.getConnection();){
                this.commands.forEach(command -> connection.sendCommand((CommandArguments)command.getKey()));
                connection.getMany(this.commands.size());
                for (int idx = 0; idx < this.extraCommandCount.get(); ++idx) {
                    this.commands.poll();
                }
                connection.sendCommand(Protocol.Command.EXEC);
                List<Object> unformatted = connection.getObjectMultiBulkReply();
                if (unformatted == null) {
                    this.commands.clear();
                    List<Object> list = null;
                    return list;
                }
                ArrayList<Object> formatted = new ArrayList<Object>(unformatted.size() - this.extraCommandCount.get());
                for (Object rawReply : unformatted) {
                    try {
                        Response response = (Response)this.commands.poll().getValue();
                        response.set(rawReply);
                        formatted.add(response.get());
                    }
                    catch (JedisDataException e) {
                        formatted.add(e);
                    }
                }
                arrayList = formatted;
            }
            return arrayList;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.inMulti = false;
            this.inWatch = false;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public final String discard() {
        if (!this.inMulti) {
            throw new IllegalStateException("DISCARD without MULTI");
        }
        try {
            try (Connection connection = this.provider.getConnection();){
                this.commands.forEach(command -> connection.sendCommand((CommandArguments)command.getKey()));
                connection.getMany(this.commands.size());
                connection.sendCommand(Protocol.Command.DISCARD);
                String string = connection.getStatusCodeReply();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.inMulti = false;
            this.inWatch = false;
        }
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, long timeout) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, long timeout) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, Map<String, Object> params) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, Map<String, Object> params) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, Map<String, Object> params, long timeout) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, Map<String, Object> params, long timeout) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<String> graphDelete(String name) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<List<String>> graphProfile(String graphName, String query) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }
}

