package redis.clients.jedis;

import java.util.EnumSet;
import static redis.clients.jedis.StaticCommandFlagsRegistry.EMPTY_FLAGS;
import static redis.clients.jedis.CommandFlagsRegistry.CommandFlag;

/**
 * Static implementation of CommandFlagsRegistry. This class is auto-generated by
 * CommandFlagsRegistryGenerator. DO NOT EDIT MANUALLY.
 * <p>
 * Generated from Redis Server:
 * <ul>
 * <li>Version: 8.2.3</li>
 * <li>Mode: standalone</li>
 * <li>Loaded Modules: timeseries, search, bf, vectorset, ReJSON</li>
 * <li>Generated at: 2025-11-04 20:10:39 EET</li>
 * </ul>
 */
final class StaticCommandFlagsRegistryInitializer {

  static void initialize(StaticCommandFlagsRegistry.Builder builder) {
    builder.register("ACL", EMPTY_FLAGS); // ACL parent command with subcommands
    builder.register("ACL", "CAT",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("ACL", "DELUSER",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("ACL", "DRYRUN",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("ACL", "GENPASS",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("ACL", "GETUSER",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("ACL", "LIST",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("ACL", "LOAD",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("ACL", "LOG",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("ACL", "SAVE",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("ACL", "SETUSER",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("ACL", "USERS",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("ACL", "WHOAMI",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("OBJECT", EMPTY_FLAGS); // OBJECT parent command with subcommands
    builder.register("OBJECT", "ENCODING", EnumSet.of(CommandFlag.READONLY));
    builder.register("OBJECT", "FREQ", EnumSet.of(CommandFlag.READONLY));
    builder.register("OBJECT", "IDLETIME", EnumSet.of(CommandFlag.READONLY));
    builder.register("OBJECT", "REFCOUNT", EnumSet.of(CommandFlag.READONLY));
    builder.register("FUNCTION", EMPTY_FLAGS); // FUNCTION parent command with subcommands
    builder.register("FUNCTION", "DELETE", EnumSet.of(CommandFlag.NOSCRIPT, CommandFlag.WRITE));
    builder.register("FUNCTION", "DUMP", EnumSet.of(CommandFlag.NOSCRIPT));
    builder.register("FUNCTION", "FLUSH", EnumSet.of(CommandFlag.NOSCRIPT, CommandFlag.WRITE));
    builder.register("FUNCTION", "KILL", EnumSet.of(CommandFlag.ALLOW_BUSY, CommandFlag.NOSCRIPT));
    builder.register("FUNCTION", "LIST", EnumSet.of(CommandFlag.NOSCRIPT));
    builder.register("FUNCTION", "LOAD",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.NOSCRIPT, CommandFlag.WRITE));
    builder.register("FUNCTION", "RESTORE",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.NOSCRIPT, CommandFlag.WRITE));
    builder.register("FUNCTION", "STATS", EnumSet.of(CommandFlag.ALLOW_BUSY, CommandFlag.NOSCRIPT));
    builder.register("CLIENT", EMPTY_FLAGS); // CLIENT parent command with subcommands
    builder.register("CLIENT", "CACHING",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLIENT", "GETNAME",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLIENT", "GETREDIR",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLIENT", "ID",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLIENT", "INFO",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLIENT", "KILL",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLIENT", "LIST",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLIENT", "NO-EVICT",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLIENT", "NO-TOUCH",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLIENT", "PAUSE",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLIENT", "REPLY",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLIENT", "SETINFO",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLIENT", "SETNAME",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLIENT", "TRACKING",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLIENT", "TRACKINGINFO",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLIENT", "UNBLOCK",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLIENT", "UNPAUSE",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CONFIG", EMPTY_FLAGS); // CONFIG parent command with subcommands
    builder.register("CONFIG", "GET",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CONFIG", "RESETSTAT",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CONFIG", "REWRITE",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CONFIG", "SET",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("MODULE", EMPTY_FLAGS); // MODULE parent command with subcommands
    builder.register("MODULE", "LIST", EnumSet.of(CommandFlag.ADMIN, CommandFlag.NOSCRIPT));
    builder.register("MODULE", "LOAD",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NOSCRIPT, CommandFlag.NO_ASYNC_LOADING));
    builder.register("MODULE", "LOADEX",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NOSCRIPT, CommandFlag.NO_ASYNC_LOADING));
    builder.register("MODULE", "UNLOAD",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NOSCRIPT, CommandFlag.NO_ASYNC_LOADING));
    builder.register("PUBSUB", EMPTY_FLAGS); // PUBSUB parent command with subcommands
    builder.register("PUBSUB", "CHANNELS",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.PUBSUB, CommandFlag.STALE));
    builder.register("PUBSUB", "NUMPAT",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.PUBSUB, CommandFlag.STALE));
    builder.register("PUBSUB", "NUMSUB",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.PUBSUB, CommandFlag.STALE));
    builder.register("PUBSUB", "SHARDCHANNELS",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.PUBSUB, CommandFlag.STALE));
    builder.register("PUBSUB", "SHARDNUMSUB",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.PUBSUB, CommandFlag.STALE));
    builder.register("SCRIPT", EMPTY_FLAGS); // SCRIPT parent command with subcommands
    builder.register("SCRIPT", "DEBUG", EnumSet.of(CommandFlag.NOSCRIPT));
    builder.register("SCRIPT", "EXISTS", EnumSet.of(CommandFlag.NOSCRIPT));
    builder.register("SCRIPT", "FLUSH", EnumSet.of(CommandFlag.NOSCRIPT));
    builder.register("SCRIPT", "KILL", EnumSet.of(CommandFlag.ALLOW_BUSY, CommandFlag.NOSCRIPT));
    builder.register("SCRIPT", "LOAD", EnumSet.of(CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("MEMORY", EMPTY_FLAGS); // MEMORY parent command with subcommands
    builder.register("MEMORY", "DOCTOR", EMPTY_FLAGS);
    builder.register("MEMORY", "MALLOC-STATS", EMPTY_FLAGS);
    builder.register("MEMORY", "PURGE", EMPTY_FLAGS);
    builder.register("MEMORY", "STATS", EMPTY_FLAGS);
    builder.register("MEMORY", "USAGE", EnumSet.of(CommandFlag.READONLY));
    builder.register("SLOWLOG", EMPTY_FLAGS); // SLOWLOG parent command with subcommands
    builder.register("SLOWLOG", "GET",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("SLOWLOG", "LEN",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("SLOWLOG", "RESET",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("COMMAND", EMPTY_FLAGS); // COMMAND parent command with subcommands
    builder.register("COMMAND", "COUNT", EnumSet.of(CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("COMMAND", "DOCS", EnumSet.of(CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("COMMAND", "GETKEYS", EnumSet.of(CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("COMMAND", "GETKEYSANDFLAGS",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("COMMAND", "INFO", EnumSet.of(CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("COMMAND", "LIST", EnumSet.of(CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("LATENCY", EMPTY_FLAGS); // LATENCY parent command with subcommands
    builder.register("LATENCY", "DOCTOR",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("LATENCY", "GRAPH",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("LATENCY", "HISTOGRAM",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("LATENCY", "HISTORY",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("LATENCY", "LATEST",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("LATENCY", "RESET",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLUSTER", EMPTY_FLAGS); // CLUSTER parent command with subcommands
    builder.register("CLUSTER", "ADDSLOTS",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NO_ASYNC_LOADING, CommandFlag.STALE));
    builder.register("CLUSTER", "ADDSLOTSRANGE",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NO_ASYNC_LOADING, CommandFlag.STALE));
    builder.register("CLUSTER", "BUMPEPOCH",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NO_ASYNC_LOADING, CommandFlag.STALE));
    builder.register("CLUSTER", "COUNT-FAILURE-REPORTS",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.STALE));
    builder.register("CLUSTER", "COUNTKEYSINSLOT", EnumSet.of(CommandFlag.STALE));
    builder.register("CLUSTER", "DELSLOTS",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NO_ASYNC_LOADING, CommandFlag.STALE));
    builder.register("CLUSTER", "DELSLOTSRANGE",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NO_ASYNC_LOADING, CommandFlag.STALE));
    builder.register("CLUSTER", "FAILOVER",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NO_ASYNC_LOADING, CommandFlag.STALE));
    builder.register("CLUSTER", "FLUSHSLOTS",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NO_ASYNC_LOADING, CommandFlag.STALE));
    builder.register("CLUSTER", "FORGET",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NO_ASYNC_LOADING, CommandFlag.STALE));
    builder.register("CLUSTER", "GETKEYSINSLOT", EnumSet.of(CommandFlag.STALE));
    builder.register("CLUSTER", "INFO", EnumSet.of(CommandFlag.STALE));
    builder.register("CLUSTER", "KEYSLOT", EnumSet.of(CommandFlag.STALE));
    builder.register("CLUSTER", "LINKS", EnumSet.of(CommandFlag.STALE));
    builder.register("CLUSTER", "MEET",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NO_ASYNC_LOADING, CommandFlag.STALE));
    builder.register("CLUSTER", "MYID", EnumSet.of(CommandFlag.STALE));
    builder.register("CLUSTER", "MYSHARDID", EnumSet.of(CommandFlag.STALE));
    builder.register("CLUSTER", "NODES", EnumSet.of(CommandFlag.STALE));
    builder.register("CLUSTER", "REPLICAS", EnumSet.of(CommandFlag.ADMIN, CommandFlag.STALE));
    builder.register("CLUSTER", "REPLICATE",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NO_ASYNC_LOADING, CommandFlag.STALE));
    builder.register("CLUSTER", "RESET",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("CLUSTER", "SAVECONFIG",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NO_ASYNC_LOADING, CommandFlag.STALE));
    builder.register("CLUSTER", "SET-CONFIG-EPOCH",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NO_ASYNC_LOADING, CommandFlag.STALE));
    builder.register("CLUSTER", "SETSLOT",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NO_ASYNC_LOADING, CommandFlag.STALE));
    builder.register("CLUSTER", "SHARDS", EnumSet.of(CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("CLUSTER", "SLAVES", EnumSet.of(CommandFlag.ADMIN, CommandFlag.STALE));
    builder.register("CLUSTER", "SLOT-STATS", EnumSet.of(CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("CLUSTER", "SLOTS", EnumSet.of(CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("XINFO", EMPTY_FLAGS); // XINFO parent command with subcommands
    builder.register("XINFO", "CONSUMERS", EnumSet.of(CommandFlag.READONLY));
    builder.register("XINFO", "GROUPS", EnumSet.of(CommandFlag.READONLY));
    builder.register("XINFO", "STREAM", EnumSet.of(CommandFlag.READONLY));
    builder.register("XGROUP", EMPTY_FLAGS); // XGROUP parent command with subcommands
    builder.register("XGROUP", "CREATE", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("XGROUP", "CREATECONSUMER",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("XGROUP", "DELCONSUMER", EnumSet.of(CommandFlag.WRITE));
    builder.register("XGROUP", "DESTROY", EnumSet.of(CommandFlag.WRITE));
    builder.register("XGROUP", "SETID", EnumSet.of(CommandFlag.WRITE));
    // 1 command(s) with: admin
    builder.register("PFSELFTEST", EnumSet.of(CommandFlag.ADMIN));

    // 2 command(s) with: blocking
    builder.register("WAIT", EnumSet.of(CommandFlag.BLOCKING));
    builder.register("WAITAOF", EnumSet.of(CommandFlag.BLOCKING));

    // 2 command(s) with: fast
    builder.register("ASKING", EnumSet.of(CommandFlag.FAST));
    builder.register("PING", EnumSet.of(CommandFlag.FAST));

    // 41 command(s) with: readonly
    builder.register("BITCOUNT", EnumSet.of(CommandFlag.READONLY));
    builder.register("BITPOS", EnumSet.of(CommandFlag.READONLY));
    builder.register("DUMP", EnumSet.of(CommandFlag.READONLY));
    builder.register("GEODIST", EnumSet.of(CommandFlag.READONLY));
    builder.register("GEOHASH", EnumSet.of(CommandFlag.READONLY));
    builder.register("GEOPOS", EnumSet.of(CommandFlag.READONLY));
    builder.register("GEORADIUSBYMEMBER_RO", EnumSet.of(CommandFlag.READONLY));
    builder.register("GEORADIUS_RO", EnumSet.of(CommandFlag.READONLY));
    builder.register("GEOSEARCH", EnumSet.of(CommandFlag.READONLY));
    builder.register("GETRANGE", EnumSet.of(CommandFlag.READONLY));
    builder.register("HGETALL", EnumSet.of(CommandFlag.READONLY));
    builder.register("HKEYS", EnumSet.of(CommandFlag.READONLY));
    builder.register("HRANDFIELD", EnumSet.of(CommandFlag.READONLY));
    builder.register("HSCAN", EnumSet.of(CommandFlag.READONLY));
    builder.register("HVALS", EnumSet.of(CommandFlag.READONLY));
    builder.register("KEYS", EnumSet.of(CommandFlag.READONLY));
    builder.register("LCS", EnumSet.of(CommandFlag.READONLY));
    builder.register("LINDEX", EnumSet.of(CommandFlag.READONLY));
    builder.register("LPOS", EnumSet.of(CommandFlag.READONLY));
    builder.register("LRANGE", EnumSet.of(CommandFlag.READONLY));
    builder.register("PFCOUNT", EnumSet.of(CommandFlag.READONLY));
    builder.register("RANDOMKEY", EnumSet.of(CommandFlag.READONLY));
    builder.register("SCAN", EnumSet.of(CommandFlag.READONLY));
    builder.register("SDIFF", EnumSet.of(CommandFlag.READONLY));
    builder.register("SINTER", EnumSet.of(CommandFlag.READONLY));
    builder.register("SMEMBERS", EnumSet.of(CommandFlag.READONLY));
    builder.register("SRANDMEMBER", EnumSet.of(CommandFlag.READONLY));
    builder.register("SSCAN", EnumSet.of(CommandFlag.READONLY));
    builder.register("SUBSTR", EnumSet.of(CommandFlag.READONLY));
    builder.register("SUNION", EnumSet.of(CommandFlag.READONLY));
    builder.register("XPENDING", EnumSet.of(CommandFlag.READONLY));
    builder.register("XRANGE", EnumSet.of(CommandFlag.READONLY));
    builder.register("XREVRANGE", EnumSet.of(CommandFlag.READONLY));
    builder.register("ZRANDMEMBER", EnumSet.of(CommandFlag.READONLY));
    builder.register("ZRANGE", EnumSet.of(CommandFlag.READONLY));
    builder.register("ZRANGEBYLEX", EnumSet.of(CommandFlag.READONLY));
    builder.register("ZRANGEBYSCORE", EnumSet.of(CommandFlag.READONLY));
    builder.register("ZREVRANGE", EnumSet.of(CommandFlag.READONLY));
    builder.register("ZREVRANGEBYLEX", EnumSet.of(CommandFlag.READONLY));
    builder.register("ZREVRANGEBYSCORE", EnumSet.of(CommandFlag.READONLY));
    builder.register("ZSCAN", EnumSet.of(CommandFlag.READONLY));

    // 10 command(s) with: write
    builder.register("DEL", EnumSet.of(CommandFlag.WRITE));
    builder.register("FLUSHALL", EnumSet.of(CommandFlag.WRITE));
    builder.register("FLUSHDB", EnumSet.of(CommandFlag.WRITE));
    builder.register("LREM", EnumSet.of(CommandFlag.WRITE));
    builder.register("LTRIM", EnumSet.of(CommandFlag.WRITE));
    builder.register("RENAME", EnumSet.of(CommandFlag.WRITE));
    builder.register("XTRIM", EnumSet.of(CommandFlag.WRITE));
    builder.register("ZREMRANGEBYLEX", EnumSet.of(CommandFlag.WRITE));
    builder.register("ZREMRANGEBYRANK", EnumSet.of(CommandFlag.WRITE));
    builder.register("ZREMRANGEBYSCORE", EnumSet.of(CommandFlag.WRITE));

    // 2 command(s) with: blocking, write
    builder.register("BLPOP", EnumSet.of(CommandFlag.BLOCKING, CommandFlag.WRITE));
    builder.register("BRPOP", EnumSet.of(CommandFlag.BLOCKING, CommandFlag.WRITE));

    // 22 command(s) with: denyoom, write
    builder.register("BITFIELD", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("BITOP", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("COPY", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("GEOADD", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("GEOSEARCHSTORE", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("LINSERT", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("LMOVE", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("LSET", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("MSET", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("MSETNX", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("MSETEX", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("PFMERGE", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("PSETEX", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("RESTORE", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("RPOPLPUSH", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("SDIFFSTORE", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("SET", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("SETBIT", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("SETEX", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("SETRANGE", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("SINTERSTORE", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("SUNIONSTORE", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("ZRANGESTORE", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.WRITE));

    // 35 command(s) with: fast, readonly
    builder.register("BITFIELD_RO", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("DBSIZE", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("EXISTS", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("EXPIRETIME", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("GET", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("GETBIT", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("HEXISTS", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("HEXPIRETIME", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("HGET", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("HLEN", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("HMGET", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("HPEXPIRETIME", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("HPTTL", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("HSTRLEN", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("HTTL", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("LLEN", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("LOLWUT", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("MGET", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("PEXPIRETIME", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("PTTL", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("SCARD", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("SISMEMBER", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("SMISMEMBER", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("STRLEN", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("TOUCH", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("TTL", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("TYPE", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("XLEN", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("ZCARD", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("ZCOUNT", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("ZLEXCOUNT", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("ZMSCORE", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("ZRANK", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("ZREVRANK", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));
    builder.register("ZSCORE", EnumSet.of(CommandFlag.FAST, CommandFlag.READONLY));

    // 33 command(s) with: fast, write
    builder.register("EXPIRE", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("EXPIREAT", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("GETDEL", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("GETEX", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("HDEL", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("HEXPIRE", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("HEXPIREAT", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("HGETDEL", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("HGETEX", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("HPERSIST", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("HPEXPIRE", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("HPEXPIREAT", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("LPOP", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("MOVE", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("PERSIST", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("PEXPIRE", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("PEXPIREAT", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("RENAMENX", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("RPOP", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("SMOVE", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("SPOP", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("SREM", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("SWAPDB", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("UNLINK", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("XACK", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("XACKDEL", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("XAUTOCLAIM", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("XCLAIM", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("XDEL", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("XDELEX", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("ZPOPMAX", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("ZPOPMIN", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("ZREM", EnumSet.of(CommandFlag.FAST, CommandFlag.WRITE));

    // 1 command(s) with: loading, stale
    builder.register("INFO", EnumSet.of(CommandFlag.LOADING, CommandFlag.STALE));

    // 55 command(s) with: module, readonly
    builder.register("CMS.INFO", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("CMS.QUERY", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT.AGGREGATE", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT.CONFIG", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT.CURSOR", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT.DICTDUMP", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT.EXPLAIN", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT.EXPLAINCLI", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT.GET", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT.INFO", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT.MGET", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT.PROFILE", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT.SEARCH", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT.SPELLCHECK", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT.SUGGET", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT.SUGLEN", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT.SYNDUMP", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT.TAGVALS", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("FT._LIST", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("JSON.ARRINDEX", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("JSON.ARRLEN", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("JSON.DEBUG", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("JSON.GET", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("JSON.MGET", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("JSON.OBJKEYS", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("JSON.OBJLEN", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("JSON.RESP", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("JSON.STRLEN", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("JSON.TYPE", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TDIGEST.BYRANK", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TDIGEST.BYREVRANK", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TDIGEST.CDF", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TDIGEST.INFO", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TDIGEST.MAX", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TDIGEST.MIN", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TDIGEST.QUANTILE", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TDIGEST.RANK", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TDIGEST.REVRANK", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TDIGEST.TRIMMED_MEAN", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TOPK.COUNT", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TOPK.INFO", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TOPK.LIST", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TOPK.QUERY", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TS.GET", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TS.INFO", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TS.MGET", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TS.MRANGE", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TS.MREVRANGE", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TS.QUERYINDEX", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TS.RANGE", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("TS.REVRANGE", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("VISMEMBER", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("VRANDMEMBER", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("VSIM", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("_FT.CONFIG", EnumSet.of(CommandFlag.MODULE, CommandFlag.READONLY));

    // 20 command(s) with: module, write
    builder.register("FT.ALIASDEL", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT.DEL", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT.DICTDEL", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT.DROP", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT.DROPINDEX", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT.SUGDEL", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT._ALIASDELIFX", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT._DROPIFX", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT._DROPINDEXIFX", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("JSON.ARRPOP", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("JSON.ARRTRIM", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("JSON.CLEAR", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("JSON.DEL", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("JSON.FORGET", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("JSON.NUMINCRBY", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("JSON.NUMMULTBY", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("JSON.NUMPOWBY", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("TS.DEL", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("TS.DELETERULE", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("VREM", EnumSet.of(CommandFlag.MODULE, CommandFlag.WRITE));

    // 6 command(s) with: movablekeys, readonly
    builder.register("SINTERCARD", EnumSet.of(CommandFlag.MOVABLEKEYS, CommandFlag.READONLY));
    builder.register("SORT_RO", EnumSet.of(CommandFlag.MOVABLEKEYS, CommandFlag.READONLY));
    builder.register("ZDIFF", EnumSet.of(CommandFlag.MOVABLEKEYS, CommandFlag.READONLY));
    builder.register("ZINTER", EnumSet.of(CommandFlag.MOVABLEKEYS, CommandFlag.READONLY));
    builder.register("ZINTERCARD", EnumSet.of(CommandFlag.MOVABLEKEYS, CommandFlag.READONLY));
    builder.register("ZUNION", EnumSet.of(CommandFlag.MOVABLEKEYS, CommandFlag.READONLY));

    // 3 command(s) with: movablekeys, write
    builder.register("LMPOP", EnumSet.of(CommandFlag.MOVABLEKEYS, CommandFlag.WRITE));
    builder.register("MIGRATE", EnumSet.of(CommandFlag.MOVABLEKEYS, CommandFlag.WRITE));
    builder.register("ZMPOP", EnumSet.of(CommandFlag.MOVABLEKEYS, CommandFlag.WRITE));

    // 1 command(s) with: admin, denyoom, write
    builder.register("PFDEBUG",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.DENYOOM, CommandFlag.WRITE));

    // 2 command(s) with: admin, noscript, no_async_loading
    builder.register("BGREWRITEAOF",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NOSCRIPT, CommandFlag.NO_ASYNC_LOADING));
    builder.register("BGSAVE",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NOSCRIPT, CommandFlag.NO_ASYNC_LOADING));

    // 1 command(s) with: admin, noscript, stale
    builder.register("FAILOVER",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.NOSCRIPT, CommandFlag.STALE));

    // 1 command(s) with: asking, denyoom, write
    builder.register("RESTORE-ASKING",
      EnumSet.of(CommandFlag.ASKING, CommandFlag.DENYOOM, CommandFlag.WRITE));

    // 2 command(s) with: blocking, denyoom, write
    builder.register("BLMOVE",
      EnumSet.of(CommandFlag.BLOCKING, CommandFlag.DENYOOM, CommandFlag.WRITE));
    builder.register("BRPOPLPUSH",
      EnumSet.of(CommandFlag.BLOCKING, CommandFlag.DENYOOM, CommandFlag.WRITE));

    // 2 command(s) with: blocking, fast, write
    builder.register("BZPOPMAX",
      EnumSet.of(CommandFlag.BLOCKING, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("BZPOPMIN",
      EnumSet.of(CommandFlag.BLOCKING, CommandFlag.FAST, CommandFlag.WRITE));

    // 1 command(s) with: blocking, movablekeys, readonly
    builder.register("XREAD",
      EnumSet.of(CommandFlag.BLOCKING, CommandFlag.MOVABLEKEYS, CommandFlag.READONLY));

    // 3 command(s) with: blocking, movablekeys, write
    builder.register("BLMPOP",
      EnumSet.of(CommandFlag.BLOCKING, CommandFlag.MOVABLEKEYS, CommandFlag.WRITE));
    builder.register("BZMPOP",
      EnumSet.of(CommandFlag.BLOCKING, CommandFlag.MOVABLEKEYS, CommandFlag.WRITE));
    builder.register("XREADGROUP",
      EnumSet.of(CommandFlag.BLOCKING, CommandFlag.MOVABLEKEYS, CommandFlag.WRITE));

    // 24 command(s) with: denyoom, fast, write
    builder.register("APPEND",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("DECR", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("DECRBY",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("GETSET",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("HINCRBY",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("HINCRBYFLOAT",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("HMSET", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("HSET", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("HSETEX",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("HSETNX",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("INCR", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("INCRBY",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("INCRBYFLOAT",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("LPUSH", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("LPUSHX",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("PFADD", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("RPUSH", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("RPUSHX",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("SADD", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("SETNX", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("XADD", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("XSETID",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("ZADD", EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));
    builder.register("ZINCRBY",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.FAST, CommandFlag.WRITE));

    // 49 command(s) with: denyoom, module, write
    builder.register("BF.ADD",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("BF.INSERT",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("BF.LOADCHUNK",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("BF.MADD",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("BF.RESERVE",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("CF.ADD",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("CF.ADDNX",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("CF.INSERT",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("CF.INSERTNX",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("CF.LOADCHUNK",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("CF.RESERVE",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("CMS.INCRBY",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("CMS.INITBYDIM",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("CMS.INITBYPROB",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("CMS.MERGE",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT.ADD",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT.ALIASADD",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT.ALIASUPDATE",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT.ALTER",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT.CREATE",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT.DICTADD",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT.SUGADD",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT.SYNADD",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT.SYNUPDATE",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT._ALIASADDIFNX",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT._ALTERIFNX",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("FT._CREATEIFNX",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("JSON.ARRAPPEND",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("JSON.ARRINSERT",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("JSON.MERGE",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("JSON.MSET",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("JSON.SET",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("JSON.STRAPPEND",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("JSON.TOGGLE",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("TDIGEST.ADD",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("TDIGEST.CREATE",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("TDIGEST.MERGE",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("TDIGEST.RESET",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("TOPK.ADD",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("TOPK.INCRBY",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("TOPK.RESERVE",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("TS.ADD",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("TS.ALTER",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("TS.CREATE",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("TS.DECRBY",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("TS.INCRBY",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("TS.MADD",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("VADD",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("_FT.SAFEADD",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MODULE, CommandFlag.WRITE));

    // 6 command(s) with: denyoom, movablekeys, write
    builder.register("GEORADIUS",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MOVABLEKEYS, CommandFlag.WRITE));
    builder.register("GEORADIUSBYMEMBER",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MOVABLEKEYS, CommandFlag.WRITE));
    builder.register("SORT",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MOVABLEKEYS, CommandFlag.WRITE));
    builder.register("ZDIFFSTORE",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MOVABLEKEYS, CommandFlag.WRITE));
    builder.register("ZINTERSTORE",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MOVABLEKEYS, CommandFlag.WRITE));
    builder.register("ZUNIONSTORE",
      EnumSet.of(CommandFlag.DENYOOM, CommandFlag.MOVABLEKEYS, CommandFlag.WRITE));

    // 6 command(s) with: fast, loading, stale
    builder.register("ECHO", EnumSet.of(CommandFlag.FAST, CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("LASTSAVE",
      EnumSet.of(CommandFlag.FAST, CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("READONLY",
      EnumSet.of(CommandFlag.FAST, CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("READWRITE",
      EnumSet.of(CommandFlag.FAST, CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("SELECT",
      EnumSet.of(CommandFlag.FAST, CommandFlag.LOADING, CommandFlag.STALE));
    builder.register("TIME", EnumSet.of(CommandFlag.FAST, CommandFlag.LOADING, CommandFlag.STALE));

    // 19 command(s) with: fast, module, readonly
    builder.register("BF.CARD",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("BF.DEBUG",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("BF.EXISTS",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("BF.INFO",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("BF.MEXISTS",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("BF.SCANDUMP",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("CF.COMPACT",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("CF.COUNT",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("CF.DEBUG",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("CF.EXISTS",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("CF.INFO",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("CF.MEXISTS",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("CF.SCANDUMP",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("VCARD",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("VDIM",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("VEMB",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("VGETATTR",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("VINFO",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));
    builder.register("VLINKS",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.READONLY));

    // 3 command(s) with: fast, module, write
    builder.register("CF.DEL", EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("TS.CREATERULE",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.WRITE));
    builder.register("VSETATTR",
      EnumSet.of(CommandFlag.FAST, CommandFlag.MODULE, CommandFlag.WRITE));

    // 3 command(s) with: module, noscript, readonly
    builder.register("SEARCH.CLUSTERREFRESH",
      EnumSet.of(CommandFlag.MODULE, CommandFlag.NOSCRIPT, CommandFlag.READONLY));
    builder.register("TIMESERIES.CLUSTERSET",
      EnumSet.of(CommandFlag.MODULE, CommandFlag.NOSCRIPT, CommandFlag.READONLY));
    builder.register("TIMESERIES.REFRESHCLUSTER",
      EnumSet.of(CommandFlag.MODULE, CommandFlag.NOSCRIPT, CommandFlag.READONLY));

    // 2 command(s) with: admin, loading, noscript, stale
    builder.register("DEBUG",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("MONITOR",
      EnumSet.of(CommandFlag.ADMIN, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));

    // 3 command(s) with: admin, noscript, no_async_loading, no_multi
    builder.register("PSYNC", EnumSet.of(CommandFlag.ADMIN, CommandFlag.NOSCRIPT,
      CommandFlag.NO_ASYNC_LOADING, CommandFlag.NO_MULTI));
    builder.register("SAVE", EnumSet.of(CommandFlag.ADMIN, CommandFlag.NOSCRIPT,
      CommandFlag.NO_ASYNC_LOADING, CommandFlag.NO_MULTI));
    builder.register("SYNC", EnumSet.of(CommandFlag.ADMIN, CommandFlag.NOSCRIPT,
      CommandFlag.NO_ASYNC_LOADING, CommandFlag.NO_MULTI));

    // 2 command(s) with: admin, noscript, no_async_loading, stale
    builder.register("REPLICAOF", EnumSet.of(CommandFlag.ADMIN, CommandFlag.NOSCRIPT,
      CommandFlag.NO_ASYNC_LOADING, CommandFlag.STALE));
    builder.register("SLAVEOF", EnumSet.of(CommandFlag.ADMIN, CommandFlag.NOSCRIPT,
      CommandFlag.NO_ASYNC_LOADING, CommandFlag.STALE));

    // 1 command(s) with: fast, loading, noscript, stale
    builder.register("ROLE",
      EnumSet.of(CommandFlag.FAST, CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));

    // 2 command(s) with: fast, loading, pubsub, stale
    builder.register("PUBLISH",
      EnumSet.of(CommandFlag.FAST, CommandFlag.LOADING, CommandFlag.PUBSUB, CommandFlag.STALE));
    builder.register("SPUBLISH",
      EnumSet.of(CommandFlag.FAST, CommandFlag.LOADING, CommandFlag.PUBSUB, CommandFlag.STALE));

    // 2 command(s) with: loading, module, noscript, readonly
    builder.register("SEARCH.CLUSTERINFO", EnumSet.of(CommandFlag.LOADING, CommandFlag.MODULE,
      CommandFlag.NOSCRIPT, CommandFlag.READONLY));
    builder.register("SEARCH.CLUSTERSET", EnumSet.of(CommandFlag.LOADING, CommandFlag.MODULE,
      CommandFlag.NOSCRIPT, CommandFlag.READONLY));

    // 6 command(s) with: loading, noscript, pubsub, stale
    builder.register("PSUBSCRIBE",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.PUBSUB, CommandFlag.STALE));
    builder.register("PUNSUBSCRIBE",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.PUBSUB, CommandFlag.STALE));
    builder.register("SSUBSCRIBE",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.PUBSUB, CommandFlag.STALE));
    builder.register("SUBSCRIBE",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.PUBSUB, CommandFlag.STALE));
    builder.register("SUNSUBSCRIBE",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.PUBSUB, CommandFlag.STALE));
    builder.register("UNSUBSCRIBE",
      EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.PUBSUB, CommandFlag.STALE));

    // 1 command(s) with: loading, noscript, skip_slowlog, stale
    builder.register("EXEC", EnumSet.of(CommandFlag.LOADING, CommandFlag.NOSCRIPT,
      CommandFlag.SKIP_SLOWLOG, CommandFlag.STALE));

    // 1 command(s) with: admin, allow_busy, loading, noscript, stale
    builder.register("REPLCONF", EnumSet.of(CommandFlag.ADMIN, CommandFlag.ALLOW_BUSY,
      CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));

    // 4 command(s) with: allow_busy, fast, loading, noscript, stale
    builder.register("DISCARD", EnumSet.of(CommandFlag.ALLOW_BUSY, CommandFlag.FAST,
      CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("MULTI", EnumSet.of(CommandFlag.ALLOW_BUSY, CommandFlag.FAST,
      CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("UNWATCH", EnumSet.of(CommandFlag.ALLOW_BUSY, CommandFlag.FAST,
      CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));
    builder.register("WATCH", EnumSet.of(CommandFlag.ALLOW_BUSY, CommandFlag.FAST,
      CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.STALE));

    // 3 command(s) with: movablekeys, noscript, no_mandatory_keys, skip_monitor, stale
    builder.register("EVAL", EnumSet.of(CommandFlag.MOVABLEKEYS, CommandFlag.NOSCRIPT,
      CommandFlag.NO_MANDATORY_KEYS, CommandFlag.SKIP_MONITOR, CommandFlag.STALE));
    builder.register("EVALSHA", EnumSet.of(CommandFlag.MOVABLEKEYS, CommandFlag.NOSCRIPT,
      CommandFlag.NO_MANDATORY_KEYS, CommandFlag.SKIP_MONITOR, CommandFlag.STALE));
    builder.register("FCALL", EnumSet.of(CommandFlag.MOVABLEKEYS, CommandFlag.NOSCRIPT,
      CommandFlag.NO_MANDATORY_KEYS, CommandFlag.SKIP_MONITOR, CommandFlag.STALE));

    // 1 command(s) with: admin, allow_busy, loading, noscript, no_multi, stale
    builder.register("SHUTDOWN", EnumSet.of(CommandFlag.ADMIN, CommandFlag.ALLOW_BUSY,
      CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.NO_MULTI, CommandFlag.STALE));

    // 4 command(s) with: allow_busy, fast, loading, noscript, no_auth, stale
    builder.register("AUTH", EnumSet.of(CommandFlag.ALLOW_BUSY, CommandFlag.FAST,
      CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.NO_AUTH, CommandFlag.STALE));
    builder.register("HELLO", EnumSet.of(CommandFlag.ALLOW_BUSY, CommandFlag.FAST,
      CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.NO_AUTH, CommandFlag.STALE));
    builder.register("QUIT", EnumSet.of(CommandFlag.ALLOW_BUSY, CommandFlag.FAST,
      CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.NO_AUTH, CommandFlag.STALE));
    builder.register("RESET", EnumSet.of(CommandFlag.ALLOW_BUSY, CommandFlag.FAST,
      CommandFlag.LOADING, CommandFlag.NOSCRIPT, CommandFlag.NO_AUTH, CommandFlag.STALE));

    // 3 command(s) with: movablekeys, noscript, no_mandatory_keys, readonly, skip_monitor, stale
    builder.register("EVALSHA_RO",
      EnumSet.of(CommandFlag.MOVABLEKEYS, CommandFlag.NOSCRIPT, CommandFlag.NO_MANDATORY_KEYS,
        CommandFlag.READONLY, CommandFlag.SKIP_MONITOR, CommandFlag.STALE));
    builder.register("EVAL_RO",
      EnumSet.of(CommandFlag.MOVABLEKEYS, CommandFlag.NOSCRIPT, CommandFlag.NO_MANDATORY_KEYS,
        CommandFlag.READONLY, CommandFlag.SKIP_MONITOR, CommandFlag.STALE));
    builder.register("FCALL_RO",
      EnumSet.of(CommandFlag.MOVABLEKEYS, CommandFlag.NOSCRIPT, CommandFlag.NO_MANDATORY_KEYS,
        CommandFlag.READONLY, CommandFlag.SKIP_MONITOR, CommandFlag.STALE));

  }

}
