/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.precis;

import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.precis.PrecisProfile;
import rocks.xmpp.precis.PrecisProfiles;
import rocks.xmpp.precis.UsernameCaseMappedProfileTest;

public class NicknameProfileTest {
    @Test
    public void shouldReplaceNonAsciiSpaces() {
        Assert.assertEquals((String)PrecisProfiles.NICKNAME.enforce((CharSequence)"a\u00a0a\u1680a\u2000a\u2001a\u2002a\u2003a\u2004a\u2005a\u2006a\u2007a\u2008a\u2009a\u200aa\u202fa\u205fa\u3000a"), (String)"a a a a a a a a a a a a a a a a a");
    }

    @Test
    public void shouldTrim() {
        Assert.assertEquals((String)PrecisProfiles.NICKNAME.enforce((CharSequence)"stpeter "), (String)"stpeter");
    }

    @Test
    public void shouldMapToSingleSpace() {
        Assert.assertEquals((String)PrecisProfiles.NICKNAME.enforce((CharSequence)"st    peter"), (String)"st peter");
    }

    @Test
    public void shouldNormalizeNFKC() {
        Assert.assertEquals((String)PrecisProfiles.NICKNAME.enforce((CharSequence)"\u2163"), (String)"IV");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void shouldNotBeEmpty() {
        PrecisProfiles.NICKNAME.enforce((CharSequence)"");
    }

    @Test
    public void testExamples() {
        Assert.assertEquals((int)PrecisProfiles.NICKNAME.compare((CharSequence)"Foo", (CharSequence)"foo"), (int)0);
        Assert.assertEquals((int)PrecisProfiles.NICKNAME.compare((CharSequence)"foo", (CharSequence)"foo"), (int)0);
        Assert.assertEquals((int)PrecisProfiles.NICKNAME.compare((CharSequence)"Foo Bar", (CharSequence)"foo bar"), (int)0);
        Assert.assertEquals((int)PrecisProfiles.NICKNAME.compare((CharSequence)"foo bar", (CharSequence)"foo bar"), (int)0);
        Assert.assertEquals((int)PrecisProfiles.NICKNAME.compare((CharSequence)"\u03a3", (CharSequence)"\u03c3"), (int)0);
        Assert.assertEquals((int)PrecisProfiles.NICKNAME.compare((CharSequence)"\u03c3", (CharSequence)"\u03c3"), (int)0);
        Assert.assertEquals((int)PrecisProfiles.NICKNAME.compare((CharSequence)"\u03c2", (CharSequence)"\u03c2"), (int)0);
        Assert.assertEquals((int)PrecisProfiles.NICKNAME.compare((CharSequence)"\u265a", (CharSequence)"\u265a"), (int)0);
        Assert.assertEquals((int)PrecisProfiles.NICKNAME.compare((CharSequence)"\u03ab", (CharSequence)"\u03cb"), (int)0);
        Assert.assertEquals((int)PrecisProfiles.NICKNAME.compare((CharSequence)"\u221e", (CharSequence)"\u221e"), (int)0);
        Assert.assertEquals((int)PrecisProfiles.NICKNAME.compare((CharSequence)"Richard \u2163", (CharSequence)"richard iv"), (int)0);
    }

    @Test
    public void testComparison() {
        Assert.assertEquals((String)PrecisProfiles.NICKNAME.toComparableString((CharSequence)"Foo Bar "), (String)PrecisProfiles.NICKNAME.toComparableString((CharSequence)"foo bar"));
    }

    @Test
    public void testIdempotencyEnforcement() {
        UsernameCaseMappedProfileTest.testIdempotency(arg_0 -> ((PrecisProfile)PrecisProfiles.NICKNAME).enforce(arg_0));
    }

    @Test
    public void testIdempotencyComparison() {
        UsernameCaseMappedProfileTest.testIdempotency(arg_0 -> ((PrecisProfile)PrecisProfiles.NICKNAME).toComparableString(arg_0));
    }
}

