/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.precis;

import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.precis.PrecisProfile;
import rocks.xmpp.precis.PrecisProfiles;
import rocks.xmpp.precis.UsernameCaseMappedProfileTest;

public class OpaqueStringProfileTest {
    @Test
    public void testAllowedStrings() {
        Assert.assertEquals((String)PrecisProfiles.OPAQUE_STRING.enforce((CharSequence)"correct horse battery staple"), (String)"correct horse battery staple");
        Assert.assertEquals((String)PrecisProfiles.OPAQUE_STRING.enforce((CharSequence)"Correct Horse Battery Staple"), (String)"Correct Horse Battery Staple");
        Assert.assertEquals((String)PrecisProfiles.OPAQUE_STRING.enforce((CharSequence)"\u03c0\u00df\u00e5"), (String)"\u03c0\u00df\u00e5");
        Assert.assertEquals((String)PrecisProfiles.OPAQUE_STRING.enforce((CharSequence)"Jack of \u2666s"), (String)"Jack of \u2666s");
        Assert.assertEquals((String)PrecisProfiles.OPAQUE_STRING.enforce((CharSequence)"foo\u1680bar"), (String)"foo bar");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testZeroLength() {
        PrecisProfiles.OPAQUE_STRING.enforce((CharSequence)"");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testControlCharacters() {
        PrecisProfiles.OPAQUE_STRING.enforce((CharSequence)"my cat is a \tby");
    }

    @Test
    public void testIdempotencyEnforcement() {
        UsernameCaseMappedProfileTest.testIdempotency(arg_0 -> ((PrecisProfile)PrecisProfiles.OPAQUE_STRING).enforce(arg_0));
    }
}

