/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.context.container;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;

public class ParameterizedTypeImpl
implements ParameterizedType {
    private final Type rawType;
    private final Type[] actualArguments;
    private final Type ownerType;

    public ParameterizedTypeImpl(Type rawType, Type[] actualArguments, Type ownerType) {
        this.rawType = rawType;
        this.actualArguments = Arrays.copyOf(actualArguments, actualArguments.length);
        this.ownerType = ownerType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return Arrays.copyOf(this.actualArguments, this.actualArguments.length);
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    public boolean equals(Object o) {
        boolean res;
        boolean bl = res = this == o;
        if (!res && o instanceof ParameterizedType) {
            ParameterizedType that = (ParameterizedType)o;
            Object[] thatActualArguments = that.getActualTypeArguments();
            Type thatOwnerType = that.getOwnerType();
            Type thatRawType = that.getRawType();
            res = Arrays.equals(this.actualArguments, thatActualArguments) && (this.ownerType != null ? this.ownerType.equals(thatOwnerType) : thatOwnerType == null) && (this.rawType != null ? this.rawType.equals(thatRawType) : thatRawType == null);
        }
        return res;
    }

    public int hashCode() {
        int result = this.rawType != null ? this.rawType.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.actualArguments);
        result = 31 * result + (this.ownerType != null ? this.ownerType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return TypeToStringUtils.toStringType(this, Collections.<String, Type>emptyMap());
    }
}

