/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.python.cmd.exec;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberPlus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import ru.vyarus.gradle.plugin.python.cmd.LoggedCommandCleaner;
import ru.vyarus.gradle.plugin.python.cmd.docker.ContainerManager;
import ru.vyarus.gradle.plugin.python.cmd.docker.DockerConfig;
import ru.vyarus.gradle.plugin.python.cmd.docker.DockerFactory;
import ru.vyarus.gradle.plugin.python.util.CliUtils;
import ru.vyarus.gradle.plugin.python.util.DurationFormatter;
import ru.vyarus.gradle.plugin.python.util.PythonExecutionFailed;

public final class PythonBinary
implements GroovyObject {
    private static final String PROP_PYTHON3 = "ru.vyarus.python3.detected";
    private static final String PYTHON3 = "python3";
    private static final String SPACE;
    private static final String NL;
    private static final Object SYNC;
    private final Project project;
    private final String sourcePythonPath;
    private final String sourcePythonBinary;
    private boolean validateBinary;
    private ContainerManager docker;
    private DockerConfig dockerConfig;
    private String workDir;
    private final Map<String, Object> envVars;
    private boolean initialized;
    private String executable;
    private boolean withCmd;
    private boolean customBinaryPath;
    private final List<LoggedCommandCleaner> logCleaners;
    private static final Closure memoizedMethodClosure$getPythonBinaryStringStringbooleanboolean;
    private static final Closure memoizedMethodClosure$findSystemBinaryString;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public PythonBinary(Project project, String pythonPath, String binary) {
        String string;
        String string2;
        Project project2;
        MetaClass metaClass;
        List list;
        Map map;
        boolean bl;
        this.validateBinary = bl = true;
        this.envVars = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.logCleaners = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.project = project2 = project;
        this.sourcePythonPath = string2 = pythonPath;
        this.sourcePythonBinary = string = binary;
    }

    public void validateSystemBinary(boolean validateBinary) {
        boolean bl;
        this.beforeInit("System binary check must be set before initialization");
        this.validateBinary = bl = validateBinary;
    }

    public void withDocker(DockerConfig docker) {
        this.beforeInit("Docker config must be set before initialization");
        if (DefaultTypeTransformation.booleanUnbox((Object)docker)) {
            ContainerManager containerManager;
            DockerConfig dockerConfig;
            this.dockerConfig = dockerConfig = docker;
            this.docker = containerManager = DockerFactory.getContainer(docker, this.project);
        }
    }

    public void addLogCleaner(LoggedCommandCleaner cleaner) {
        this.logCleaners.add(cleaner);
    }

    public void workDir(String workDir) {
        String string;
        this.workDir = string = workDir;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public Map<String, Object> getEnvVars() {
        return this.envVars;
    }

    public String getExecutable() {
        this.init();
        return this.executable;
    }

    public String targetOsCanonicalPath(String path) {
        return DefaultTypeTransformation.booleanUnbox((Object)this.docker) ? this.docker.canonicalPath(path) : path;
    }

    public String getBinaryDir(Closure<String> sysExecutableProvider, Closure<String> sysPrefixProvider) {
        this.init();
        String path = this.customBinaryPath ? this.project.file((Object)this.executable).getAbsolutePath() : ShortTypeHandling.castToString((Object)sysExecutableProvider.call());
        int idx = path.lastIndexOf(File.separator);
        String res = null;
        if (path.isEmpty() || idx <= 0) {
            String string;
            Object object = sysPrefixProvider.call();
            path = ShortTypeHandling.castToString((Object)object);
            res = string = CliUtils.pythonBinPath(path, this.isWindows());
        } else {
            String string;
            res = string = StringGroovyMethods.getAt((String)path, (IntRange)new IntRange(true, 0, idx - 1));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.docker)) {
            String string;
            res = string = this.docker.toDockerPath(res);
        }
        return res;
    }

    public boolean isWindows() {
        return DefaultTypeTransformation.booleanUnbox((Object)this.docker) ? this.docker.isWindows() : Os.isFamily((String)Os.FAMILY_WINDOWS);
    }

    public boolean isDocker() {
        return this.docker != null;
    }

    public boolean exists(String path) {
        this.init();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.docker)) {
            String localPath = this.docker.toLocalPath(path);
            if (localPath != null) {
                return new File(localPath).exists();
            }
            String res = this.rawExec(ShortTypeHandling.castToString((Object)(this.isWindows() ? new GStringImpl(new Object[]{path}, new String[]{"IF EXIST \"", "\" ECHO exists"}) : new GStringImpl(new Object[]{path}, new String[]{"test -f ", " && echo \"exists\""}))));
            return ScriptBytecodeAdapter.compareEqual((Object)res, (Object)"exists");
        }
        return new File(path).exists();
    }

    public void exec(Object args, List<String> pythonArgs, List<String> extraArgs, OutputStream outputConsumer, LogLevel logLevel) {
        this.init();
        String exec = this.getCommandBinary(this.workDir);
        String[] cmdArgs = this.getCommandArguments(this.workDir, args, pythonArgs, extraArgs);
        this.project.getLogger().info("Python arguments: {}", (Object[])ScriptBytecodeAdapter.castToType((Object)cmdArgs, Object[].class));
        String[] cmd = new String[]{exec};
        Object[] objectArray = DefaultGroovyMethods.plus((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)cmd, Object[].class)), (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)cmdArgs, Object[].class)));
        cmd = (String[])ScriptBytecodeAdapter.castToType((Object)objectArray, String[].class);
        if (DefaultTypeTransformation.booleanUnbox((Object)this.docker)) {
            this.docker.convertCommand(cmd);
            this.prepareEnvironment();
        }
        String commandLine = DefaultGroovyMethods.join((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)cmd, Object[].class)), (String)SPACE);
        String formattedCommand = this.cleanLoggedCommand(commandLine.replace("\r", "").replace(NL, SPACE));
        this.project.getLogger().log(logLevel, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{formattedCommand}, new String[]{"[python] ", ""})));
        long start = System.currentTimeMillis();
        int res = this.rawExec(cmd, outputConsumer);
        this.project.getLogger().info("Python execution time: {}", (Object)DurationFormatter.format(System.currentTimeMillis() - start));
        if (res != 0) {
            String out = this.reformatOutputForException(outputConsumer);
            throw (Throwable)((Object)new PythonExecutionFailed(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{formattedCommand}, new String[]{"Python call failed: ", ""}).plus(DefaultTypeTransformation.booleanUnbox((Object)out) ? StringGroovyMethods.plus((String)"\n\n\tOUTPUT:\n", (CharSequence)out) : ""))));
        }
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        PythonBinary pythonBinary = this;
        synchronized (pythonBinary) {
            if (!this.initialized) {
                boolean bl;
                boolean bl2;
                boolean bl3;
                String string;
                this.executable = string = this.findPython(this.project, this.sourcePythonPath, this.sourcePythonBinary, this.validateBinary);
                this.withCmd = bl3 = DefaultTypeTransformation.booleanUnbox((Object)this.sourcePythonPath) && this.isWindows();
                this.customBinaryPath = bl2 = DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.asType((Object)this.sourcePythonPath, Boolean.TYPE));
                this.initialized = bl = true;
            }
        }
    }

    private static String getPythonBinary(String pythonPath, String binary, boolean python3Available, boolean windows) {
        return ShortTypeHandling.castToString((Object)memoizedMethodClosure$getPythonBinaryStringStringbooleanboolean.call(new Object[]{pythonPath, binary, python3Available, windows}));
    }

    private static File findSystemBinary(String binary) {
        return (File)ScriptBytecodeAdapter.castToType((Object)memoizedMethodClosure$findSystemBinaryString.call((Object)binary), File.class);
    }

    private String[] prepareArgs(Object args, List<String> pythonArgs, List<String> extraArgs) {
        String[] cmd = CliUtils.parseArgs(args);
        this.detectAndWrapCommand(cmd);
        if (DefaultTypeTransformation.booleanUnbox(pythonArgs)) {
            String[] stringArray = CliUtils.mergeArgs(pythonArgs, cmd);
            cmd = stringArray;
        }
        if (DefaultTypeTransformation.booleanUnbox(extraArgs)) {
            String[] stringArray = CliUtils.mergeArgs(cmd, extraArgs);
            cmd = stringArray;
        }
        return cmd;
    }

    private void detectAndWrapCommand(String ... cmd) {
        Reference cmd2 = new Reference((Object)cmd);
        Reference moduleCall = new Reference((Object)false);
        public final class _detectAndWrapCommand_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference moduleCall;
            private /* synthetic */ Reference cmd;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _detectAndWrapCommand_closure1(Object _outerInstance, Object _thisObject, Reference moduleCall, Reference cmd) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.moduleCall = reference2 = moduleCall;
                this.cmd = reference = cmd;
            }

            public Object doCall(String arg, int i) {
                if (ScriptBytecodeAdapter.compareEqual((Object)arg, (Object)"-m")) {
                    boolean bl = true;
                    this.moduleCall.set((Object)bl);
                }
                if (!DefaultTypeTransformation.booleanUnbox((Object)this.moduleCall.get()) && ScriptBytecodeAdapter.compareEqual((Object)arg, (Object)"-c") && DefaultTypeTransformation.intUnbox((Object)NumberNumberPlus.plus((Number)i, (Number)2)) == ((String[])ScriptBytecodeAdapter.castToType((Object)this.cmd.get(), String[].class)).length) {
                    String string = CliUtils.wrapCommand(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])((String[])ScriptBytecodeAdapter.castToType((Object)this.cmd.get(), String[].class)), (int)DefaultTypeTransformation.intUnbox((Object)NumberNumberPlus.plus((Number)i, (Number)1)))), ((PythonBinary)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PythonBinary.class)).isWindows());
                    BytecodeInterface8.objectArraySet((Object[])((String[])ScriptBytecodeAdapter.castToType((Object)this.cmd.get(), String[].class)), (int)DefaultTypeTransformation.intUnbox((Object)NumberNumberPlus.plus((Number)i, (Number)1)), (Object)string);
                    return string;
                }
                return null;
            }

            public Object call(String arg, int i) {
                return this.doCall(arg, i);
            }

            @Generated
            public Boolean getModuleCall() {
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.moduleCall.get(), Boolean.class);
            }

            @Generated
            public String[] getCmd() {
                return (String[])ScriptBytecodeAdapter.castToType((Object)this.cmd.get(), String[].class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _detectAndWrapCommand_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.eachWithIndex((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)((String[])cmd2.get()), Object[].class)), (Closure)new _detectAndWrapCommand_closure1(this, this, moduleCall, cmd2));
    }

    private String findPython(Project project, String pythonPath, String binary, boolean validateBinary) {
        String normalizedPath = ShortTypeHandling.castToString(pythonPath == null ? null : Paths.get(pythonPath, new String[0]).normalize().toString());
        boolean python3found = DefaultTypeTransformation.booleanUnbox((Object)binary) || DefaultTypeTransformation.booleanUnbox((Object)pythonPath) ? false : this.detectPython3Binary(project);
        String executable = PythonBinary.getPythonBinary(normalizedPath, binary, python3found, this.isWindows());
        if (validateBinary && !DefaultTypeTransformation.booleanUnbox((Object)pythonPath) && !DefaultTypeTransformation.booleanUnbox((Object)this.docker)) {
            project.getLogger().info("Found python binary: {}", (Object)PythonBinary.findSystemBinary(executable).getAbsolutePath());
        }
        return executable;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean detectPython3Binary(Project project) {
        CallSite[] callSiteArray = PythonBinary.$getCallSiteArray();
        Object object = SYNC;
        synchronized (object) {
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty((Object)project), (Object)PROP_PYTHON3), null)) return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].call(callSiteArray[24].callGetProperty((Object)project), (Object)PROP_PYTHON3));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGroovyObjectGetProperty((Object)this))) {
                    callSiteArray[3].call(callSiteArray[4].callGetProperty(callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty((Object)project))), (Object)PROP_PYTHON3, (Object)false);
                    return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].call(callSiteArray[24].callGetProperty((Object)project), (Object)PROP_PYTHON3));
                } else {
                    callSiteArray[7].call(callSiteArray[8].callGetProperty(callSiteArray[9].callGetProperty(callSiteArray[10].callGetProperty((Object)project))), (Object)PROP_PYTHON3, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[11].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{PYTHON3, "--version"}), String[].class)), String[].class)), null));
                }
                return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].call(callSiteArray[24].callGetProperty((Object)project), (Object)PROP_PYTHON3));
            }
            if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[12].call(callSiteArray[13].callGetProperty((Object)project), (Object)PROP_PYTHON3), null)) return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].call(callSiteArray[24].callGetProperty((Object)project), (Object)PROP_PYTHON3));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].callGroovyObjectGetProperty((Object)this))) {
                callSiteArray[15].call(callSiteArray[16].callGetProperty(callSiteArray[17].callGetProperty(callSiteArray[18].callGetProperty((Object)project))), (Object)PROP_PYTHON3, (Object)false);
                return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].call(callSiteArray[24].callGetProperty((Object)project), (Object)PROP_PYTHON3));
            } else {
                callSiteArray[19].call(callSiteArray[20].callGetProperty(callSiteArray[21].callGetProperty(callSiteArray[22].callGetProperty((Object)project))), (Object)PROP_PYTHON3, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)this.rawExec((String[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{PYTHON3, "--version"}), String[].class)), null));
            }
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].call(callSiteArray[24].callGetProperty((Object)project), (Object)PROP_PYTHON3));
        }
    }

    private String cleanLoggedCommand(String cmd) {
        Reference cmd2 = new Reference((Object)cmd);
        Reference res = new Reference((Object)((String)cmd2.get()));
        public final class _cleanLoggedCommand_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference res;
            private /* synthetic */ Reference cmd;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _cleanLoggedCommand_closure2(Object _outerInstance, Object _thisObject, Reference res, Reference cmd) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.res = reference2 = res;
                this.cmd = reference = cmd;
            }

            public Object doCall(Object it) {
                String string = ((LoggedCommandCleaner)it).clear(ShortTypeHandling.castToString((Object)this.cmd.get()));
                this.res.set((Object)string);
                return string;
            }

            @Generated
            public String getRes() {
                return ShortTypeHandling.castToString((Object)this.res.get());
            }

            @Generated
            public String getCmd() {
                return ShortTypeHandling.castToString((Object)this.cmd.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cleanLoggedCommand_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.logCleaners, (Closure)new _cleanLoggedCommand_closure2(this, this, res, cmd2));
        return (String)res.get();
    }

    private String reformatOutputForException(OutputStream os) {
        os.flush();
        String out = ShortTypeHandling.castToString((Object)os);
        public final class _reformatOutputForException_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _reformatOutputForException_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return StringGroovyMethods.plus((String)"\t\t", (CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)it, CharSequence.class)));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _reformatOutputForException_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)out) ? StringGroovyMethods.plus((String)DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)out.split(NL), Object[].class)), (Closure)new _reformatOutputForException_closure3(this, this)), (String)NL), (CharSequence)NL) : "";
    }

    private void prepareEnvironment() {
        if (this.dockerConfig.getExclusive()) {
            this.project.getLogger().lifecycle("[docker] executing command in exclusive container '{}' \n{}", new Object[]{this.dockerConfig.getImage(), this.docker.formatContainerInfo(this.dockerConfig, this.workDir, this.envVars)});
        } else {
            this.docker.restartIfRequired(this.dockerConfig, this.workDir, this.envVars);
        }
    }

    private String rawExec(String ... command) {
        Reference command2 = new Reference((Object)command);
        public final class _rawExec_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference command;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _rawExec_closure4(Object _outerInstance, Object _thisObject, Reference command) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.command = reference = command;
            }

            public Object doCall(Object os) {
                return ((PythonBinary)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PythonBinary.class)).rawExec((String[])ScriptBytecodeAdapter.castToType((Object)this.command.get(), String[].class), (OutputStream)ScriptBytecodeAdapter.castToType((Object)os, OutputStream.class)) == 0 ? ((ByteArrayOutputStream)os).toString() : null;
            }

            @Generated
            public String[] getCommand() {
                return (String[])ScriptBytecodeAdapter.castToType((Object)this.command.get(), String[].class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _rawExec_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return ShortTypeHandling.castToString((Object)IOGroovyMethods.withStream((OutputStream)new ByteArrayOutputStream(), (Closure)new _rawExec_closure4(this, this, command2)));
    }

    /*
     * WARNING - void declaration
     */
    private int rawExec(String[] command, OutputStream out) {
        void var2_2;
        Reference command2 = new Reference((Object)command);
        Reference out2 = new Reference((Object)var2_2);
        if (DefaultTypeTransformation.booleanUnbox((Object)this.docker)) {
            if (!this.docker.isStarted()) {
                this.docker.restartIfRequired(this.dockerConfig, this.workDir, this.envVars);
            }
            return this.dockerConfig.getExclusive() ? this.docker.execExclusive((String[])command2.get(), (OutputStream)out2.get(), this.dockerConfig, this.workDir, this.envVars) : this.docker.exec((String[])command2.get(), (OutputStream)out2.get());
        }
        ExecResult res = this.project.exec((Action)new Action<ExecSpec>(this, command2, out2){
            public /* synthetic */ Reference out;
            public /* synthetic */ Reference command;
            public /* synthetic */ PythonBinary this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                Reference reference2;
                PythonBinary pythonBinary;
                this.this$0 = pythonBinary = p0;
                this.out = reference2 = p2;
                this.command = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public void execute(ExecSpec spec) {
                spec.commandLine((Object[])ScriptBytecodeAdapter.castToType((Object)this.command.get(), Object[].class));
                Object object = this.out.get();
                spec.setStandardOutput((OutputStream)ScriptBytecodeAdapter.castToType((Object)object, OutputStream.class));
                Object object2 = this.out.get();
                spec.setErrorOutput((OutputStream)ScriptBytecodeAdapter.castToType((Object)object2, OutputStream.class));
                boolean bl = true;
                spec.setIgnoreExitValue(bl);
                if (DefaultTypeTransformation.booleanUnbox((Object)this.this$0.getWorkDir())) {
                    spec.setWorkingDir((Object)this.this$0.getWorkDir());
                }
                if (DefaultTypeTransformation.booleanUnbox(this.this$0.getEnvVars())) {
                    spec.environment(this.this$0.getEnvVars());
                }
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, PythonBinary.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$1(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, PythonBinary.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, PythonBinary.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        });
        return res.getExitValue();
    }

    private String getCommandBinary(String workDir) {
        this.init();
        boolean wrkDirUsed = DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.asType((Object)workDir, Boolean.TYPE));
        return this.withCmd ? "cmd" : (wrkDirUsed && this.customBinaryPath ? CliUtils.canonicalPath(this.project.file((Object)this.executable)) : this.executable);
    }

    private String[] getCommandArguments(String workDir, Object args, List<String> pythonArgs, List<String> extraArgs) {
        this.init();
        boolean wrkDirUsed = DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.asType((Object)workDir, Boolean.TYPE));
        return this.withCmd ? CliUtils.wincmdArgs(this.executable, this.project.getProjectDir(), this.prepareArgs(args, pythonArgs, extraArgs), wrkDirUsed) : this.prepareArgs(args, pythonArgs, extraArgs);
    }

    private void beforeInit(String message) {
        if (this.initialized) {
            throw (Throwable)new IllegalStateException(message);
        }
    }

    @Generated
    private static String memoizedMethodPriv$getPythonBinaryStringStringbooleanboolean(String pythonPath, String binary, boolean python3Available, boolean windows) {
        String string = binary;
        String res = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "python";
        if (DefaultTypeTransformation.booleanUnbox((Object)pythonPath)) {
            String path = StringGroovyMethods.plus((String)pythonPath, (CharSequence)(pythonPath.endsWith(File.separator) ? "" : File.separator));
            GStringImpl gStringImpl = windows ? new GStringImpl(new Object[]{path, res}, new String[]{"", "", ".exe"}) : new GStringImpl(new Object[]{path, res}, new String[]{"", "", ""});
            res = ShortTypeHandling.castToString((Object)gStringImpl);
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)binary) && python3Available) {
            String string2;
            res = string2 = PYTHON3;
        }
        return res;
    }

    @Generated
    private static File memoizedMethodPriv$findSystemBinaryString(String binary) {
        return CliUtils.searchSystemBinary(binary);
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(PythonBinary.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, PythonBinary.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(PythonBinary.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ String pfaccess$0(PythonBinary $that) {
        return $that.getWorkDir();
    }

    public static /* synthetic */ Map<String, Object> pfaccess$1(PythonBinary $that) {
        return $that.getEnvVars();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PythonBinary.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Closure closure;
        Closure closure2;
        Object object;
        String string;
        String string2;
        NL = string2 = "\n";
        SPACE = string = " ";
        SYNC = object = new Object();
        public final class __clinit__closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String pythonPath, String binary, boolean python3Available, boolean windows) {
                return PythonBinary.memoizedMethodPriv$getPythonBinaryStringStringbooleanboolean(pythonPath, binary, python3Available, windows);
            }

            public Object call(String pythonPath, String binary, boolean python3Available, boolean windows) {
                return this.doCall(pythonPath, binary, python3Available, windows);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        memoizedMethodClosure$getPythonBinaryStringStringbooleanboolean = closure2 = new __clinit__closure5(PythonBinary.class, PythonBinary.class).memoize();
        public final class __clinit__closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String binary) {
                return PythonBinary.memoizedMethodPriv$findSystemBinaryString(binary);
            }

            public Object call(String binary) {
                return this.doCall(binary);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        memoizedMethodClosure$findSystemBinaryString = closure = new __clinit__closure6(PythonBinary.class, PythonBinary.class).memoize();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "findProperty";
        stringArray[1] = "rootProject";
        stringArray[2] = "windows";
        stringArray[3] = "set";
        stringArray[4] = "extraProperties";
        stringArray[5] = "extensions";
        stringArray[6] = "rootProject";
        stringArray[7] = "set";
        stringArray[8] = "extraProperties";
        stringArray[9] = "extensions";
        stringArray[10] = "rootProject";
        stringArray[11] = "rawExec";
        stringArray[12] = "findProperty";
        stringArray[13] = "rootProject";
        stringArray[14] = "windows";
        stringArray[15] = "set";
        stringArray[16] = "extraProperties";
        stringArray[17] = "extensions";
        stringArray[18] = "rootProject";
        stringArray[19] = "set";
        stringArray[20] = "extraProperties";
        stringArray[21] = "extensions";
        stringArray[22] = "rootProject";
        stringArray[23] = "findProperty";
        stringArray[24] = "rootProject";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[25];
        PythonBinary.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(PythonBinary.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = PythonBinary.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

