/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.python.task;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.util.ClosureBackedAction;
import ru.vyarus.gradle.plugin.python.cmd.Python;
import ru.vyarus.gradle.plugin.python.cmd.docker.ContainerManager;
import ru.vyarus.gradle.plugin.python.cmd.docker.DockerConfig;
import ru.vyarus.gradle.plugin.python.cmd.docker.DockerFactory;
import ru.vyarus.gradle.plugin.python.util.CliUtils;
import ru.vyarus.gradle.plugin.python.util.OutputLogger;

public class BasePythonTask
extends ConventionTask
implements GroovyObject {
    @Input
    @Optional
    private String pythonPath;
    @Input
    @Optional
    private String pythonBinary;
    @Input
    private boolean validateSystemBinary;
    @Input
    @Optional
    private List<String> pythonArgs;
    @Input
    @Optional
    private Map<String, Object> environment;
    @Input
    @Optional
    private String workDir;
    @Input
    @Optional
    private LogLevel logLevel;
    @Nested
    private DockerEnv docker;
    private final Closure memoizedMethodClosure$buildPythonStringString;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    protected BasePythonTask() {
        MetaClass metaClass;
        Closure closure;
        LogLevel logLevel;
        List list;
        this.pythonArgs = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.logLevel = logLevel = LogLevel.LIFECYCLE;
        Object object = this.getProject().getObjects().newInstance(DockerEnv.class, new Object[0]);
        this.docker = (DockerEnv)ScriptBytecodeAdapter.castToType((Object)object, DockerEnv.class);
        this.memoizedMethodClosure$buildPythonStringString = closure = new _closure1((Object)this, (Object)this).memoize();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        String string = "python";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, BasePythonTask.class, (GroovyObject)this, (String)"group");
    }

    public void pythonArgs(String ... args) {
        if (DefaultTypeTransformation.booleanUnbox((Object)args)) {
            DefaultGroovyMethods.addAll(this.getPythonArgs(), (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)));
        }
    }

    public void environment(String name, Object value) {
        this.environment(ScriptBytecodeAdapter.createMap((Object[])new Object[]{name, value}));
    }

    public void environment(Map<String, Object> vars) {
        if (DefaultTypeTransformation.booleanUnbox(vars)) {
            Map map = this.getEnvironment();
            Map envs = DefaultTypeTransformation.booleanUnbox(map) ? map : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            envs.putAll(vars);
            this.setEnvironment(envs);
        }
    }

    public DockerEnv docker(@DelegatesTo(strategy=1, value=DockerEnv.class) Closure closure) {
        return this.docker((Action<? super DockerEnv>)new ClosureBackedAction(closure));
    }

    public DockerEnv docker(Action<? super DockerEnv> action) {
        action.execute((Object)this.docker);
        return this.docker;
    }

    @org.gradle.api.tasks.Internal
    public boolean isWindows() {
        return this.getPython().isWindows();
    }

    @org.gradle.api.tasks.Internal
    public boolean isDockerUsed() {
        return DefaultTypeTransformation.booleanUnbox((Object)this.docker.getUse().get());
    }

    public void dockerChown(Object dir) {
        this.dockerChown(this.getProject().file(dir).toPath());
    }

    public int dockerExec(Object cmd) {
        Reference cmd2 = new Reference(cmd);
        if (!this.isDockerUsed()) {
            return -1;
        }
        public final class _dockerExec_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference cmd;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _dockerExec_closure2(Object _outerInstance, Object _thisObject, Reference cmd) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.cmd = reference = cmd;
            }

            public Object doCall(Object it) {
                return InvokerHelper.invokeMethodSafe((Object)((Object)((BasePythonTask)((Object)this.getThisObject()))), (String)"dockerExec", (Object)new Object[]{this.cmd.get(), it});
            }

            @Generated
            public Object getCmd() {
                return this.cmd.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _dockerExec_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultTypeTransformation.intUnbox((Object)IOGroovyMethods.withStream((OutputStream)((Object)new OutputLogger(this.getLogger(), LogLevel.LIFECYCLE, "\t")), (Closure)new _dockerExec_closure2((Object)this, (Object)this, cmd2)));
    }

    @org.gradle.api.tasks.Internal
    protected Python getPython() {
        return this.buildPython(this.getPythonPath(), this.getPythonBinary());
    }

    protected void dockerChown(Path dir) {
        if (!this.isDockerUsed() || this.isWindows() || !CliUtils.isLinuxHost() || !Files.exists(dir, new LinkOption[0])) {
            return;
        }
        Path projectDir = this.getProject().getRootProject().getRootDir().toPath();
        int uid = DefaultTypeTransformation.intUnbox((Object)Files.getAttribute(projectDir, "unix:uid", LinkOption.NOFOLLOW_LINKS));
        int gid = DefaultTypeTransformation.intUnbox((Object)Files.getAttribute(projectDir, "unix:gid", LinkOption.NOFOLLOW_LINKS));
        this.dockerExec(ScriptBytecodeAdapter.createList((Object[])new Object[]{"chown", "-Rh", new GStringImpl(new Object[]{uid, gid}, new String[]{"", ":", ""}), dir.toAbsolutePath()}));
    }

    protected int dockerExec(Object cmd, OutputStream out) {
        if (!this.isDockerUsed()) {
            throw (Throwable)new GradleException("Docker command can't be executed: docker not enabled");
        }
        String[] args = CliUtils.parseArgs(cmd);
        ContainerManager manager = DockerFactory.getContainer(this.getDocker().toConfig(), this.getProject());
        manager.restartIfRequired(this.getDocker().toConfig(), this.getWorkDir(), this.getEnvironment());
        manager.convertCommand(args);
        this.getLogger().lifecycle("[docker] {}", new Object[]{DefaultGroovyMethods.join((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (String)" ")});
        return manager.exec(args, out);
    }

    private Python buildPython(String pythonPath, String pythonBinary) {
        return (Python)ScriptBytecodeAdapter.castToType((Object)this.memoizedMethodClosure$buildPythonStringString.call(new Object[]{pythonPath, pythonBinary}), Python.class);
    }

    @Generated
    protected Python memoizedMethodPriv$buildPythonStringString(String pythonPath, String pythonBinary) {
        return new Python(this.getProject(), pythonPath, pythonBinary).logLevel(this.getLogLevel()).workDir(this.getWorkDir()).pythonArgs(this.getPythonArgs()).environment(this.getEnvironment()).validateSystemBinary(this.getValidateSystemBinary()).withDocker(this.getDocker().toConfig()).validate();
    }

    public /* synthetic */ Object this$dist$invoke$4(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(BasePythonTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$4(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, BasePythonTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$4(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(BasePythonTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != BasePythonTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    public String getPythonPath() {
        return this.pythonPath;
    }

    @Generated
    public void setPythonPath(String string) {
        this.pythonPath = string;
    }

    @Generated
    public String getPythonBinary() {
        return this.pythonBinary;
    }

    @Generated
    public void setPythonBinary(String string) {
        this.pythonBinary = string;
    }

    @Generated
    public boolean getValidateSystemBinary() {
        return this.validateSystemBinary;
    }

    @Generated
    public boolean isValidateSystemBinary() {
        return this.validateSystemBinary;
    }

    @Generated
    public void setValidateSystemBinary(boolean bl) {
        this.validateSystemBinary = bl;
    }

    @Generated
    public List<String> getPythonArgs() {
        return this.pythonArgs;
    }

    @Generated
    public void setPythonArgs(List<String> list) {
        this.pythonArgs = list;
    }

    @Generated
    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    @Generated
    public void setEnvironment(Map<String, Object> map) {
        this.environment = map;
    }

    @Generated
    public String getWorkDir() {
        return this.workDir;
    }

    @Generated
    public void setWorkDir(String string) {
        this.workDir = string;
    }

    @Generated
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Generated
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Generated
    public DockerEnv getDocker() {
        return this.docker;
    }

    @Generated
    public void setDocker(DockerEnv dockerEnv) {
        this.docker = dockerEnv;
    }

    public static abstract class DockerEnv
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public DockerEnv() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Input
        public abstract Property<Boolean> getUse();

        @Input
        public abstract Property<String> getImage();

        @org.gradle.api.tasks.Internal
        public abstract Property<Boolean> getWindows();

        @Input
        public abstract Property<Boolean> getExclusive();

        @Input
        public abstract SetProperty<String> getPorts();

        public void ports(Object ... ports) {
            public final class _ports_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _ports_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    ((DockerEnv)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DockerEnv.class)).getPorts().add((Object)String.valueOf(it));
                    return null;
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _ports_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((Object[])ports, (Closure)new _ports_closure1(this, this));
        }

        public DockerConfig toConfig() {
            DockerConfig dockerConfig;
            Object object = this.getUse().get();
            if (object == null ? false : (Boolean)object) {
                DockerConfig dockerConfig2 = new DockerConfig();
                Object object2 = this.getImage().get();
                dockerConfig2.setImage(ShortTypeHandling.castToString((Object)object2));
                Object object3 = this.getWindows().get();
                dockerConfig2.setWindows(DefaultTypeTransformation.booleanUnbox((Object)object3));
                Object object4 = this.getExclusive().get();
                dockerConfig2.setExclusive(DefaultTypeTransformation.booleanUnbox((Object)object4));
                Set set = (Set)this.getPorts().get();
                dockerConfig2.setPorts(set);
                dockerConfig = dockerConfig2;
            } else {
                dockerConfig = null;
            }
            return (DockerConfig)ScriptBytecodeAdapter.castToType(dockerConfig, DockerConfig.class);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DockerEnv.class, BasePythonTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DockerEnv.class, BasePythonTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, BasePythonTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, BasePythonTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DockerEnv.class, BasePythonTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DockerEnv.class, BasePythonTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != DockerEnv.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(String pythonPath, String pythonBinary) {
            return InvokerHelper.invokeMethodSafe((Object)((Object)((BasePythonTask)((Object)this.getThisObject()))), (String)"memoizedMethodPriv$buildPythonStringString", (Object)new Object[]{pythonPath, pythonBinary});
        }

        public Object call(String pythonPath, String pythonBinary) {
            return this.doCall(pythonPath, pythonBinary);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

