/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.python.task;

import groovy.lang.GString;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.internal.ExecException;
import ru.vyarus.gradle.plugin.python.PythonExtension;
import ru.vyarus.gradle.plugin.python.cmd.Pip;
import ru.vyarus.gradle.plugin.python.cmd.Python;
import ru.vyarus.gradle.plugin.python.cmd.Virtualenv;
import ru.vyarus.gradle.plugin.python.task.pip.BasePipTask;
import ru.vyarus.gradle.plugin.python.util.CliUtils;
import ru.vyarus.gradle.plugin.python.util.PythonExecutionFailed;

public class CheckPythonTask
extends BasePipTask {
    private static final String PROP_VENV_INSTALLED = "ru.vyarus.python.virtualenv.installed";
    private static final Object SYNC;
    private boolean virtual;
    private boolean envCreated;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    @Generated
    public CheckPythonTask() {
        boolean bl;
        boolean bl2;
        this.virtual = bl2 = false;
        this.envCreated = bl = false;
    }

    @TaskAction
    public void run() {
        PythonExtension ext = (PythonExtension)ScriptBytecodeAdapter.castToType((Object)this.getProject().getExtensions().findByType(PythonExtension.class), PythonExtension.class);
        boolean envRequested = ScriptBytecodeAdapter.compareGreaterThanEqual((Object)((Object)ext.getScope()), (Object)((Object)PythonExtension.Scope.VIRTUALENV_OR_USER));
        Virtualenv env = (Virtualenv)ScriptBytecodeAdapter.castToType(envRequested ? new Virtualenv(this.getProject(), this.getPythonPath(), this.getPythonBinary(), ext.getEnvPath()).validateSystemBinary(this.getValidateSystemBinary()).withDocker(this.getDocker().toConfig()).workDir(this.getWorkDir()).environment(this.getEnvironment()).validate() : null, Virtualenv.class);
        Object object = SYNC;
        synchronized (object) {
            if (envRequested && env.exists()) {
                boolean bl;
                this.virtual = bl = true;
            } else {
                this.checkPython(ext);
                if (this.isModulesInstallationRequired()) {
                    this.checkPip(ext);
                    if (envRequested) {
                        boolean bl;
                        this.virtual = bl = this.checkEnv(env, ext);
                    }
                }
            }
        }
        if (this.virtual) {
            this.switchEnvironment(env, ext);
        }
        if (!this.getPython().getCanonicalBinaryDir().startsWith(this.getPython().getCanonicalHomeDir())) {
            this.getLogger().error(StringGroovyMethods.plus((String)"WARNING: Python binary path '{}' does not match home path reported by python (sys.prefix): ", (CharSequence)"'{}'. Everything could still work as expected if code doesn't rely on python location."), (Object)this.getPython().getCanonicalBinaryDir(), (Object)this.getPython().getCanonicalHomeDir());
        }
    }

    private void checkPython(PythonExtension ext) {
        Python python = new Python(this.getProject(), this.getPythonPath(), this.getPythonBinary()).workDir(this.getWorkDir()).environment(this.getEnvironment()).validateSystemBinary(this.isValidateSystemBinary()).withDocker(this.getDocker().toConfig()).validate();
        try {
            python.getVersion();
        }
        catch (ExecException ex) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{python.getCanonicalUsedBinary()}, new String[]{"Python not found: ", ". "}).plus(this.virtual ? StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"This must be a bug of virtualenv support, please report it ", (CharSequence)"(https://github.com/xvik/gradle-use-python-plugin/issues). You can disable "), (CharSequence)"virtualenv usage with 'python.scope = USER'.") : StringGroovyMethods.plus((String)"Please install it (http://docs.python-guide.org/en/latest/starting/installation/) ", (CharSequence)"or configure correct location with 'python.pythonPath'."))), (Throwable)ex);
        }
        this.checkPythonVersion(python, ext);
    }

    private void checkPythonVersion(Python python, PythonExtension ext) {
        String version = python.getVersion();
        String minVersion = ext.getMinPythonVersion();
        if (!CliUtils.isVersionMatch(version, minVersion)) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{python.getHomeDir(), version}, new String[]{"Python (", ") verion ", " does not match minimal "}).plus((GString)new GStringImpl(new Object[]{minVersion}, new String[]{"required version: ", ""}))));
        }
        this.getLogger().lifecycle("Using python {} from {} ({})", new Object[]{python.getVersion(), python.getCanonicalHomeDir(), python.getCanonicalUsedBinary()});
    }

    private void checkPip(PythonExtension ext) {
        Pip pip = new Pip(this.getProject(), this.getPythonPath(), this.getPythonBinary()).userScope(false).workDir(this.getWorkDir()).environment(this.getEnvironment()).validateSystemBinary(this.isValidateSystemBinary()).withDocker(this.getDocker().toConfig()).validate();
        try {
            pip.getVersionLine();
        }
        catch (PythonExecutionFailed ex) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.virtual ? new GStringImpl(new Object[]{ext.getEnvPath()}, new String[]{" on virtualenv ", ""}) : ""}, new String[]{"Pip is not installed", ". "}).plus("Please install it (https://pip.pypa.io/en/stable/installing/).")), (Throwable)((Object)ex));
        }
        this.checkPipVersion(pip, ext);
    }

    private void checkPipVersion(Pip pip, PythonExtension ext) {
        String version = pip.getVersion();
        String minVersion = ext.getMinPipVersion();
        if (!CliUtils.isVersionMatch(version, minVersion)) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{version}, new String[]{"Pip verion ", " does not match minimal "}).plus((GString)new GStringImpl(new Object[]{minVersion}, new String[]{"required version: ", ". Use 'pip install -U pip' to upgrade pip."}))));
        }
        this.getLogger().lifecycle("Using {}", new Object[]{pip.getVersionLine()});
    }

    private boolean checkEnv(Virtualenv env, PythonExtension ext) {
        boolean bl;
        Pip pip = new Pip(this.getProject(), this.getPythonPath(), this.getPythonBinary()).userScope(true).workDir(this.getWorkDir()).environment(this.getEnvironment()).validateSystemBinary(this.isValidateSystemBinary()).withDocker(this.getDocker().toConfig()).validate();
        Boolean venvInstalled = (Boolean)ScriptBytecodeAdapter.castToType((Object)this.getProject().getRootProject().findProperty(PROP_VENV_INSTALLED), Boolean.class);
        if (venvInstalled == null) {
            boolean bl2 = pip.isInstalled(env.getName());
            venvInstalled = bl2;
            this.getProject().getRootProject().getExtensions().getExtraProperties().set(PROP_VENV_INSTALLED, (Object)venvInstalled);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)venvInstalled)) {
            if (ext.getInstallVirtualenv()) {
                pip.install(StringGroovyMethods.plus((String)env.getName(), (CharSequence)(DefaultTypeTransformation.booleanUnbox((Object)ext.getVirtualenvVersion()) ? new GStringImpl(new Object[]{ext.getVirtualenvVersion()}, new String[]{"==", ""}) : "")));
                this.getProject().getRootProject().getExtensions().getExtraProperties().set(PROP_VENV_INSTALLED, (Object)true);
            } else {
                if (ScriptBytecodeAdapter.compareEqual((Object)((Object)ext.getScope()), (Object)((Object)PythonExtension.Scope.VIRTUALENV))) {
                    throw (Throwable)new GradleException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Virtualenv is not installed. Please install it ", (CharSequence)"(https://virtualenv.pypa.io/en/stable/installation/) or change target pip "), (CharSequence)new GStringImpl(new Object[]{PythonExtension.Scope.VIRTUALENV}, new String[]{"scope 'python.scope' from ", ""})));
                }
                return false;
            }
        }
        if (pip.getPython().isVirtualenv()) {
            this.getLogger().error(StringGroovyMethods.plus((String)"WARNING: Global python is already a virtualenv: '{}'. New environment would be ", (CharSequence)"created based on it: '{}'. In most cases, everything would work as expected."), (Object)pip.getPython().getBinaryDir(), (Object)ext.getEnvPath());
        }
        this.getLogger().lifecycle(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{env.getVersionLine(), ext.getEnvPath()}, new String[]{"Using ", " (in '", "')"})));
        if (!CliUtils.isVersionMatch(env.getVersion(), ext.getMinVirtualenvVersion())) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{env.getVersion()}, new String[]{"Installed virtualenv version ", " does not match minimal "}).plus((GString)new GStringImpl(new Object[]{ext.getMinVirtualenvVersion(), ext.getMinVirtualenvVersion()}, new String[]{"required version ", ". \nVirtualenv ", " is "})).plus("recommended but older version could also be used. \nEither configure lower minimal required ").plus((GString)new GStringImpl(new Object[]{env.getVersion()}, new String[]{"version with [python.minVirtualenvVersion='", "'] \nor upgrade installed "})).plus((GString)new GStringImpl(new Object[]{ext.getVirtualenvVersion()}, new String[]{"virtualenv with [pip install -U virtualenv==", "] \n(or just remove "})).plus("virtualenv with [pip uninstall virtualenv] and plugin will install the correct version itself)")));
        }
        env.create(ext.getEnvCopy());
        this.envCreated = bl = true;
        return true;
    }

    private void switchEnvironment(Virtualenv env, PythonExtension ext) {
        String string = env.getPythonPath();
        ext.setPythonPath(string);
        String string2 = ext.getPythonPath();
        this.setPythonPath(string2);
        this.checkPython(ext);
        if (this.isModulesInstallationRequired()) {
            this.checkPip(ext);
        }
        if (!this.getPython().isVirtualenv()) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{env.getLocation().getAbsolutePath()}, new String[]{"Configured environment is not a virtualenv: ", ". "}).plus("Most likely, issue appear due to incorrect `python.envPath` configuration.")));
        }
        if (this.envCreated) {
            this.dockerChown(env.getPath());
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != CheckPythonTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Object object;
        SYNC = object = new Object();
    }
}

