/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.python.util;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.process.internal.ExecException;

public final class CliUtils
implements GroovyObject {
    private static final String[] EMPTY;
    private static final String SPACE;
    private static final String VERSION_SPLIT = "\\.";
    private static final String BACKSLASH;
    private static final Pattern PIP_CREDENTIALS;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    private CliUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static File searchSystemBinary(String binary) {
        String path = System.getenv("PATH");
        if (path == null || path.isEmpty()) {
            throw (Throwable)new GradleException("PATH variable did not contain anything");
        }
        List target = ScriptBytecodeAdapter.createList((Object[])new Object[]{binary});
        if (Os.isFamily((String)Os.FAMILY_WINDOWS)) {
            target.add((String)ScriptBytecodeAdapter.asType((Object)new GStringImpl(new Object[]{binary}, new String[]{"", ".exe"}), String.class));
        }
        String p = null;
        String[] stringArray = path.split(File.pathSeparator);
        if (stringArray != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                p = stringArray[n2];
                ++n2;
                String name = null;
                Iterator iterator = target.iterator();
                while (iterator.hasNext()) {
                    name = ShortTypeHandling.castToString(iterator.next());
                    File e = new File(p, name);
                    if (!e.isFile()) continue;
                    return e.getAbsoluteFile();
                }
            }
        }
        throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{binary}, new String[]{"'", "' executable was not found in system. Please check PATH variable "}).plus((GString)new GStringImpl(new Object[]{path}, new String[]{"correctness (current process may not see the same PATH as your shell). \n\t PATH=", ""}))));
    }

    public static String prefixOutput(String output, String prefix) {
        Reference prefix2 = new Reference((Object)prefix);
        public final class _prefixOutput_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference prefix;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _prefixOutput_closure1(Object _outerInstance, Object _thisObject, Reference prefix) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.prefix = reference = prefix;
            }

            public Object doCall(Object it) {
                return new GStringImpl(new Object[]{this.prefix.get(), it}, new String[]{"", " ", ""});
            }

            @Generated
            public String getPrefix() {
                return ShortTypeHandling.castToString((Object)this.prefix.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _prefixOutput_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)((String)prefix2.get())) ? DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Iterable)StringGroovyMethods.readLines((CharSequence)output), (Closure)new _prefixOutput_closure1(CliUtils.class, CliUtils.class, prefix2)), (String)System.lineSeparator()) : output;
    }

    public static String[] mergeArgs(Object args1, Object args2) {
        String[] args = new String[]{};
        Object[] objectArray = DefaultGroovyMethods.plus((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)CliUtils.parseArgs(args1), Object[].class)));
        args = (String[])ScriptBytecodeAdapter.castToType((Object)objectArray, String[].class);
        Object[] objectArray2 = DefaultGroovyMethods.plus((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)CliUtils.parseArgs(args2), Object[].class)));
        args = (String[])ScriptBytecodeAdapter.castToType((Object)objectArray2, String[].class);
        return args;
    }

    public static String[] parseArgs(Object args) {
        String[] res = EMPTY;
        if (DefaultTypeTransformation.booleanUnbox((Object)args)) {
            if (args instanceof CharSequence) {
                String[] stringArray = CliUtils.parseCommandLine(DefaultGroovyMethods.toString((Object)args));
                res = stringArray;
            } else {
                String[] stringArray = (String[])ScriptBytecodeAdapter.asType((Object)args, String[].class);
                res = stringArray;
            }
        }
        return res;
    }

    public static String[] parseCommandLine(String command) {
        String cmd = command.trim();
        if (DefaultTypeTransformation.booleanUnbox((Object)cmd)) {
            Reference res = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
            Reference tmp = new Reference((Object)new StringBuilder());
            Reference quoted = new Reference(null);
            String cfr_ignored_0 = (String)quoted.get();
            Reference escaped = new Reference((Object)false);
            public final class _parseCommandLine_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference escaped;
                private /* synthetic */ Reference quoted;
                private /* synthetic */ Reference tmp;
                private /* synthetic */ Reference res;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _parseCommandLine_closure2(Object _outerInstance, Object _thisObject, Reference escaped, Reference quoted, Reference tmp, Reference res) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    this.escaped = reference4 = escaped;
                    this.quoted = reference3 = quoted;
                    this.tmp = reference2 = tmp;
                    this.res = reference = res;
                }

                public Object doCall(Object it) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)(ScriptBytecodeAdapter.createList((Object[])new Object[]{"\"", "'"}) == null ? Boolean.valueOf(it == null) : Boolean.valueOf(DefaultGroovyMethods.isCase((Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{"\"", "'"}), (Object)it)))) && !DefaultTypeTransformation.booleanUnbox((Object)this.escaped.get())) {
                        Object object;
                        if (DefaultTypeTransformation.booleanUnbox((Object)this.quoted.get()) && ScriptBytecodeAdapter.compareEqual((Object)it, (Object)this.quoted.get())) {
                            object = null;
                        } else {
                            Object object2 = this.quoted.get();
                            String string = ShortTypeHandling.castToString((Object)object2);
                            object = DefaultTypeTransformation.booleanUnbox((Object)object2) ? string : it;
                        }
                        String string = object;
                        this.quoted.set((Object)ShortTypeHandling.castToString(string));
                    }
                    if (!DefaultTypeTransformation.booleanUnbox((Object)this.quoted.get()) && ScriptBytecodeAdapter.compareEqual((Object)it, (Object)SPACE)) {
                        if (((StringBuilder)this.tmp.get()).length() == 0) {
                            boolean bl = false;
                            this.escaped.set((Object)bl);
                            return null;
                        }
                        Object object = this.escaped.get();
                        if (object == null ? false : (Boolean)object) {
                            boolean bl = false;
                            this.escaped.set((Object)bl);
                        } else {
                            DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)this.res.get(), List.class)), (Object)((StringBuilder)this.tmp.get()).toString());
                            StringBuilder stringBuilder = new StringBuilder();
                            this.tmp.set((Object)stringBuilder);
                            return null;
                        }
                    }
                    Object object = this.escaped.get();
                    if (object == null ? false : (Boolean)object) {
                        ((StringBuilder)this.tmp.get()).append(BACKSLASH);
                    }
                    boolean bl = ScriptBytecodeAdapter.compareEqual((Object)it, (Object)BACKSLASH);
                    this.escaped.set((Object)bl);
                    if (!DefaultTypeTransformation.booleanUnbox((Object)this.escaped.get())) {
                        return ((StringBuilder)this.tmp.get()).append(it);
                    }
                    return null;
                }

                @Generated
                public Boolean getEscaped() {
                    return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.escaped.get(), Boolean.class);
                }

                @Generated
                public String getQuoted() {
                    return ShortTypeHandling.castToString((Object)this.quoted.get());
                }

                @Generated
                public StringBuilder getTmp() {
                    return (StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.tmp.get(), StringBuilder.class);
                }

                @Generated
                public List getRes() {
                    return (List)ScriptBytecodeAdapter.castToType((Object)this.res.get(), List.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _parseCommandLine_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((Object)cmd, (Closure)new _parseCommandLine_closure2(CliUtils.class, CliUtils.class, escaped, quoted, tmp, res));
            Boolean bl = (Boolean)escaped.get();
            if (bl == null ? false : bl) {
                ((StringBuilder)tmp.get()).append(BACKSLASH);
            }
            DefaultGroovyMethods.leftShift((List)((List)res.get()), (Object)((StringBuilder)tmp.get()).toString());
            return (String[])ScriptBytecodeAdapter.asType((Object)((List)res.get()), String[].class);
        }
        return EMPTY;
    }

    public static boolean isVersionMatch(String version, String required) {
        boolean valid = true;
        if (DefaultTypeTransformation.booleanUnbox((Object)required)) {
            boolean bl;
            String[] req = required.split(VERSION_SPLIT);
            String[] ver = version.split(VERSION_SPLIT);
            if (req.length > 3) {
                throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{required}, new String[]{"Invalid version format: ", ". Accepted format: major.minor.micro"})));
            }
            valid = bl = CliUtils.isPositionMatch(ver, req, 0);
        }
        return valid;
    }

    public static String wrapCommand(String command, boolean isWindows) {
        if (isWindows || command.startsWith("exec(")) {
            return command;
        }
        String cmd = command.replaceAll("^\"|\"$", "");
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{cmd}, new String[]{"exec(\"", "\")"}));
    }

    public static String[] wincmdArgs(String executable, File projectHome, String[] args, boolean workDirUsed) {
        File file = Paths.get(executable, new String[0]).isAbsolute() ? new File(executable) : new File(projectHome, executable);
        if (!file.exists()) {
            throw (Throwable)new ExecException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{executable}, new String[]{"Cannot run program \"", "\": error=2, No such file or directory"})));
        }
        String exec = workDirUsed ? CliUtils.canonicalPath(file) : executable;
        return CliUtils.mergeArgs(ScriptBytecodeAdapter.createList((Object[])new Object[]{"/c", exec.contains(SPACE) ? new GStringImpl(new Object[]{exec}, new String[]{"\"\"", "\"\""}) : exec}), args);
    }

    public static String canonicalPath(File file) {
        return CliUtils.canonicalPath(null, file.getAbsolutePath());
    }

    public static String canonicalPath(String home, String file) {
        String string = file;
        String path = string != null ? string.trim() : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)path)) {
            return path;
        }
        Path relative = Paths.get(file, new String[0]);
        if (!relative.isAbsolute() && home == null) {
            throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((String)"Home dir not specified for relative path validation: ", (CharSequence)file));
        }
        Path target = relative.isAbsolute() ? relative : new File(home, file).toPath();
        if (Files.exists(target, new LinkOption[0])) {
            String string2 = target.toRealPath(LinkOption.NOFOLLOW_LINKS).normalize().toString();
            try {
                return string2;
            }
            catch (AccessDeniedException ignored) {
                String string3 = ShortTypeHandling.castToString((Object)target);
                return string3;
            }
        }
        return relative.normalize().toString();
    }

    public static String pythonBinPath(String pythonHome, boolean windows) {
        if (!Paths.get(pythonHome, new String[0]).isAbsolute()) {
            throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((String)"Non absolute home path provided: ", (CharSequence)pythonHome));
        }
        return CliUtils.canonicalPath(null, ShortTypeHandling.castToString((Object)(windows ? new GStringImpl(new Object[]{pythonHome}, new String[]{"", "/Scripts"}) : new GStringImpl(new Object[]{pythonHome}, new String[]{"", "/bin"}))));
    }

    public static String hidePipCredentials(String cmd) {
        if (!cmd.contains(" --extra-index-url ")) {
            return cmd;
        }
        int lastIndex = 0;
        StringBuilder output = new StringBuilder();
        Matcher matcher = PIP_CREDENTIALS.matcher(cmd);
        while (matcher.find()) {
            int n;
            output.append(cmd, lastIndex, matcher.start(1)).append("*****").append(cmd, matcher.end(1), matcher.end());
            lastIndex = n = matcher.end();
        }
        if (lastIndex < cmd.length()) {
            output.append(cmd, lastIndex, cmd.length());
        }
        return output.toString();
    }

    public static boolean isLinuxHost() {
        return Os.isFamily((String)Os.FAMILY_UNIX) && !Os.isFamily((String)Os.FAMILY_MAC);
    }

    private static boolean isPositionMatch(String[] ver, String[] req, int pos) {
        boolean valid = ScriptBytecodeAdapter.compareGreaterThanEqual((Object)((Integer)ScriptBytecodeAdapter.asType((Object)BytecodeInterface8.objectArrayGet((Object[])ver, (int)pos), Integer.class)), (Object)((Integer)ScriptBytecodeAdapter.asType((Object)BytecodeInterface8.objectArrayGet((Object[])req, (int)pos), Integer.class)));
        if (valid && ScriptBytecodeAdapter.compareEqual((Object)BytecodeInterface8.objectArrayGet((Object[])ver, (int)pos), (Object)BytecodeInterface8.objectArrayGet((Object[])req, (int)pos)) && req.length > pos + 1) {
            return CliUtils.isPositionMatch(ver, req, pos + 1);
        }
        return valid;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CliUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Pattern pattern;
        String string;
        String string2;
        BACKSLASH = string2 = "\\";
        SPACE = string = " ";
        String[] stringArray = new String[]{};
        EMPTY = stringArray;
        PIP_CREDENTIALS = pattern = Pattern.compile(" --extra-index-url +https?://[^:]+:([^@]+)@");
    }
}

