/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.events;

import java.util.Arrays;
import ru.yandex.qatools.allure.events.AbstractTestCaseStartedEvent;
import ru.yandex.qatools.allure.model.Description;
import ru.yandex.qatools.allure.model.Label;
import ru.yandex.qatools.allure.model.Status;
import ru.yandex.qatools.allure.model.TestCaseResult;

public class TestCaseStartedEvent
extends AbstractTestCaseStartedEvent {
    public TestCaseStartedEvent(String suiteUid, String name) {
        this.setSuiteUid(suiteUid);
        this.setName(name);
    }

    @Override
    public void process(TestCaseResult testCase) {
        testCase.setStart(System.currentTimeMillis());
        testCase.setStatus(Status.PASSED);
        testCase.setName(this.getName());
        testCase.setTitle(this.getTitle());
        testCase.setDescription(this.getDescription());
        testCase.setLabels(this.getLabels());
    }

    public TestCaseStartedEvent withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public TestCaseStartedEvent withDescription(Description description) {
        this.setDescription(description);
        return this;
    }

    public TestCaseStartedEvent withLabels(Label label, Label ... labels) {
        this.getLabels().add(label);
        this.getLabels().addAll(Arrays.asList(labels));
        return this;
    }
}

