/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.events;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import ru.yandex.qatools.allure.events.AbstractTestCaseStatusChangeEvent;
import ru.yandex.qatools.allure.model.Failure;
import ru.yandex.qatools.allure.model.Status;
import ru.yandex.qatools.allure.model.TestCaseResult;

public abstract class TestCaseStatusChangeEvent
extends AbstractTestCaseStatusChangeEvent {
    protected abstract Status getStatus();

    protected abstract String getMessage();

    @Override
    public void process(TestCaseResult testCase) {
        testCase.setStatus(this.getStatus());
        testCase.setFailure(this.throwable == null ? this.getDefaultFailure() : this.getFailure());
    }

    private Failure getFailure() {
        return new Failure().withMessage(this.getMessage(this.getThrowable())).withStackTrace(this.getStackTrace(this.getThrowable()));
    }

    private String getMessage(Throwable throwable) {
        return String.format("%s: %s", throwable.getClass().getSimpleName(), throwable.getMessage());
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private Failure getDefaultFailure() {
        return new Failure().withMessage(this.getMessage()).withStackTrace("There are no stack trace");
    }
}

