/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an archive rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArchiveRuleSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ArchiveRuleSummary.Builder, ArchiveRuleSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(ArchiveRuleSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Map<String, Criterion>> FILTER_FIELD = SdkField
            .<Map<String, Criterion>> builder(MarshallingType.MAP)
            .memberName("filter")
            .getter(getter(ArchiveRuleSummary::filter))
            .setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Criterion> builder(MarshallingType.SDK_POJO)
                                            .constructor(Criterion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleName").getter(getter(ArchiveRuleSummary::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleName").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(ArchiveRuleSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            FILTER_FIELD, RULE_NAME_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final Map<String, Criterion> filter;

    private final String ruleName;

    private final Instant updatedAt;

    private ArchiveRuleSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.filter = builder.filter;
        this.ruleName = builder.ruleName;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The time at which the archive rule was created.
     * </p>
     * 
     * @return The time at which the archive rule was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filter property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilter() {
        return filter != null && !(filter instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A filter used to define the archive rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilter} method.
     * </p>
     * 
     * @return A filter used to define the archive rule.
     */
    public final Map<String, Criterion> filter() {
        return filter;
    }

    /**
     * <p>
     * The name of the archive rule.
     * </p>
     * 
     * @return The name of the archive rule.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The time at which the archive rule was last updated.
     * </p>
     * 
     * @return The time at which the archive rule was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilter() ? filter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveRuleSummary)) {
            return false;
        }
        ArchiveRuleSummary other = (ArchiveRuleSummary) obj;
        return Objects.equals(createdAt(), other.createdAt()) && hasFilter() == other.hasFilter()
                && Objects.equals(filter(), other.filter()) && Objects.equals(ruleName(), other.ruleName())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArchiveRuleSummary").add("CreatedAt", createdAt()).add("Filter", hasFilter() ? filter() : null)
                .add("RuleName", ruleName()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "ruleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArchiveRuleSummary, T> g) {
        return obj -> g.apply((ArchiveRuleSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArchiveRuleSummary> {
        /**
         * <p>
         * The time at which the archive rule was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the archive rule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A filter used to define the archive rule.
         * </p>
         * 
         * @param filter
         *        A filter used to define the archive rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Map<String, Criterion> filter);

        /**
         * <p>
         * The name of the archive rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the archive rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The time at which the archive rule was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The time at which the archive rule was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private Map<String, Criterion> filter = DefaultSdkAutoConstructMap.getInstance();

        private String ruleName;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveRuleSummary model) {
            createdAt(model.createdAt);
            filter(model.filter);
            ruleName(model.ruleName);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Map<String, Criterion.Builder> getFilter() {
            Map<String, Criterion.Builder> result = FilterCriteriaMapCopier.copyToBuilder(this.filter);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFilter(Map<String, Criterion.BuilderImpl> filter) {
            this.filter = FilterCriteriaMapCopier.copyFromBuilder(filter);
        }

        @Override
        @Transient
        public final Builder filter(Map<String, Criterion> filter) {
            this.filter = FilterCriteriaMapCopier.copy(filter);
            return this;
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        @Transient
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        @Transient
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public ArchiveRuleSummary build() {
            return new ArchiveRuleSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
