/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAnalyzedResourceResponse extends AccessAnalyzerResponse implements
        ToCopyableBuilder<GetAnalyzedResourceResponse.Builder, GetAnalyzedResourceResponse> {
    private static final SdkField<AnalyzedResource> RESOURCE_FIELD = SdkField
            .<AnalyzedResource> builder(MarshallingType.SDK_POJO).memberName("resource")
            .getter(getter(GetAnalyzedResourceResponse::resource)).setter(setter(Builder::resource))
            .constructor(AnalyzedResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD));

    private final AnalyzedResource resource;

    private GetAnalyzedResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resource = builder.resource;
    }

    /**
     * <p>
     * An <code>AnalyzedResource</code> object that contains information that IAM Access Analyzer found when it analyzed
     * the resource.
     * </p>
     * 
     * @return An <code>AnalyzedResource</code> object that contains information that IAM Access Analyzer found when it
     *         analyzed the resource.
     */
    public final AnalyzedResource resource() {
        return resource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnalyzedResourceResponse)) {
            return false;
        }
        GetAnalyzedResourceResponse other = (GetAnalyzedResourceResponse) obj;
        return Objects.equals(resource(), other.resource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAnalyzedResourceResponse").add("Resource", resource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAnalyzedResourceResponse, T> g) {
        return obj -> g.apply((GetAnalyzedResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAnalyzedResourceResponse> {
        /**
         * <p>
         * An <code>AnalyzedResource</code> object that contains information that IAM Access Analyzer found when it
         * analyzed the resource.
         * </p>
         * 
         * @param resource
         *        An <code>AnalyzedResource</code> object that contains information that IAM Access Analyzer found when
         *        it analyzed the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(AnalyzedResource resource);

        /**
         * <p>
         * An <code>AnalyzedResource</code> object that contains information that IAM Access Analyzer found when it
         * analyzed the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalyzedResource.Builder} avoiding the need to
         * create one manually via {@link AnalyzedResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalyzedResource.Builder#build()} is called immediately and its
         * result is passed to {@link #resource(AnalyzedResource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link AnalyzedResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(AnalyzedResource)
         */
        default Builder resource(Consumer<AnalyzedResource.Builder> resource) {
            return resource(AnalyzedResource.builder().applyMutation(resource).build());
        }
    }

    static final class BuilderImpl extends AccessAnalyzerResponse.BuilderImpl implements Builder {
        private AnalyzedResource resource;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnalyzedResourceResponse model) {
            super(model);
            resource(model.resource);
        }

        public final AnalyzedResource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(AnalyzedResource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        @Transient
        public final Builder resource(AnalyzedResource resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public GetAnalyzedResourceResponse build() {
            return new GetAnalyzedResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
