/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessPreviewsResponse extends AccessAnalyzerResponse implements
        ToCopyableBuilder<ListAccessPreviewsResponse.Builder, ListAccessPreviewsResponse> {
    private static final SdkField<List<AccessPreviewSummary>> ACCESS_PREVIEWS_FIELD = SdkField
            .<List<AccessPreviewSummary>> builder(MarshallingType.LIST)
            .memberName("accessPreviews")
            .getter(getter(ListAccessPreviewsResponse::accessPreviews))
            .setter(setter(Builder::accessPreviews))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPreviews").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessPreviewSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessPreviewSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAccessPreviewsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_PREVIEWS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AccessPreviewSummary> accessPreviews;

    private final String nextToken;

    private ListAccessPreviewsResponse(BuilderImpl builder) {
        super(builder);
        this.accessPreviews = builder.accessPreviews;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessPreviews property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessPreviews() {
        return accessPreviews != null && !(accessPreviews instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of access previews retrieved for the analyzer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessPreviews} method.
     * </p>
     * 
     * @return A list of access previews retrieved for the analyzer.
     */
    public final List<AccessPreviewSummary> accessPreviews() {
        return accessPreviews;
    }

    /**
     * <p>
     * A token used for pagination of results returned.
     * </p>
     * 
     * @return A token used for pagination of results returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessPreviews() ? accessPreviews() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessPreviewsResponse)) {
            return false;
        }
        ListAccessPreviewsResponse other = (ListAccessPreviewsResponse) obj;
        return hasAccessPreviews() == other.hasAccessPreviews() && Objects.equals(accessPreviews(), other.accessPreviews())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessPreviewsResponse")
                .add("AccessPreviews", hasAccessPreviews() ? accessPreviews() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessPreviews":
            return Optional.ofNullable(clazz.cast(accessPreviews()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessPreviewsResponse, T> g) {
        return obj -> g.apply((ListAccessPreviewsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAccessPreviewsResponse> {
        /**
         * <p>
         * A list of access previews retrieved for the analyzer.
         * </p>
         * 
         * @param accessPreviews
         *        A list of access previews retrieved for the analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPreviews(Collection<AccessPreviewSummary> accessPreviews);

        /**
         * <p>
         * A list of access previews retrieved for the analyzer.
         * </p>
         * 
         * @param accessPreviews
         *        A list of access previews retrieved for the analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPreviews(AccessPreviewSummary... accessPreviews);

        /**
         * <p>
         * A list of access previews retrieved for the analyzer.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccessPreviewSummary>.Builder} avoiding the
         * need to create one manually via {@link List<AccessPreviewSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccessPreviewSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #accessPreviews(List<AccessPreviewSummary>)}.
         * 
         * @param accessPreviews
         *        a consumer that will call methods on {@link List<AccessPreviewSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPreviews(List<AccessPreviewSummary>)
         */
        Builder accessPreviews(Consumer<AccessPreviewSummary.Builder>... accessPreviews);

        /**
         * <p>
         * A token used for pagination of results returned.
         * </p>
         * 
         * @param nextToken
         *        A token used for pagination of results returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AccessAnalyzerResponse.BuilderImpl implements Builder {
        private List<AccessPreviewSummary> accessPreviews = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessPreviewsResponse model) {
            super(model);
            accessPreviews(model.accessPreviews);
            nextToken(model.nextToken);
        }

        public final List<AccessPreviewSummary.Builder> getAccessPreviews() {
            List<AccessPreviewSummary.Builder> result = AccessPreviewsListCopier.copyToBuilder(this.accessPreviews);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessPreviews(Collection<AccessPreviewSummary.BuilderImpl> accessPreviews) {
            this.accessPreviews = AccessPreviewsListCopier.copyFromBuilder(accessPreviews);
        }

        @Override
        @Transient
        public final Builder accessPreviews(Collection<AccessPreviewSummary> accessPreviews) {
            this.accessPreviews = AccessPreviewsListCopier.copy(accessPreviews);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder accessPreviews(AccessPreviewSummary... accessPreviews) {
            accessPreviews(Arrays.asList(accessPreviews));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder accessPreviews(Consumer<AccessPreviewSummary.Builder>... accessPreviews) {
            accessPreviews(Stream.of(accessPreviews).map(c -> AccessPreviewSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAccessPreviewsResponse build() {
            return new ListAccessPreviewsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
