/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AclGrantee
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AclGrantee> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AclGrantee.getter(AclGrantee::id)).setter(AclGrantee.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uri").getter(AclGrantee.getter(AclGrantee::uri)).setter(AclGrantee.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AclGrantee.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String uri;
    private final Type type;

    private AclGrantee(BuilderImpl builder) {
        this.id = builder.id;
        this.uri = builder.uri;
        this.type = builder.type;
    }

    public final String id() {
        return this.id;
    }

    public final String uri() {
        return this.uri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AclGrantee)) {
            return false;
        }
        AclGrantee other = (AclGrantee)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.uri(), other.uri());
    }

    public final String toString() {
        return ToString.builder((String)"AclGrantee").add("Id", (Object)this.id()).add("Uri", (Object)this.uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
        }
        return Optional.empty();
    }

    public static AclGrantee fromId(String id) {
        return (AclGrantee)AclGrantee.builder().id(id).build();
    }

    public static AclGrantee fromUri(String uri) {
        return (AclGrantee)AclGrantee.builder().uri(uri).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("id", ID_FIELD);
        map.put("uri", URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AclGrantee, T> g) {
        return obj -> g.apply((AclGrantee)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ID,
        URI,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String uri;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AclGrantee model) {
            this.id(model.id);
            this.uri(model.uri);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            String oldValue = this.id;
            this.id = id;
            this.handleUnionValueChange(Type.ID, oldValue, this.id);
        }

        @Override
        public final Builder id(String id) {
            String oldValue = this.id;
            this.id = id;
            this.handleUnionValueChange(Type.ID, oldValue, this.id);
            return this;
        }

        public final String getUri() {
            return this.uri;
        }

        public final void setUri(String uri) {
            String oldValue = this.uri;
            this.uri = uri;
            this.handleUnionValueChange(Type.URI, oldValue, this.uri);
        }

        @Override
        public final Builder uri(String uri) {
            String oldValue = this.uri;
            this.uri = uri;
            this.handleUnionValueChange(Type.URI, oldValue, this.uri);
            return this;
        }

        public AclGrantee build() {
            return new AclGrantee(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AclGrantee> {
        public Builder id(String var1);

        public Builder uri(String var1);
    }
}

