/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amp.model.AmpRequest;
import software.amazon.awssdk.services.amp.model.LimitsPerLabelSet;
import software.amazon.awssdk.services.amp.model.LimitsPerLabelSetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkspaceConfigurationRequest
extends AmpRequest
implements ToCopyableBuilder<Builder, UpdateWorkspaceConfigurationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateWorkspaceConfigurationRequest.getter(UpdateWorkspaceConfigurationRequest::clientToken)).setter(UpdateWorkspaceConfigurationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<LimitsPerLabelSet>> LIMITS_PER_LABEL_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("limitsPerLabelSet").getter(UpdateWorkspaceConfigurationRequest.getter(UpdateWorkspaceConfigurationRequest::limitsPerLabelSet)).setter(UpdateWorkspaceConfigurationRequest.setter(Builder::limitsPerLabelSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limitsPerLabelSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LimitsPerLabelSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("retentionPeriodInDays").getter(UpdateWorkspaceConfigurationRequest.getter(UpdateWorkspaceConfigurationRequest::retentionPeriodInDays)).setter(UpdateWorkspaceConfigurationRequest.setter(Builder::retentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriodInDays").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(UpdateWorkspaceConfigurationRequest.getter(UpdateWorkspaceConfigurationRequest::workspaceId)).setter(UpdateWorkspaceConfigurationRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, LIMITS_PER_LABEL_SET_FIELD, RETENTION_PERIOD_IN_DAYS_FIELD, WORKSPACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateWorkspaceConfigurationRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final List<LimitsPerLabelSet> limitsPerLabelSet;
    private final Integer retentionPeriodInDays;
    private final String workspaceId;

    private UpdateWorkspaceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.limitsPerLabelSet = builder.limitsPerLabelSet;
        this.retentionPeriodInDays = builder.retentionPeriodInDays;
        this.workspaceId = builder.workspaceId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasLimitsPerLabelSet() {
        return this.limitsPerLabelSet != null && !(this.limitsPerLabelSet instanceof SdkAutoConstructList);
    }

    public final List<LimitsPerLabelSet> limitsPerLabelSet() {
        return this.limitsPerLabelSet;
    }

    public final Integer retentionPeriodInDays() {
        return this.retentionPeriodInDays;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLimitsPerLabelSet() ? this.limitsPerLabelSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspaceConfigurationRequest)) {
            return false;
        }
        UpdateWorkspaceConfigurationRequest other = (UpdateWorkspaceConfigurationRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && this.hasLimitsPerLabelSet() == other.hasLimitsPerLabelSet() && Objects.equals(this.limitsPerLabelSet(), other.limitsPerLabelSet()) && Objects.equals(this.retentionPeriodInDays(), other.retentionPeriodInDays()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkspaceConfigurationRequest").add("ClientToken", (Object)this.clientToken()).add("LimitsPerLabelSet", this.hasLimitsPerLabelSet() ? this.limitsPerLabelSet() : null).add("RetentionPeriodInDays", (Object)this.retentionPeriodInDays()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "limitsPerLabelSet": {
                return Optional.ofNullable(clazz.cast(this.limitsPerLabelSet()));
            }
            case "retentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriodInDays()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("limitsPerLabelSet", LIMITS_PER_LABEL_SET_FIELD);
        map.put("retentionPeriodInDays", RETENTION_PERIOD_IN_DAYS_FIELD);
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspaceConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateWorkspaceConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmpRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private List<LimitsPerLabelSet> limitsPerLabelSet = DefaultSdkAutoConstructList.getInstance();
        private Integer retentionPeriodInDays;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspaceConfigurationRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.limitsPerLabelSet(model.limitsPerLabelSet);
            this.retentionPeriodInDays(model.retentionPeriodInDays);
            this.workspaceId(model.workspaceId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<LimitsPerLabelSet.Builder> getLimitsPerLabelSet() {
            List<LimitsPerLabelSet.Builder> result = LimitsPerLabelSetListCopier.copyToBuilder(this.limitsPerLabelSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLimitsPerLabelSet(Collection<LimitsPerLabelSet.BuilderImpl> limitsPerLabelSet) {
            this.limitsPerLabelSet = LimitsPerLabelSetListCopier.copyFromBuilder(limitsPerLabelSet);
        }

        @Override
        public final Builder limitsPerLabelSet(Collection<LimitsPerLabelSet> limitsPerLabelSet) {
            this.limitsPerLabelSet = LimitsPerLabelSetListCopier.copy(limitsPerLabelSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limitsPerLabelSet(LimitsPerLabelSet ... limitsPerLabelSet) {
            this.limitsPerLabelSet(Arrays.asList(limitsPerLabelSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limitsPerLabelSet(Consumer<LimitsPerLabelSet.Builder> ... limitsPerLabelSet) {
            this.limitsPerLabelSet(Stream.of(limitsPerLabelSet).map(c -> (LimitsPerLabelSet)((LimitsPerLabelSet.Builder)LimitsPerLabelSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getRetentionPeriodInDays() {
            return this.retentionPeriodInDays;
        }

        public final void setRetentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
        }

        @Override
        public final Builder retentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkspaceConfigurationRequest build() {
            return new UpdateWorkspaceConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AmpRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkspaceConfigurationRequest> {
        public Builder clientToken(String var1);

        public Builder limitsPerLabelSet(Collection<LimitsPerLabelSet> var1);

        public Builder limitsPerLabelSet(LimitsPerLabelSet ... var1);

        public Builder limitsPerLabelSet(Consumer<LimitsPerLabelSet.Builder> ... var1);

        public Builder retentionPeriodInDays(Integer var1);

        public Builder workspaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

