/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amp.model.AmpResponse;
import software.amazon.awssdk.services.amp.model.WorkspacePolicyStatusCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeResourcePolicyResponse
extends AmpResponse
implements ToCopyableBuilder<Builder, DescribeResourcePolicyResponse> {
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyDocument").getter(DescribeResourcePolicyResponse.getter(DescribeResourcePolicyResponse::policyDocument)).setter(DescribeResourcePolicyResponse.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()}).build();
    private static final SdkField<String> POLICY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyStatus").getter(DescribeResourcePolicyResponse.getter(DescribeResourcePolicyResponse::policyStatusAsString)).setter(DescribeResourcePolicyResponse.setter(Builder::policyStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStatus").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(DescribeResourcePolicyResponse.getter(DescribeResourcePolicyResponse::revisionId)).setter(DescribeResourcePolicyResponse.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_DOCUMENT_FIELD, POLICY_STATUS_FIELD, REVISION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeResourcePolicyResponse.memberNameToFieldInitializer();
    private final String policyDocument;
    private final String policyStatus;
    private final String revisionId;

    private DescribeResourcePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyDocument = builder.policyDocument;
        this.policyStatus = builder.policyStatus;
        this.revisionId = builder.revisionId;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final WorkspacePolicyStatusCode policyStatus() {
        return WorkspacePolicyStatusCode.fromValue(this.policyStatus);
    }

    public final String policyStatusAsString() {
        return this.policyStatus;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourcePolicyResponse)) {
            return false;
        }
        DescribeResourcePolicyResponse other = (DescribeResourcePolicyResponse)((Object)obj);
        return Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.policyStatusAsString(), other.policyStatusAsString()) && Objects.equals(this.revisionId(), other.revisionId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeResourcePolicyResponse").add("PolicyDocument", (Object)this.policyDocument()).add("PolicyStatus", (Object)this.policyStatusAsString()).add("RevisionId", (Object)this.revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "policyStatus": {
                return Optional.ofNullable(clazz.cast(this.policyStatusAsString()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        map.put("policyStatus", POLICY_STATUS_FIELD);
        map.put("revisionId", REVISION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourcePolicyResponse, T> g) {
        return obj -> g.apply((DescribeResourcePolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmpResponse.BuilderImpl
    implements Builder {
        private String policyDocument;
        private String policyStatus;
        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourcePolicyResponse model) {
            super(model);
            this.policyDocument(model.policyDocument);
            this.policyStatus(model.policyStatus);
            this.revisionId(model.revisionId);
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getPolicyStatus() {
            return this.policyStatus;
        }

        public final void setPolicyStatus(String policyStatus) {
            this.policyStatus = policyStatus;
        }

        @Override
        public final Builder policyStatus(String policyStatus) {
            this.policyStatus = policyStatus;
            return this;
        }

        @Override
        public final Builder policyStatus(WorkspacePolicyStatusCode policyStatus) {
            this.policyStatus(policyStatus == null ? null : policyStatus.toString());
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        @Override
        public DescribeResourcePolicyResponse build() {
            return new DescribeResourcePolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AmpResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeResourcePolicyResponse> {
        public Builder policyDocument(String var1);

        public Builder policyStatus(String var1);

        public Builder policyStatus(WorkspacePolicyStatusCode var1);

        public Builder revisionId(String var1);
    }
}

