/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request body for CreateBackend.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBackendRequest extends AmplifyBackendRequest implements
        ToCopyableBuilder<CreateBackendRequest.Builder, CreateBackendRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AppId")
            .getter(getter(CreateBackendRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> APP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppName").getter(getter(CreateBackendRequest::appName)).setter(setter(Builder::appName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appName").build()).build();

    private static final SdkField<String> BACKEND_ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackendEnvironmentName").getter(getter(CreateBackendRequest::backendEnvironmentName))
            .setter(setter(Builder::backendEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironmentName").build())
            .build();

    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField
            .<ResourceConfig> builder(MarshallingType.SDK_POJO).memberName("ResourceConfig")
            .getter(getter(CreateBackendRequest::resourceConfig)).setter(setter(Builder::resourceConfig))
            .constructor(ResourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfig").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(CreateBackendRequest::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, APP_NAME_FIELD,
            BACKEND_ENVIRONMENT_NAME_FIELD, RESOURCE_CONFIG_FIELD, RESOURCE_NAME_FIELD));

    private final String appId;

    private final String appName;

    private final String backendEnvironmentName;

    private final ResourceConfig resourceConfig;

    private final String resourceName;

    private CreateBackendRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.appName = builder.appName;
        this.backendEnvironmentName = builder.backendEnvironmentName;
        this.resourceConfig = builder.resourceConfig;
        this.resourceName = builder.resourceName;
    }

    /**
     * <p>
     * The app ID.
     * </p>
     * 
     * @return The app ID.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The name of the app.
     * </p>
     * 
     * @return The name of the app.
     */
    public final String appName() {
        return appName;
    }

    /**
     * <p>
     * The name of the backend environment.
     * </p>
     * 
     * @return The name of the backend environment.
     */
    public final String backendEnvironmentName() {
        return backendEnvironmentName;
    }

    /**
     * <p>
     * The resource configuration for creating backend storage.
     * </p>
     * 
     * @return The resource configuration for creating backend storage.
     */
    public final ResourceConfig resourceConfig() {
        return resourceConfig;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String resourceName() {
        return resourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(appName());
        hashCode = 31 * hashCode + Objects.hashCode(backendEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackendRequest)) {
            return false;
        }
        CreateBackendRequest other = (CreateBackendRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(appName(), other.appName())
                && Objects.equals(backendEnvironmentName(), other.backendEnvironmentName())
                && Objects.equals(resourceConfig(), other.resourceConfig())
                && Objects.equals(resourceName(), other.resourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBackendRequest").add("AppId", appId()).add("AppName", appName())
                .add("BackendEnvironmentName", backendEnvironmentName()).add("ResourceConfig", resourceConfig())
                .add("ResourceName", resourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "AppName":
            return Optional.ofNullable(clazz.cast(appName()));
        case "BackendEnvironmentName":
            return Optional.ofNullable(clazz.cast(backendEnvironmentName()));
        case "ResourceConfig":
            return Optional.ofNullable(clazz.cast(resourceConfig()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackendRequest, T> g) {
        return obj -> g.apply((CreateBackendRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyBackendRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBackendRequest> {
        /**
         * <p>
         * The app ID.
         * </p>
         * 
         * @param appId
         *        The app ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The name of the app.
         * </p>
         * 
         * @param appName
         *        The name of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appName(String appName);

        /**
         * <p>
         * The name of the backend environment.
         * </p>
         * 
         * @param backendEnvironmentName
         *        The name of the backend environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendEnvironmentName(String backendEnvironmentName);

        /**
         * <p>
         * The resource configuration for creating backend storage.
         * </p>
         * 
         * @param resourceConfig
         *        The resource configuration for creating backend storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfig(ResourceConfig resourceConfig);

        /**
         * <p>
         * The resource configuration for creating backend storage.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceConfig.Builder} avoiding the need to
         * create one manually via {@link ResourceConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceConfig(ResourceConfig)}.
         * 
         * @param resourceConfig
         *        a consumer that will call methods on {@link ResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceConfig(ResourceConfig)
         */
        default Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return resourceConfig(ResourceConfig.builder().applyMutation(resourceConfig).build());
        }

        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param resourceName
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyBackendRequest.BuilderImpl implements Builder {
        private String appId;

        private String appName;

        private String backendEnvironmentName;

        private ResourceConfig resourceConfig;

        private String resourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackendRequest model) {
            super(model);
            appId(model.appId);
            appName(model.appName);
            backendEnvironmentName(model.backendEnvironmentName);
            resourceConfig(model.resourceConfig);
            resourceName(model.resourceName);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        @Transient
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getAppName() {
            return appName;
        }

        public final void setAppName(String appName) {
            this.appName = appName;
        }

        @Override
        @Transient
        public final Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public final String getBackendEnvironmentName() {
            return backendEnvironmentName;
        }

        public final void setBackendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
        }

        @Override
        @Transient
        public final Builder backendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
            return this;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return resourceConfig != null ? resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        @Transient
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBackendRequest build() {
            return new CreateBackendRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
