/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifybackend.model.ListOfOAuthScopesElementCopier;
import software.amazon.awssdk.services.amplifybackend.model.ListOf__stringCopier;
import software.amazon.awssdk.services.amplifybackend.model.OAuthGrantType;
import software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement;
import software.amazon.awssdk.services.amplifybackend.model.SocialProviderSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBackendAuthOAuthConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateBackendAuthOAuthConfig> {
    private static final SdkField<String> DOMAIN_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainPrefix").getter(CreateBackendAuthOAuthConfig.getter(CreateBackendAuthOAuthConfig::domainPrefix)).setter(CreateBackendAuthOAuthConfig.setter(Builder::domainPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainPrefix").build()}).build();
    private static final SdkField<String> O_AUTH_GRANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OAuthGrantType").getter(CreateBackendAuthOAuthConfig.getter(CreateBackendAuthOAuthConfig::oAuthGrantTypeAsString)).setter(CreateBackendAuthOAuthConfig.setter(Builder::oAuthGrantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthGrantType").build()}).build();
    private static final SdkField<List<String>> O_AUTH_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OAuthScopes").getter(CreateBackendAuthOAuthConfig.getter(CreateBackendAuthOAuthConfig::oAuthScopesAsStrings)).setter(CreateBackendAuthOAuthConfig.setter(Builder::oAuthScopesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REDIRECT_SIGN_IN_UR_IS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RedirectSignInURIs").getter(CreateBackendAuthOAuthConfig.getter(CreateBackendAuthOAuthConfig::redirectSignInURIs)).setter(CreateBackendAuthOAuthConfig.setter(Builder::redirectSignInURIs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redirectSignInURIs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REDIRECT_SIGN_OUT_UR_IS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RedirectSignOutURIs").getter(CreateBackendAuthOAuthConfig.getter(CreateBackendAuthOAuthConfig::redirectSignOutURIs)).setter(CreateBackendAuthOAuthConfig.setter(Builder::redirectSignOutURIs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redirectSignOutURIs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SocialProviderSettings> SOCIAL_PROVIDER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SocialProviderSettings").getter(CreateBackendAuthOAuthConfig.getter(CreateBackendAuthOAuthConfig::socialProviderSettings)).setter(CreateBackendAuthOAuthConfig.setter(Builder::socialProviderSettings)).constructor(SocialProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("socialProviderSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_PREFIX_FIELD, O_AUTH_GRANT_TYPE_FIELD, O_AUTH_SCOPES_FIELD, REDIRECT_SIGN_IN_UR_IS_FIELD, REDIRECT_SIGN_OUT_UR_IS_FIELD, SOCIAL_PROVIDER_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainPrefix;
    private final String oAuthGrantType;
    private final List<String> oAuthScopes;
    private final List<String> redirectSignInURIs;
    private final List<String> redirectSignOutURIs;
    private final SocialProviderSettings socialProviderSettings;

    private CreateBackendAuthOAuthConfig(BuilderImpl builder) {
        this.domainPrefix = builder.domainPrefix;
        this.oAuthGrantType = builder.oAuthGrantType;
        this.oAuthScopes = builder.oAuthScopes;
        this.redirectSignInURIs = builder.redirectSignInURIs;
        this.redirectSignOutURIs = builder.redirectSignOutURIs;
        this.socialProviderSettings = builder.socialProviderSettings;
    }

    public final String domainPrefix() {
        return this.domainPrefix;
    }

    public final OAuthGrantType oAuthGrantType() {
        return OAuthGrantType.fromValue(this.oAuthGrantType);
    }

    public final String oAuthGrantTypeAsString() {
        return this.oAuthGrantType;
    }

    public final List<OAuthScopesElement> oAuthScopes() {
        return ListOfOAuthScopesElementCopier.copyStringToEnum(this.oAuthScopes);
    }

    public final boolean hasOAuthScopes() {
        return this.oAuthScopes != null && !(this.oAuthScopes instanceof SdkAutoConstructList);
    }

    public final List<String> oAuthScopesAsStrings() {
        return this.oAuthScopes;
    }

    public final boolean hasRedirectSignInURIs() {
        return this.redirectSignInURIs != null && !(this.redirectSignInURIs instanceof SdkAutoConstructList);
    }

    public final List<String> redirectSignInURIs() {
        return this.redirectSignInURIs;
    }

    public final boolean hasRedirectSignOutURIs() {
        return this.redirectSignOutURIs != null && !(this.redirectSignOutURIs instanceof SdkAutoConstructList);
    }

    public final List<String> redirectSignOutURIs() {
        return this.redirectSignOutURIs;
    }

    public final SocialProviderSettings socialProviderSettings() {
        return this.socialProviderSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuthGrantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOAuthScopes() ? this.oAuthScopesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRedirectSignInURIs() ? this.redirectSignInURIs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRedirectSignOutURIs() ? this.redirectSignOutURIs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.socialProviderSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackendAuthOAuthConfig)) {
            return false;
        }
        CreateBackendAuthOAuthConfig other = (CreateBackendAuthOAuthConfig)obj;
        return Objects.equals(this.domainPrefix(), other.domainPrefix()) && Objects.equals(this.oAuthGrantTypeAsString(), other.oAuthGrantTypeAsString()) && this.hasOAuthScopes() == other.hasOAuthScopes() && Objects.equals(this.oAuthScopesAsStrings(), other.oAuthScopesAsStrings()) && this.hasRedirectSignInURIs() == other.hasRedirectSignInURIs() && Objects.equals(this.redirectSignInURIs(), other.redirectSignInURIs()) && this.hasRedirectSignOutURIs() == other.hasRedirectSignOutURIs() && Objects.equals(this.redirectSignOutURIs(), other.redirectSignOutURIs()) && Objects.equals(this.socialProviderSettings(), other.socialProviderSettings());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBackendAuthOAuthConfig").add("DomainPrefix", (Object)this.domainPrefix()).add("OAuthGrantType", (Object)this.oAuthGrantTypeAsString()).add("OAuthScopes", this.hasOAuthScopes() ? this.oAuthScopesAsStrings() : null).add("RedirectSignInURIs", this.hasRedirectSignInURIs() ? this.redirectSignInURIs() : null).add("RedirectSignOutURIs", this.hasRedirectSignOutURIs() ? this.redirectSignOutURIs() : null).add("SocialProviderSettings", (Object)this.socialProviderSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainPrefix": {
                return Optional.ofNullable(clazz.cast(this.domainPrefix()));
            }
            case "OAuthGrantType": {
                return Optional.ofNullable(clazz.cast(this.oAuthGrantTypeAsString()));
            }
            case "OAuthScopes": {
                return Optional.ofNullable(clazz.cast(this.oAuthScopesAsStrings()));
            }
            case "RedirectSignInURIs": {
                return Optional.ofNullable(clazz.cast(this.redirectSignInURIs()));
            }
            case "RedirectSignOutURIs": {
                return Optional.ofNullable(clazz.cast(this.redirectSignOutURIs()));
            }
            case "SocialProviderSettings": {
                return Optional.ofNullable(clazz.cast(this.socialProviderSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackendAuthOAuthConfig, T> g) {
        return obj -> g.apply((CreateBackendAuthOAuthConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainPrefix;
        private String oAuthGrantType;
        private List<String> oAuthScopes = DefaultSdkAutoConstructList.getInstance();
        private List<String> redirectSignInURIs = DefaultSdkAutoConstructList.getInstance();
        private List<String> redirectSignOutURIs = DefaultSdkAutoConstructList.getInstance();
        private SocialProviderSettings socialProviderSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackendAuthOAuthConfig model) {
            this.domainPrefix(model.domainPrefix);
            this.oAuthGrantType(model.oAuthGrantType);
            this.oAuthScopesWithStrings(model.oAuthScopes);
            this.redirectSignInURIs(model.redirectSignInURIs);
            this.redirectSignOutURIs(model.redirectSignOutURIs);
            this.socialProviderSettings(model.socialProviderSettings);
        }

        public final String getDomainPrefix() {
            return this.domainPrefix;
        }

        public final void setDomainPrefix(String domainPrefix) {
            this.domainPrefix = domainPrefix;
        }

        @Override
        @Transient
        public final Builder domainPrefix(String domainPrefix) {
            this.domainPrefix = domainPrefix;
            return this;
        }

        public final String getOAuthGrantType() {
            return this.oAuthGrantType;
        }

        public final void setOAuthGrantType(String oAuthGrantType) {
            this.oAuthGrantType = oAuthGrantType;
        }

        @Override
        @Transient
        public final Builder oAuthGrantType(String oAuthGrantType) {
            this.oAuthGrantType = oAuthGrantType;
            return this;
        }

        @Override
        @Transient
        public final Builder oAuthGrantType(OAuthGrantType oAuthGrantType) {
            this.oAuthGrantType(oAuthGrantType == null ? null : oAuthGrantType.toString());
            return this;
        }

        public final Collection<String> getOAuthScopes() {
            if (this.oAuthScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.oAuthScopes;
        }

        public final void setOAuthScopes(Collection<String> oAuthScopes) {
            this.oAuthScopes = ListOfOAuthScopesElementCopier.copy(oAuthScopes);
        }

        @Override
        @Transient
        public final Builder oAuthScopesWithStrings(Collection<String> oAuthScopes) {
            this.oAuthScopes = ListOfOAuthScopesElementCopier.copy(oAuthScopes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder oAuthScopesWithStrings(String ... oAuthScopes) {
            this.oAuthScopesWithStrings(Arrays.asList(oAuthScopes));
            return this;
        }

        @Override
        @Transient
        public final Builder oAuthScopes(Collection<OAuthScopesElement> oAuthScopes) {
            this.oAuthScopes = ListOfOAuthScopesElementCopier.copyEnumToString(oAuthScopes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder oAuthScopes(OAuthScopesElement ... oAuthScopes) {
            this.oAuthScopes(Arrays.asList(oAuthScopes));
            return this;
        }

        public final Collection<String> getRedirectSignInURIs() {
            if (this.redirectSignInURIs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.redirectSignInURIs;
        }

        public final void setRedirectSignInURIs(Collection<String> redirectSignInURIs) {
            this.redirectSignInURIs = ListOf__stringCopier.copy(redirectSignInURIs);
        }

        @Override
        @Transient
        public final Builder redirectSignInURIs(Collection<String> redirectSignInURIs) {
            this.redirectSignInURIs = ListOf__stringCopier.copy(redirectSignInURIs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder redirectSignInURIs(String ... redirectSignInURIs) {
            this.redirectSignInURIs(Arrays.asList(redirectSignInURIs));
            return this;
        }

        public final Collection<String> getRedirectSignOutURIs() {
            if (this.redirectSignOutURIs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.redirectSignOutURIs;
        }

        public final void setRedirectSignOutURIs(Collection<String> redirectSignOutURIs) {
            this.redirectSignOutURIs = ListOf__stringCopier.copy(redirectSignOutURIs);
        }

        @Override
        @Transient
        public final Builder redirectSignOutURIs(Collection<String> redirectSignOutURIs) {
            this.redirectSignOutURIs = ListOf__stringCopier.copy(redirectSignOutURIs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder redirectSignOutURIs(String ... redirectSignOutURIs) {
            this.redirectSignOutURIs(Arrays.asList(redirectSignOutURIs));
            return this;
        }

        public final SocialProviderSettings.Builder getSocialProviderSettings() {
            return this.socialProviderSettings != null ? this.socialProviderSettings.toBuilder() : null;
        }

        public final void setSocialProviderSettings(SocialProviderSettings.BuilderImpl socialProviderSettings) {
            this.socialProviderSettings = socialProviderSettings != null ? socialProviderSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder socialProviderSettings(SocialProviderSettings socialProviderSettings) {
            this.socialProviderSettings = socialProviderSettings;
            return this;
        }

        public CreateBackendAuthOAuthConfig build() {
            return new CreateBackendAuthOAuthConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateBackendAuthOAuthConfig> {
        public Builder domainPrefix(String var1);

        public Builder oAuthGrantType(String var1);

        public Builder oAuthGrantType(OAuthGrantType var1);

        public Builder oAuthScopesWithStrings(Collection<String> var1);

        public Builder oAuthScopesWithStrings(String ... var1);

        public Builder oAuthScopes(Collection<OAuthScopesElement> var1);

        public Builder oAuthScopes(OAuthScopesElement ... var1);

        public Builder redirectSignInURIs(Collection<String> var1);

        public Builder redirectSignInURIs(String ... var1);

        public Builder redirectSignOutURIs(Collection<String> var1);

        public Builder redirectSignOutURIs(String ... var1);

        public Builder socialProviderSettings(SocialProviderSettings var1);

        default public Builder socialProviderSettings(Consumer<SocialProviderSettings.Builder> socialProviderSettings) {
            return this.socialProviderSettings((SocialProviderSettings)((SocialProviderSettings.Builder)SocialProviderSettings.builder().applyMutation(socialProviderSettings)).build());
        }
    }
}

