/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataEnum;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataEnumsCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataModel;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataModelsCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataNonModel;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataNonModelsCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobGenericDataSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodegenJobGenericDataSchema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodegenJobGenericDataSchema> {
    private static final SdkField<String> DATA_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceType").getter(CodegenJobGenericDataSchema.getter(CodegenJobGenericDataSchema::dataSourceTypeAsString)).setter(CodegenJobGenericDataSchema.setter(Builder::dataSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceType").build()}).build();
    private static final SdkField<Map<String, CodegenGenericDataModel>> MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("models").getter(CodegenJobGenericDataSchema.getter(CodegenJobGenericDataSchema::models)).setter(CodegenJobGenericDataSchema.setter(Builder::models)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodegenGenericDataModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, CodegenGenericDataEnum>> ENUMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("enums").getter(CodegenJobGenericDataSchema.getter(CodegenJobGenericDataSchema::enums)).setter(CodegenJobGenericDataSchema.setter(Builder::enums)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enums").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodegenGenericDataEnum::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, CodegenGenericDataNonModel>> NON_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("nonModels").getter(CodegenJobGenericDataSchema.getter(CodegenJobGenericDataSchema::nonModels)).setter(CodegenJobGenericDataSchema.setter(Builder::nonModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonModels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodegenGenericDataNonModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_TYPE_FIELD, MODELS_FIELD, ENUMS_FIELD, NON_MODELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodegenJobGenericDataSchema.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataSourceType;
    private final Map<String, CodegenGenericDataModel> models;
    private final Map<String, CodegenGenericDataEnum> enums;
    private final Map<String, CodegenGenericDataNonModel> nonModels;

    private CodegenJobGenericDataSchema(BuilderImpl builder) {
        this.dataSourceType = builder.dataSourceType;
        this.models = builder.models;
        this.enums = builder.enums;
        this.nonModels = builder.nonModels;
    }

    public final CodegenJobGenericDataSourceType dataSourceType() {
        return CodegenJobGenericDataSourceType.fromValue(this.dataSourceType);
    }

    public final String dataSourceTypeAsString() {
        return this.dataSourceType;
    }

    public final boolean hasModels() {
        return this.models != null && !(this.models instanceof SdkAutoConstructMap);
    }

    public final Map<String, CodegenGenericDataModel> models() {
        return this.models;
    }

    public final boolean hasEnums() {
        return this.enums != null && !(this.enums instanceof SdkAutoConstructMap);
    }

    public final Map<String, CodegenGenericDataEnum> enums() {
        return this.enums;
    }

    public final boolean hasNonModels() {
        return this.nonModels != null && !(this.nonModels instanceof SdkAutoConstructMap);
    }

    public final Map<String, CodegenGenericDataNonModel> nonModels() {
        return this.nonModels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModels() ? this.models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnums() ? this.enums() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNonModels() ? this.nonModels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodegenJobGenericDataSchema)) {
            return false;
        }
        CodegenJobGenericDataSchema other = (CodegenJobGenericDataSchema)obj;
        return Objects.equals(this.dataSourceTypeAsString(), other.dataSourceTypeAsString()) && this.hasModels() == other.hasModels() && Objects.equals(this.models(), other.models()) && this.hasEnums() == other.hasEnums() && Objects.equals(this.enums(), other.enums()) && this.hasNonModels() == other.hasNonModels() && Objects.equals(this.nonModels(), other.nonModels());
    }

    public final String toString() {
        return ToString.builder((String)"CodegenJobGenericDataSchema").add("DataSourceType", (Object)this.dataSourceTypeAsString()).add("Models", this.hasModels() ? this.models() : null).add("Enums", this.hasEnums() ? this.enums() : null).add("NonModels", this.hasNonModels() ? this.nonModels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSourceType": {
                return Optional.ofNullable(clazz.cast(this.dataSourceTypeAsString()));
            }
            case "models": {
                return Optional.ofNullable(clazz.cast(this.models()));
            }
            case "enums": {
                return Optional.ofNullable(clazz.cast(this.enums()));
            }
            case "nonModels": {
                return Optional.ofNullable(clazz.cast(this.nonModels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataSourceType", DATA_SOURCE_TYPE_FIELD);
        map.put("models", MODELS_FIELD);
        map.put("enums", ENUMS_FIELD);
        map.put("nonModels", NON_MODELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodegenJobGenericDataSchema, T> g) {
        return obj -> g.apply((CodegenJobGenericDataSchema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSourceType;
        private Map<String, CodegenGenericDataModel> models = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, CodegenGenericDataEnum> enums = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, CodegenGenericDataNonModel> nonModels = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodegenJobGenericDataSchema model) {
            this.dataSourceType(model.dataSourceType);
            this.models(model.models);
            this.enums(model.enums);
            this.nonModels(model.nonModels);
        }

        public final String getDataSourceType() {
            return this.dataSourceType;
        }

        public final void setDataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
        }

        @Override
        public final Builder dataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        @Override
        public final Builder dataSourceType(CodegenJobGenericDataSourceType dataSourceType) {
            this.dataSourceType(dataSourceType == null ? null : dataSourceType.toString());
            return this;
        }

        public final Map<String, CodegenGenericDataModel.Builder> getModels() {
            Map<String, CodegenGenericDataModel.Builder> result = CodegenGenericDataModelsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setModels(Map<String, CodegenGenericDataModel.BuilderImpl> models) {
            this.models = CodegenGenericDataModelsCopier.copyFromBuilder(models);
        }

        @Override
        public final Builder models(Map<String, CodegenGenericDataModel> models) {
            this.models = CodegenGenericDataModelsCopier.copy(models);
            return this;
        }

        public final Map<String, CodegenGenericDataEnum.Builder> getEnums() {
            Map<String, CodegenGenericDataEnum.Builder> result = CodegenGenericDataEnumsCopier.copyToBuilder(this.enums);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEnums(Map<String, CodegenGenericDataEnum.BuilderImpl> enums) {
            this.enums = CodegenGenericDataEnumsCopier.copyFromBuilder(enums);
        }

        @Override
        public final Builder enums(Map<String, CodegenGenericDataEnum> enums) {
            this.enums = CodegenGenericDataEnumsCopier.copy(enums);
            return this;
        }

        public final Map<String, CodegenGenericDataNonModel.Builder> getNonModels() {
            Map<String, CodegenGenericDataNonModel.Builder> result = CodegenGenericDataNonModelsCopier.copyToBuilder(this.nonModels);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setNonModels(Map<String, CodegenGenericDataNonModel.BuilderImpl> nonModels) {
            this.nonModels = CodegenGenericDataNonModelsCopier.copyFromBuilder(nonModels);
        }

        @Override
        public final Builder nonModels(Map<String, CodegenGenericDataNonModel> nonModels) {
            this.nonModels = CodegenGenericDataNonModelsCopier.copy(nonModels);
            return this;
        }

        public CodegenJobGenericDataSchema build() {
            return new CodegenJobGenericDataSchema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodegenJobGenericDataSchema> {
        public Builder dataSourceType(String var1);

        public Builder dataSourceType(CodegenJobGenericDataSourceType var1);

        public Builder models(Map<String, CodegenGenericDataModel> var1);

        public Builder enums(Map<String, CodegenGenericDataEnum> var1);

        public Builder nonModels(Map<String, CodegenGenericDataNonModel> var1);
    }
}

