/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SdkConfigurationProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SdkConfigurationProperty> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(SdkConfigurationProperty.getter(SdkConfigurationProperty::name)).setter(SdkConfigurationProperty.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> FRIENDLY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("friendlyName").getter(SdkConfigurationProperty.getter(SdkConfigurationProperty::friendlyName)).setter(SdkConfigurationProperty.setter(Builder::friendlyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("friendlyName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(SdkConfigurationProperty.getter(SdkConfigurationProperty::description)).setter(SdkConfigurationProperty.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("required").getter(SdkConfigurationProperty.getter(SdkConfigurationProperty::required)).setter(SdkConfigurationProperty.setter(Builder::required)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultValue").getter(SdkConfigurationProperty.getter(SdkConfigurationProperty::defaultValue)).setter(SdkConfigurationProperty.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FRIENDLY_NAME_FIELD, DESCRIPTION_FIELD, REQUIRED_FIELD, DEFAULT_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SdkConfigurationProperty.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String friendlyName;
    private final String description;
    private final Boolean required;
    private final String defaultValue;

    private SdkConfigurationProperty(BuilderImpl builder) {
        this.name = builder.name;
        this.friendlyName = builder.friendlyName;
        this.description = builder.description;
        this.required = builder.required;
        this.defaultValue = builder.defaultValue;
    }

    public final String name() {
        return this.name;
    }

    public final String friendlyName() {
        return this.friendlyName;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean required() {
        return this.required;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.friendlyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.required());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SdkConfigurationProperty)) {
            return false;
        }
        SdkConfigurationProperty other = (SdkConfigurationProperty)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.friendlyName(), other.friendlyName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.required(), other.required()) && Objects.equals(this.defaultValue(), other.defaultValue());
    }

    public final String toString() {
        return ToString.builder((String)"SdkConfigurationProperty").add("Name", (Object)this.name()).add("FriendlyName", (Object)this.friendlyName()).add("Description", (Object)this.description()).add("Required", (Object)this.required()).add("DefaultValue", (Object)this.defaultValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "friendlyName": {
                return Optional.ofNullable(clazz.cast(this.friendlyName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "required": {
                return Optional.ofNullable(clazz.cast(this.required()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("friendlyName", FRIENDLY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("required", REQUIRED_FIELD);
        map.put("defaultValue", DEFAULT_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SdkConfigurationProperty, T> g) {
        return obj -> g.apply((SdkConfigurationProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String friendlyName;
        private String description;
        private Boolean required;
        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SdkConfigurationProperty model) {
            this.name(model.name);
            this.friendlyName(model.friendlyName);
            this.description(model.description);
            this.required(model.required);
            this.defaultValue(model.defaultValue);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFriendlyName() {
            return this.friendlyName;
        }

        public final void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        @Override
        public final Builder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getRequired() {
            return this.required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public SdkConfigurationProperty build() {
            return new SdkConfigurationProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SdkConfigurationProperty> {
        public Builder name(String var1);

        public Builder friendlyName(String var1);

        public Builder description(String var1);

        public Builder required(Boolean var1);

        public Builder defaultValue(String var1);
    }
}

