/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Response;
import software.amazon.awssdk.services.apigatewayv2.model.DisplayContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProductPageResponse
extends ApiGatewayV2Response
implements ToCopyableBuilder<Builder, CreateProductPageResponse> {
    private static final SdkField<DisplayContent> DISPLAY_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisplayContent").getter(CreateProductPageResponse.getter(CreateProductPageResponse::displayContent)).setter(CreateProductPageResponse.setter(Builder::displayContent)).constructor(DisplayContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayContent").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(CreateProductPageResponse.getter(CreateProductPageResponse::lastModified)).setter(CreateProductPageResponse.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> PRODUCT_PAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductPageArn").getter(CreateProductPageResponse.getter(CreateProductPageResponse::productPageArn)).setter(CreateProductPageResponse.setter(Builder::productPageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productPageArn").build()}).build();
    private static final SdkField<String> PRODUCT_PAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductPageId").getter(CreateProductPageResponse.getter(CreateProductPageResponse::productPageId)).setter(CreateProductPageResponse.setter(Builder::productPageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productPageId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_CONTENT_FIELD, LAST_MODIFIED_FIELD, PRODUCT_PAGE_ARN_FIELD, PRODUCT_PAGE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProductPageResponse.memberNameToFieldInitializer();
    private final DisplayContent displayContent;
    private final Instant lastModified;
    private final String productPageArn;
    private final String productPageId;

    private CreateProductPageResponse(BuilderImpl builder) {
        super(builder);
        this.displayContent = builder.displayContent;
        this.lastModified = builder.lastModified;
        this.productPageArn = builder.productPageArn;
        this.productPageId = builder.productPageId;
    }

    public final DisplayContent displayContent() {
        return this.displayContent;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final String productPageArn() {
        return this.productPageArn;
    }

    public final String productPageId() {
        return this.productPageId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.displayContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.productPageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.productPageId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProductPageResponse)) {
            return false;
        }
        CreateProductPageResponse other = (CreateProductPageResponse)((Object)obj);
        return Objects.equals(this.displayContent(), other.displayContent()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.productPageArn(), other.productPageArn()) && Objects.equals(this.productPageId(), other.productPageId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProductPageResponse").add("DisplayContent", (Object)this.displayContent()).add("LastModified", (Object)this.lastModified()).add("ProductPageArn", (Object)this.productPageArn()).add("ProductPageId", (Object)this.productPageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisplayContent": {
                return Optional.ofNullable(clazz.cast(this.displayContent()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "ProductPageArn": {
                return Optional.ofNullable(clazz.cast(this.productPageArn()));
            }
            case "ProductPageId": {
                return Optional.ofNullable(clazz.cast(this.productPageId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("displayContent", DISPLAY_CONTENT_FIELD);
        map.put("lastModified", LAST_MODIFIED_FIELD);
        map.put("productPageArn", PRODUCT_PAGE_ARN_FIELD);
        map.put("productPageId", PRODUCT_PAGE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProductPageResponse, T> g) {
        return obj -> g.apply((CreateProductPageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Response.BuilderImpl
    implements Builder {
        private DisplayContent displayContent;
        private Instant lastModified;
        private String productPageArn;
        private String productPageId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProductPageResponse model) {
            super(model);
            this.displayContent(model.displayContent);
            this.lastModified(model.lastModified);
            this.productPageArn(model.productPageArn);
            this.productPageId(model.productPageId);
        }

        public final DisplayContent.Builder getDisplayContent() {
            return this.displayContent != null ? this.displayContent.toBuilder() : null;
        }

        public final void setDisplayContent(DisplayContent.BuilderImpl displayContent) {
            this.displayContent = displayContent != null ? displayContent.build() : null;
        }

        @Override
        public final Builder displayContent(DisplayContent displayContent) {
            this.displayContent = displayContent;
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getProductPageArn() {
            return this.productPageArn;
        }

        public final void setProductPageArn(String productPageArn) {
            this.productPageArn = productPageArn;
        }

        @Override
        public final Builder productPageArn(String productPageArn) {
            this.productPageArn = productPageArn;
            return this;
        }

        public final String getProductPageId() {
            return this.productPageId;
        }

        public final void setProductPageId(String productPageId) {
            this.productPageId = productPageId;
        }

        @Override
        public final Builder productPageId(String productPageId) {
            this.productPageId = productPageId;
            return this;
        }

        @Override
        public CreateProductPageResponse build() {
            return new CreateProductPageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProductPageResponse> {
        public Builder displayContent(DisplayContent var1);

        default public Builder displayContent(Consumer<DisplayContent.Builder> displayContent) {
            return this.displayContent((DisplayContent)((DisplayContent.Builder)DisplayContent.builder().applyMutation(displayContent)).build());
        }

        public Builder lastModified(Instant var1);

        public Builder productPageArn(String var1);

        public Builder productPageId(String var1);
    }
}

