/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigatewayv2.ApiGatewayV2Client;
import software.amazon.awssdk.services.apigatewayv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigatewayv2.model.ListPortalProductsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ListPortalProductsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.PortalProductSummary;

public class ListPortalProductsIterable
implements SdkIterable<ListPortalProductsResponse> {
    private final ApiGatewayV2Client client;
    private final ListPortalProductsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPortalProductsIterable(ApiGatewayV2Client client, ListPortalProductsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPortalProductsResponseFetcher();
    }

    public Iterator<ListPortalProductsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PortalProductSummary> items() {
        Function<ListPortalProductsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPortalProductsResponseFetcher
    implements SyncPageFetcher<ListPortalProductsResponse> {
        private ListPortalProductsResponseFetcher() {
        }

        public boolean hasNextPage(ListPortalProductsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPortalProductsResponse nextPage(ListPortalProductsResponse previousPage) {
            if (previousPage == null) {
                return ListPortalProductsIterable.this.client.listPortalProducts(ListPortalProductsIterable.this.firstRequest);
            }
            return ListPortalProductsIterable.this.client.listPortalProducts((ListPortalProductsRequest)((Object)ListPortalProductsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

