/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.CognitoConfig;
import software.amazon.awssdk.services.apigatewayv2.model.None;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Authorization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Authorization> {
    private static final SdkField<CognitoConfig> COGNITO_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CognitoConfig").getter(Authorization.getter(Authorization::cognitoConfig)).setter(Authorization.setter(Builder::cognitoConfig)).constructor(CognitoConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cognitoConfig").build()}).build();
    private static final SdkField<None> NONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("None").getter(Authorization.getter(Authorization::none)).setter(Authorization.setter(Builder::none)).constructor(None::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("none").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COGNITO_CONFIG_FIELD, NONE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Authorization.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CognitoConfig cognitoConfig;
    private final None none;

    private Authorization(BuilderImpl builder) {
        this.cognitoConfig = builder.cognitoConfig;
        this.none = builder.none;
    }

    public final CognitoConfig cognitoConfig() {
        return this.cognitoConfig;
    }

    public final None none() {
        return this.none;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.none());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Authorization)) {
            return false;
        }
        Authorization other = (Authorization)obj;
        return Objects.equals(this.cognitoConfig(), other.cognitoConfig()) && Objects.equals(this.none(), other.none());
    }

    public final String toString() {
        return ToString.builder((String)"Authorization").add("CognitoConfig", (Object)this.cognitoConfig()).add("None", (Object)this.none()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CognitoConfig": {
                return Optional.ofNullable(clazz.cast(this.cognitoConfig()));
            }
            case "None": {
                return Optional.ofNullable(clazz.cast(this.none()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cognitoConfig", COGNITO_CONFIG_FIELD);
        map.put("none", NONE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Authorization, T> g) {
        return obj -> g.apply((Authorization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CognitoConfig cognitoConfig;
        private None none;

        private BuilderImpl() {
        }

        private BuilderImpl(Authorization model) {
            this.cognitoConfig(model.cognitoConfig);
            this.none(model.none);
        }

        public final CognitoConfig.Builder getCognitoConfig() {
            return this.cognitoConfig != null ? this.cognitoConfig.toBuilder() : null;
        }

        public final void setCognitoConfig(CognitoConfig.BuilderImpl cognitoConfig) {
            this.cognitoConfig = cognitoConfig != null ? cognitoConfig.build() : null;
        }

        @Override
        public final Builder cognitoConfig(CognitoConfig cognitoConfig) {
            this.cognitoConfig = cognitoConfig;
            return this;
        }

        public final None.Builder getNone() {
            return this.none != null ? this.none.toBuilder() : null;
        }

        public final void setNone(None.BuilderImpl none) {
            this.none = none != null ? none.build() : null;
        }

        @Override
        public final Builder none(None none) {
            this.none = none;
            return this;
        }

        public Authorization build() {
            return new Authorization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Authorization> {
        public Builder cognitoConfig(CognitoConfig var1);

        default public Builder cognitoConfig(Consumer<CognitoConfig.Builder> cognitoConfig) {
            return this.cognitoConfig((CognitoConfig)((CognitoConfig.Builder)CognitoConfig.builder().applyMutation(cognitoConfig)).build());
        }

        public Builder none(None var1);

        default public Builder none(Consumer<None.Builder> none) {
            return this.none((None)((None.Builder)None.builder().applyMutation(none)).build());
        }
    }
}

