/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointDisplayContentResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointDisplayContentResponse> {
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(EndpointDisplayContentResponse.getter(EndpointDisplayContentResponse::body)).setter(EndpointDisplayContentResponse.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(EndpointDisplayContentResponse.getter(EndpointDisplayContentResponse::endpoint)).setter(EndpointDisplayContentResponse.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationName").getter(EndpointDisplayContentResponse.getter(EndpointDisplayContentResponse::operationName)).setter(EndpointDisplayContentResponse.setter(Builder::operationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, ENDPOINT_FIELD, OPERATION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EndpointDisplayContentResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String body;
    private final String endpoint;
    private final String operationName;

    private EndpointDisplayContentResponse(BuilderImpl builder) {
        this.body = builder.body;
        this.endpoint = builder.endpoint;
        this.operationName = builder.operationName;
    }

    public final String body() {
        return this.body;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String operationName() {
        return this.operationName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointDisplayContentResponse)) {
            return false;
        }
        EndpointDisplayContentResponse other = (EndpointDisplayContentResponse)obj;
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.operationName(), other.operationName());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointDisplayContentResponse").add("Body", (Object)this.body()).add("Endpoint", (Object)this.endpoint()).add("OperationName", (Object)this.operationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "OperationName": {
                return Optional.ofNullable(clazz.cast(this.operationName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("body", BODY_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("operationName", OPERATION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointDisplayContentResponse, T> g) {
        return obj -> g.apply((EndpointDisplayContentResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String body;
        private String endpoint;
        private String operationName;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointDisplayContentResponse model) {
            this.body(model.body);
            this.endpoint(model.endpoint);
            this.operationName(model.operationName);
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getOperationName() {
            return this.operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public EndpointDisplayContentResponse build() {
            return new EndpointDisplayContentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointDisplayContentResponse> {
        public Builder body(String var1);

        public Builder endpoint(String var1);

        public Builder operationName(String var1);
    }
}

