/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.Authorization;
import software.amazon.awssdk.services.apigatewayv2.model.EndpointConfigurationResponse;
import software.amazon.awssdk.services.apigatewayv2.model.PortalContent;
import software.amazon.awssdk.services.apigatewayv2.model.Preview;
import software.amazon.awssdk.services.apigatewayv2.model.PublishStatus;
import software.amazon.awssdk.services.apigatewayv2.model.StatusException;
import software.amazon.awssdk.services.apigatewayv2.model.TagsCopier;
import software.amazon.awssdk.services.apigatewayv2.model.___listOf__stringMin20Max2048Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PortalSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PortalSummary> {
    private static final SdkField<Authorization> AUTHORIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Authorization").getter(PortalSummary.getter(PortalSummary::authorization)).setter(PortalSummary.setter(Builder::authorization)).constructor(Authorization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorization").build()}).build();
    private static final SdkField<EndpointConfigurationResponse> ENDPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointConfiguration").getter(PortalSummary.getter(PortalSummary::endpointConfiguration)).setter(PortalSummary.setter(Builder::endpointConfiguration)).constructor(EndpointConfigurationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfiguration").build()}).build();
    private static final SdkField<List<String>> INCLUDED_PORTAL_PRODUCT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludedPortalProductArns").getter(PortalSummary.getter(PortalSummary::includedPortalProductArns)).setter(PortalSummary.setter(Builder::includedPortalProductArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includedPortalProductArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(PortalSummary.getter(PortalSummary::lastModified)).setter(PortalSummary.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_PUBLISHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastPublished").getter(PortalSummary.getter(PortalSummary::lastPublished)).setter(PortalSummary.setter(Builder::lastPublished)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastPublished").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> LAST_PUBLISHED_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastPublishedDescription").getter(PortalSummary.getter(PortalSummary::lastPublishedDescription)).setter(PortalSummary.setter(Builder::lastPublishedDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastPublishedDescription").build()}).build();
    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortalArn").getter(PortalSummary.getter(PortalSummary::portalArn)).setter(PortalSummary.setter(Builder::portalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalArn").build()}).build();
    private static final SdkField<PortalContent> PORTAL_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PortalContent").getter(PortalSummary.getter(PortalSummary::portalContent)).setter(PortalSummary.setter(Builder::portalContent)).constructor(PortalContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalContent").build()}).build();
    private static final SdkField<String> PORTAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortalId").getter(PortalSummary.getter(PortalSummary::portalId)).setter(PortalSummary.setter(Builder::portalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalId").build()}).build();
    private static final SdkField<Preview> PREVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Preview").getter(PortalSummary.getter(PortalSummary::preview)).setter(PortalSummary.setter(Builder::preview)).constructor(Preview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preview").build()}).build();
    private static final SdkField<String> PUBLISH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublishStatus").getter(PortalSummary.getter(PortalSummary::publishStatusAsString)).setter(PortalSummary.setter(Builder::publishStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publishStatus").build()}).build();
    private static final SdkField<String> RUM_APP_MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RumAppMonitorName").getter(PortalSummary.getter(PortalSummary::rumAppMonitorName)).setter(PortalSummary.setter(Builder::rumAppMonitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rumAppMonitorName").build()}).build();
    private static final SdkField<StatusException> STATUS_EXCEPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatusException").getter(PortalSummary.getter(PortalSummary::statusException)).setter(PortalSummary.setter(Builder::statusException)).constructor(StatusException::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusException").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(PortalSummary.getter(PortalSummary::tags)).setter(PortalSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_FIELD, ENDPOINT_CONFIGURATION_FIELD, INCLUDED_PORTAL_PRODUCT_ARNS_FIELD, LAST_MODIFIED_FIELD, LAST_PUBLISHED_FIELD, LAST_PUBLISHED_DESCRIPTION_FIELD, PORTAL_ARN_FIELD, PORTAL_CONTENT_FIELD, PORTAL_ID_FIELD, PREVIEW_FIELD, PUBLISH_STATUS_FIELD, RUM_APP_MONITOR_NAME_FIELD, STATUS_EXCEPTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PortalSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Authorization authorization;
    private final EndpointConfigurationResponse endpointConfiguration;
    private final List<String> includedPortalProductArns;
    private final Instant lastModified;
    private final Instant lastPublished;
    private final String lastPublishedDescription;
    private final String portalArn;
    private final PortalContent portalContent;
    private final String portalId;
    private final Preview preview;
    private final String publishStatus;
    private final String rumAppMonitorName;
    private final StatusException statusException;
    private final Map<String, String> tags;

    private PortalSummary(BuilderImpl builder) {
        this.authorization = builder.authorization;
        this.endpointConfiguration = builder.endpointConfiguration;
        this.includedPortalProductArns = builder.includedPortalProductArns;
        this.lastModified = builder.lastModified;
        this.lastPublished = builder.lastPublished;
        this.lastPublishedDescription = builder.lastPublishedDescription;
        this.portalArn = builder.portalArn;
        this.portalContent = builder.portalContent;
        this.portalId = builder.portalId;
        this.preview = builder.preview;
        this.publishStatus = builder.publishStatus;
        this.rumAppMonitorName = builder.rumAppMonitorName;
        this.statusException = builder.statusException;
        this.tags = builder.tags;
    }

    public final Authorization authorization() {
        return this.authorization;
    }

    public final EndpointConfigurationResponse endpointConfiguration() {
        return this.endpointConfiguration;
    }

    public final boolean hasIncludedPortalProductArns() {
        return this.includedPortalProductArns != null && !(this.includedPortalProductArns instanceof SdkAutoConstructList);
    }

    public final List<String> includedPortalProductArns() {
        return this.includedPortalProductArns;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final Instant lastPublished() {
        return this.lastPublished;
    }

    public final String lastPublishedDescription() {
        return this.lastPublishedDescription;
    }

    public final String portalArn() {
        return this.portalArn;
    }

    public final PortalContent portalContent() {
        return this.portalContent;
    }

    public final String portalId() {
        return this.portalId;
    }

    public final Preview preview() {
        return this.preview;
    }

    public final PublishStatus publishStatus() {
        return PublishStatus.fromValue(this.publishStatus);
    }

    public final String publishStatusAsString() {
        return this.publishStatus;
    }

    public final String rumAppMonitorName() {
        return this.rumAppMonitorName;
    }

    public final StatusException statusException() {
        return this.statusException;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorization());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludedPortalProductArns() ? this.includedPortalProductArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastPublished());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastPublishedDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.preview());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rumAppMonitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusException());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortalSummary)) {
            return false;
        }
        PortalSummary other = (PortalSummary)obj;
        return Objects.equals(this.authorization(), other.authorization()) && Objects.equals(this.endpointConfiguration(), other.endpointConfiguration()) && this.hasIncludedPortalProductArns() == other.hasIncludedPortalProductArns() && Objects.equals(this.includedPortalProductArns(), other.includedPortalProductArns()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.lastPublished(), other.lastPublished()) && Objects.equals(this.lastPublishedDescription(), other.lastPublishedDescription()) && Objects.equals(this.portalArn(), other.portalArn()) && Objects.equals(this.portalContent(), other.portalContent()) && Objects.equals(this.portalId(), other.portalId()) && Objects.equals(this.preview(), other.preview()) && Objects.equals(this.publishStatusAsString(), other.publishStatusAsString()) && Objects.equals(this.rumAppMonitorName(), other.rumAppMonitorName()) && Objects.equals(this.statusException(), other.statusException()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"PortalSummary").add("Authorization", (Object)this.authorization()).add("EndpointConfiguration", (Object)this.endpointConfiguration()).add("IncludedPortalProductArns", this.hasIncludedPortalProductArns() ? this.includedPortalProductArns() : null).add("LastModified", (Object)this.lastModified()).add("LastPublished", (Object)this.lastPublished()).add("LastPublishedDescription", (Object)this.lastPublishedDescription()).add("PortalArn", (Object)this.portalArn()).add("PortalContent", (Object)this.portalContent()).add("PortalId", (Object)this.portalId()).add("Preview", (Object)this.preview()).add("PublishStatus", (Object)this.publishStatusAsString()).add("RumAppMonitorName", (Object)this.rumAppMonitorName()).add("StatusException", (Object)this.statusException()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Authorization": {
                return Optional.ofNullable(clazz.cast(this.authorization()));
            }
            case "EndpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointConfiguration()));
            }
            case "IncludedPortalProductArns": {
                return Optional.ofNullable(clazz.cast(this.includedPortalProductArns()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "LastPublished": {
                return Optional.ofNullable(clazz.cast(this.lastPublished()));
            }
            case "LastPublishedDescription": {
                return Optional.ofNullable(clazz.cast(this.lastPublishedDescription()));
            }
            case "PortalArn": {
                return Optional.ofNullable(clazz.cast(this.portalArn()));
            }
            case "PortalContent": {
                return Optional.ofNullable(clazz.cast(this.portalContent()));
            }
            case "PortalId": {
                return Optional.ofNullable(clazz.cast(this.portalId()));
            }
            case "Preview": {
                return Optional.ofNullable(clazz.cast(this.preview()));
            }
            case "PublishStatus": {
                return Optional.ofNullable(clazz.cast(this.publishStatusAsString()));
            }
            case "RumAppMonitorName": {
                return Optional.ofNullable(clazz.cast(this.rumAppMonitorName()));
            }
            case "StatusException": {
                return Optional.ofNullable(clazz.cast(this.statusException()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("authorization", AUTHORIZATION_FIELD);
        map.put("endpointConfiguration", ENDPOINT_CONFIGURATION_FIELD);
        map.put("includedPortalProductArns", INCLUDED_PORTAL_PRODUCT_ARNS_FIELD);
        map.put("lastModified", LAST_MODIFIED_FIELD);
        map.put("lastPublished", LAST_PUBLISHED_FIELD);
        map.put("lastPublishedDescription", LAST_PUBLISHED_DESCRIPTION_FIELD);
        map.put("portalArn", PORTAL_ARN_FIELD);
        map.put("portalContent", PORTAL_CONTENT_FIELD);
        map.put("portalId", PORTAL_ID_FIELD);
        map.put("preview", PREVIEW_FIELD);
        map.put("publishStatus", PUBLISH_STATUS_FIELD);
        map.put("rumAppMonitorName", RUM_APP_MONITOR_NAME_FIELD);
        map.put("statusException", STATUS_EXCEPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PortalSummary, T> g) {
        return obj -> g.apply((PortalSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Authorization authorization;
        private EndpointConfigurationResponse endpointConfiguration;
        private List<String> includedPortalProductArns = DefaultSdkAutoConstructList.getInstance();
        private Instant lastModified;
        private Instant lastPublished;
        private String lastPublishedDescription;
        private String portalArn;
        private PortalContent portalContent;
        private String portalId;
        private Preview preview;
        private String publishStatus;
        private String rumAppMonitorName;
        private StatusException statusException;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PortalSummary model) {
            this.authorization(model.authorization);
            this.endpointConfiguration(model.endpointConfiguration);
            this.includedPortalProductArns(model.includedPortalProductArns);
            this.lastModified(model.lastModified);
            this.lastPublished(model.lastPublished);
            this.lastPublishedDescription(model.lastPublishedDescription);
            this.portalArn(model.portalArn);
            this.portalContent(model.portalContent);
            this.portalId(model.portalId);
            this.preview(model.preview);
            this.publishStatus(model.publishStatus);
            this.rumAppMonitorName(model.rumAppMonitorName);
            this.statusException(model.statusException);
            this.tags(model.tags);
        }

        public final Authorization.Builder getAuthorization() {
            return this.authorization != null ? this.authorization.toBuilder() : null;
        }

        public final void setAuthorization(Authorization.BuilderImpl authorization) {
            this.authorization = authorization != null ? authorization.build() : null;
        }

        @Override
        public final Builder authorization(Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        public final EndpointConfigurationResponse.Builder getEndpointConfiguration() {
            return this.endpointConfiguration != null ? this.endpointConfiguration.toBuilder() : null;
        }

        public final void setEndpointConfiguration(EndpointConfigurationResponse.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointConfigurationResponse endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final Collection<String> getIncludedPortalProductArns() {
            if (this.includedPortalProductArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includedPortalProductArns;
        }

        public final void setIncludedPortalProductArns(Collection<String> includedPortalProductArns) {
            this.includedPortalProductArns = ___listOf__stringMin20Max2048Copier.copy(includedPortalProductArns);
        }

        @Override
        public final Builder includedPortalProductArns(Collection<String> includedPortalProductArns) {
            this.includedPortalProductArns = ___listOf__stringMin20Max2048Copier.copy(includedPortalProductArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedPortalProductArns(String ... includedPortalProductArns) {
            this.includedPortalProductArns(Arrays.asList(includedPortalProductArns));
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final Instant getLastPublished() {
            return this.lastPublished;
        }

        public final void setLastPublished(Instant lastPublished) {
            this.lastPublished = lastPublished;
        }

        @Override
        public final Builder lastPublished(Instant lastPublished) {
            this.lastPublished = lastPublished;
            return this;
        }

        public final String getLastPublishedDescription() {
            return this.lastPublishedDescription;
        }

        public final void setLastPublishedDescription(String lastPublishedDescription) {
            this.lastPublishedDescription = lastPublishedDescription;
        }

        @Override
        public final Builder lastPublishedDescription(String lastPublishedDescription) {
            this.lastPublishedDescription = lastPublishedDescription;
            return this;
        }

        public final String getPortalArn() {
            return this.portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        public final PortalContent.Builder getPortalContent() {
            return this.portalContent != null ? this.portalContent.toBuilder() : null;
        }

        public final void setPortalContent(PortalContent.BuilderImpl portalContent) {
            this.portalContent = portalContent != null ? portalContent.build() : null;
        }

        @Override
        public final Builder portalContent(PortalContent portalContent) {
            this.portalContent = portalContent;
            return this;
        }

        public final String getPortalId() {
            return this.portalId;
        }

        public final void setPortalId(String portalId) {
            this.portalId = portalId;
        }

        @Override
        public final Builder portalId(String portalId) {
            this.portalId = portalId;
            return this;
        }

        public final Preview.Builder getPreview() {
            return this.preview != null ? this.preview.toBuilder() : null;
        }

        public final void setPreview(Preview.BuilderImpl preview) {
            this.preview = preview != null ? preview.build() : null;
        }

        @Override
        public final Builder preview(Preview preview) {
            this.preview = preview;
            return this;
        }

        public final String getPublishStatus() {
            return this.publishStatus;
        }

        public final void setPublishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
        }

        @Override
        public final Builder publishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
            return this;
        }

        @Override
        public final Builder publishStatus(PublishStatus publishStatus) {
            this.publishStatus(publishStatus == null ? null : publishStatus.toString());
            return this;
        }

        public final String getRumAppMonitorName() {
            return this.rumAppMonitorName;
        }

        public final void setRumAppMonitorName(String rumAppMonitorName) {
            this.rumAppMonitorName = rumAppMonitorName;
        }

        @Override
        public final Builder rumAppMonitorName(String rumAppMonitorName) {
            this.rumAppMonitorName = rumAppMonitorName;
            return this;
        }

        public final StatusException.Builder getStatusException() {
            return this.statusException != null ? this.statusException.toBuilder() : null;
        }

        public final void setStatusException(StatusException.BuilderImpl statusException) {
            this.statusException = statusException != null ? statusException.build() : null;
        }

        @Override
        public final Builder statusException(StatusException statusException) {
            this.statusException = statusException;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public PortalSummary build() {
            return new PortalSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PortalSummary> {
        public Builder authorization(Authorization var1);

        default public Builder authorization(Consumer<Authorization.Builder> authorization) {
            return this.authorization((Authorization)((Authorization.Builder)Authorization.builder().applyMutation(authorization)).build());
        }

        public Builder endpointConfiguration(EndpointConfigurationResponse var1);

        default public Builder endpointConfiguration(Consumer<EndpointConfigurationResponse.Builder> endpointConfiguration) {
            return this.endpointConfiguration((EndpointConfigurationResponse)((EndpointConfigurationResponse.Builder)EndpointConfigurationResponse.builder().applyMutation(endpointConfiguration)).build());
        }

        public Builder includedPortalProductArns(Collection<String> var1);

        public Builder includedPortalProductArns(String ... var1);

        public Builder lastModified(Instant var1);

        public Builder lastPublished(Instant var1);

        public Builder lastPublishedDescription(String var1);

        public Builder portalArn(String var1);

        public Builder portalContent(PortalContent var1);

        default public Builder portalContent(Consumer<PortalContent.Builder> portalContent) {
            return this.portalContent((PortalContent)((PortalContent.Builder)PortalContent.builder().applyMutation(portalContent)).build());
        }

        public Builder portalId(String var1);

        public Builder preview(Preview var1);

        default public Builder preview(Consumer<Preview.Builder> preview) {
            return this.preview((Preview)((Preview.Builder)Preview.builder().applyMutation(preview)).build());
        }

        public Builder publishStatus(String var1);

        public Builder publishStatus(PublishStatus var1);

        public Builder rumAppMonitorName(String var1);

        public Builder statusException(StatusException var1);

        default public Builder statusException(Consumer<StatusException.Builder> statusException) {
            return this.statusException((StatusException)((StatusException.Builder)StatusException.builder().applyMutation(statusException)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

