/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PublishStatus {
    PUBLISHED("PUBLISHED"),
    PUBLISH_IN_PROGRESS("PUBLISH_IN_PROGRESS"),
    PUBLISH_FAILED("PUBLISH_FAILED"),
    DISABLED("DISABLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PublishStatus> VALUE_MAP;
    private final String value;

    private PublishStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PublishStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PublishStatus> knownValues() {
        EnumSet<PublishStatus> knownValues = EnumSet.allOf(PublishStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PublishStatus.class, PublishStatus::toString);
    }
}

