/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigatewayv2.ApiGatewayV2AsyncClient;
import software.amazon.awssdk.services.apigatewayv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigatewayv2.model.ListPortalProductsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ListPortalProductsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.PortalProductSummary;

public class ListPortalProductsPublisher
implements SdkPublisher<ListPortalProductsResponse> {
    private final ApiGatewayV2AsyncClient client;
    private final ListPortalProductsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPortalProductsPublisher(ApiGatewayV2AsyncClient client, ListPortalProductsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPortalProductsPublisher(ApiGatewayV2AsyncClient client, ListPortalProductsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPortalProductsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPortalProductsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PortalProductSummary> items() {
        Function<ListPortalProductsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPortalProductsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPortalProductsResponseFetcher
    implements AsyncPageFetcher<ListPortalProductsResponse> {
        private ListPortalProductsResponseFetcher() {
        }

        public boolean hasNextPage(ListPortalProductsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPortalProductsResponse> nextPage(ListPortalProductsResponse previousPage) {
            if (previousPage == null) {
                return ListPortalProductsPublisher.this.client.listPortalProducts(ListPortalProductsPublisher.this.firstRequest);
            }
            return ListPortalProductsPublisher.this.client.listPortalProducts((ListPortalProductsRequest)((Object)ListPortalProductsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

