/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigatewayv2.ApiGatewayV2AsyncClient;
import software.amazon.awssdk.services.apigatewayv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigatewayv2.model.ListProductRestEndpointPagesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ListProductRestEndpointPagesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.ProductRestEndpointPageSummaryNoBody;

public class ListProductRestEndpointPagesPublisher
implements SdkPublisher<ListProductRestEndpointPagesResponse> {
    private final ApiGatewayV2AsyncClient client;
    private final ListProductRestEndpointPagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProductRestEndpointPagesPublisher(ApiGatewayV2AsyncClient client, ListProductRestEndpointPagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProductRestEndpointPagesPublisher(ApiGatewayV2AsyncClient client, ListProductRestEndpointPagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProductRestEndpointPagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProductRestEndpointPagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProductRestEndpointPageSummaryNoBody> items() {
        Function<ListProductRestEndpointPagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProductRestEndpointPagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProductRestEndpointPagesResponseFetcher
    implements AsyncPageFetcher<ListProductRestEndpointPagesResponse> {
        private ListProductRestEndpointPagesResponseFetcher() {
        }

        public boolean hasNextPage(ListProductRestEndpointPagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProductRestEndpointPagesResponse> nextPage(ListProductRestEndpointPagesResponse previousPage) {
            if (previousPage == null) {
                return ListProductRestEndpointPagesPublisher.this.client.listProductRestEndpointPages(ListProductRestEndpointPagesPublisher.this.firstRequest);
            }
            return ListProductRestEndpointPagesPublisher.this.client.listProductRestEndpointPages((ListProductRestEndpointPagesRequest)((Object)ListProductRestEndpointPagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

