/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appconfig.model.AppConfigException;
import software.amazon.awssdk.services.appconfig.model.BytesMeasure;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PayloadTooLargeException
extends AppConfigException
implements ToCopyableBuilder<Builder, PayloadTooLargeException> {
    private static final SdkField<String> MEASURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Measure").getter(PayloadTooLargeException.getter(PayloadTooLargeException::measureAsString)).setter(PayloadTooLargeException.setter(Builder::measure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Measure").build()}).build();
    private static final SdkField<Float> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Limit").getter(PayloadTooLargeException.getter(PayloadTooLargeException::limit)).setter(PayloadTooLargeException.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<Float> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Size").getter(PayloadTooLargeException.getter(PayloadTooLargeException::size)).setter(PayloadTooLargeException.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEASURE_FIELD, LIMIT_FIELD, SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PayloadTooLargeException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String measure;
    private final Float limit;
    private final Float size;

    private PayloadTooLargeException(BuilderImpl builder) {
        super(builder);
        this.measure = builder.measure;
        this.limit = builder.limit;
        this.size = builder.size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public BytesMeasure measure() {
        return BytesMeasure.fromValue(this.measure);
    }

    public String measureAsString() {
        return this.measure;
    }

    public Float limit() {
        return this.limit;
    }

    public Float size() {
        return this.size;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Measure", MEASURE_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("Size", SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PayloadTooLargeException, T> g) {
        return obj -> g.apply((PayloadTooLargeException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigException.BuilderImpl
    implements Builder {
        private String measure;
        private Float limit;
        private Float size;

        private BuilderImpl() {
        }

        private BuilderImpl(PayloadTooLargeException model) {
            super(model);
            this.measure(model.measure);
            this.limit(model.limit);
            this.size(model.size);
        }

        public final String getMeasure() {
            return this.measure;
        }

        public final void setMeasure(String measure) {
            this.measure = measure;
        }

        @Override
        public final Builder measure(String measure) {
            this.measure = measure;
            return this;
        }

        @Override
        public final Builder measure(BytesMeasure measure) {
            this.measure(measure == null ? null : measure.toString());
            return this;
        }

        public final Float getLimit() {
            return this.limit;
        }

        public final void setLimit(Float limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Float limit) {
            this.limit = limit;
            return this;
        }

        public final Float getSize() {
            return this.size;
        }

        public final void setSize(Float size) {
            this.size = size;
        }

        @Override
        public final Builder size(Float size) {
            this.size = size;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public PayloadTooLargeException build() {
            return new PayloadTooLargeException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PayloadTooLargeException>,
    AppConfigException.Builder {
        public Builder measure(String var1);

        public Builder measure(BytesMeasure var1);

        public Builder limit(Float var1);

        public Builder size(Float var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);

        @Override
        public Builder numAttempts(Integer var1);
    }
}

